/*
 * Decompiled with CFR 0.152.
 */
package healpix.essentials;

import healpix.essentials.FastMath;
import healpix.essentials.Pointing;
import healpix.essentials.Zphi;

public class Vec3 {
    public double x;
    public double y;
    public double z;

    public Vec3() {
    }

    public Vec3(Vec3 v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
    }

    public Vec3(double x1, double y1, double z1) {
        this.x = x1;
        this.y = y1;
        this.z = z1;
    }

    public Vec3(Pointing ptg) {
        double sth = FastMath.sin(ptg.theta);
        this.x = sth * FastMath.cos(ptg.phi);
        this.y = sth * FastMath.sin(ptg.phi);
        this.z = FastMath.cos(ptg.theta);
    }

    public Vec3(Zphi zphi) {
        double sth = Math.sqrt((1.0 - zphi.z) * (1.0 + zphi.z));
        this.x = sth * FastMath.cos(zphi.phi);
        this.y = sth * FastMath.sin(zphi.phi);
        this.z = zphi.z;
    }

    public Vec3(double[] arr) {
        if (arr.length != 3) {
            throw new IllegalArgumentException("Wrong array size");
        }
        this.x = arr[0];
        this.y = arr[1];
        this.z = arr[2];
    }

    public final double length() {
        return Math.sqrt(this.lengthSquared());
    }

    public final double lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public void normalize() {
        double d = 1.0 / this.length();
        this.x *= d;
        this.y *= d;
        this.z *= d;
    }

    public Vec3 norm() {
        double d = 1.0 / this.length();
        return new Vec3(this.x * d, this.y * d, this.z * d);
    }

    public final double angle(Vec3 v1) {
        return FastMath.atan2(this.cross(v1).length(), this.dot(v1));
    }

    public Vec3 cross(Vec3 v) {
        return new Vec3(this.y * v.z - v.y * this.z, this.z * v.x - v.z * this.x, this.x * v.y - v.x * this.y);
    }

    public Vec3 mul(double n) {
        return new Vec3(n * this.x, n * this.y, n * this.z);
    }

    public void flip() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
    }

    public Vec3 flipped() {
        return new Vec3(-this.x, -this.y, -this.z);
    }

    public void scale(double n) {
        this.x *= n;
        this.y *= n;
        this.z *= n;
    }

    public final double dot(Vec3 v1) {
        return this.x * v1.x + this.y * v1.y + this.z * v1.z;
    }

    public Vec3 add(Vec3 v) {
        return new Vec3(this.x + v.x, this.y + v.y, this.z + v.z);
    }

    public Vec3 sub(Vec3 v) {
        return new Vec3(this.x - v.x, this.y - v.y, this.z - v.z);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("vec3(");
        s.append(this.x);
        s.append(",");
        s.append(this.y);
        s.append(",");
        s.append(this.z);
        s.append(")");
        return s.toString();
    }

    public double[] toArray() {
        return new double[]{this.x, this.y, this.z};
    }

    public void toArray(double[] arr) {
        if (arr.length != 3) {
            throw new IllegalArgumentException("wrong array size");
        }
        arr[0] = this.x;
        arr[1] = this.y;
        arr[2] = this.z;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vec3 vec3 = (Vec3)o;
        if (Double.compare(vec3.x, this.x) != 0) {
            return false;
        }
        if (Double.compare(vec3.y, this.y) != 0) {
            return false;
        }
        return Double.compare(vec3.z, this.z) == 0;
    }

    public int hashCode() {
        int result = Double.valueOf(this.x).hashCode();
        result = 31 * result + Double.valueOf(this.y).hashCode();
        result = 31 * result + Double.valueOf(this.z).hashCode();
        return result;
    }
}

