/*
 * Decompiled with CFR 0.152.
 */
package healpix.essentials;

import healpix.essentials.Moc;
import healpix.essentials.RangeSet;

public class MocStringIO {
    public static Moc mocFromString(String in) {
        in = in.replaceAll(",+", " ");
        in = in.replaceAll("[\\[\\]{}\"]+", "");
        in = in.replaceAll("\\s*[:/]\\s*", "/ ");
        in = in.replaceAll("\\s*-\\s*", "-");
        String[] tok = in.split("[\\s]+");
        RangeSet ru = new RangeSet();
        int order = 0;
        long ofs = 0L;
        for (int i = 0; i < tok.length; ++i) {
            if (tok[i].isEmpty()) continue;
            if (tok[i].contains("/")) {
                tok[i] = tok[i].split("/")[0];
                order = Integer.parseInt(tok[i]);
                ofs = 4L * (1L << 2 * order);
                continue;
            }
            if (tok[i].contains("-")) {
                String[] lim = tok[i].split("-");
                ru.add(Long.parseLong(lim[0]) + ofs, Long.parseLong(lim[1]) + ofs + 1L);
                continue;
            }
            ru.add(Long.parseLong(tok[i]) + ofs);
        }
        return Moc.fromUniqRS(ru);
    }

    private static String mocToStringGeneral(Moc moc, boolean json) {
        RangeSet ru = moc.toUniqRS();
        StringBuilder s = new StringBuilder();
        if (json) {
            s.append("{");
        }
        boolean firstOrder = true;
        int omax = moc.maxOrder();
        for (int o = 0; o <= omax; ++o) {
            RangeSet rt = new RangeSet();
            long offset = 4L * (1L << 2 * o);
            rt.append(offset, 4L * offset);
            rt = rt.intersection(ru);
            boolean prefix = false;
            if (!rt.isEmpty()) {
                for (int iv = 0; iv < rt.nranges(); ++iv) {
                    long a = rt.ivbegin(iv) - offset;
                    long b = rt.ivend(iv) - offset;
                    if (!prefix) {
                        if (!firstOrder) {
                            s.append(json ? ", " : " ");
                        }
                        firstOrder = false;
                        if (json) {
                            s.append("\"").append(o).append("\":[");
                        } else {
                            s.append(o).append("/");
                        }
                        prefix = true;
                    } else {
                        s.append(",");
                    }
                    if (json) {
                        for (long i = a; i < b - 1L; ++i) {
                            s.append(i).append(",");
                        }
                        s.append(b - 1L);
                        continue;
                    }
                    s.append(a);
                    if (b <= a + 1L) continue;
                    s.append("-").append(b - 1L);
                }
            }
            if (!json || !prefix) continue;
            s.append("]");
        }
        if (json) {
            s.append("}");
        }
        return s.toString();
    }

    public static String mocToStringASCII(Moc moc) {
        return MocStringIO.mocToStringGeneral(moc, false);
    }

    public static String mocToStringJSON(Moc moc) {
        return MocStringIO.mocToStringGeneral(moc, true);
    }
}

