/*
 * Decompiled with CFR 0.152.
 */
package healpix.essentials;

public final class FastMath {
    private static final double PI4_A = 0.7853981554508209;
    private static final double PI4_B = 7.946627356147928E-9;
    private static final double PI4_C = 3.061616997868383E-17;
    private static final double M_1_PI = 0.3183098861837907;

    private static final double mulsign(double x, double y) {
        return Math.copySign(1.0, y) * x;
    }

    private static final boolean isnan(double d) {
        return d != d;
    }

    private static final boolean isinf(double d) {
        return Math.abs(d) == Double.POSITIVE_INFINITY;
    }

    private static final double sign(double d) {
        return Math.copySign(1.0, d);
    }

    private static final double atanhelper(double s) {
        double t = s * s;
        double u = -1.887960084630735E-5;
        u = u * t + 2.0985007664581698E-4;
        u = u * t + -0.0011061183148667248;
        u = u * t + 0.003700267441887131;
        u = u * t + -0.008898961958876555;
        u = u * t + 0.016599329773529202;
        u = u * t + -0.025451762493231264;
        u = u * t + 0.03378525800013531;
        u = u * t + -0.04076291912768365;
        u = u * t + 0.04666671500778406;
        u = u * t + -0.052367485230348246;
        u = u * t + 0.05876663929266736;
        u = u * t + -0.06665735793610805;
        u = u * t + 0.07692195383117696;
        u = u * t + -0.09090899500824501;
        u = u * t + 0.11111110564826142;
        u = u * t + -0.1428571426677133;
        u = u * t + 0.19999999999659127;
        u = u * t + -0.3333333333333111;
        return u * t * s + s;
    }

    private static final double atan2k(double y, double x) {
        double q = 0.0;
        if (x < 0.0) {
            x = -x;
            q = -2.0;
        }
        if (y > x) {
            double t = x;
            x = y;
            y = -t;
            q += 1.0;
        }
        return FastMath.atanhelper(y / x) + q * 1.5707963267948966;
    }

    public static final double atan2(double y, double x) {
        double r = FastMath.atan2k(Math.abs(y), x);
        r = FastMath.mulsign(r, x);
        if (FastMath.isinf(x) || x == 0.0) {
            r = 1.5707963267948966 - (FastMath.isinf(x) ? FastMath.sign(x) * 1.5707963267948966 : 0.0);
        }
        if (FastMath.isinf(y)) {
            r = 1.5707963267948966 - (FastMath.isinf(x) ? FastMath.sign(x) * 0.7853981633974483 : 0.0);
        }
        if (y == 0.0) {
            r = FastMath.sign(x) == -1.0 ? Math.PI : 0.0;
        }
        return FastMath.isnan(x) || FastMath.isnan(y) ? Double.NaN : FastMath.mulsign(r, y);
    }

    public static double asin(double d) {
        return FastMath.mulsign(FastMath.atan2k(Math.abs(d), Math.sqrt((1.0 + d) * (1.0 - d))), d);
    }

    public static double acos(double d) {
        return FastMath.mulsign(FastMath.atan2k(Math.sqrt((1.0 + d) * (1.0 - d)), Math.abs(d)), d) + (d < 0.0 ? Math.PI : 0.0);
    }

    public static final double atan(double s) {
        int q = 0;
        if (s < 0.0) {
            s = -s;
            q = 2;
        }
        if (s > 1.0) {
            s = 1.0 / s;
            q |= 1;
        }
        double t = FastMath.atanhelper(s);
        if ((q & 1) != 0) {
            t = 1.5707963267948966 - t;
        }
        if ((q & 2) != 0) {
            t = -t;
        }
        return t;
    }

    private static final double sincoshelper(double d) {
        double s = d * d;
        double u = -7.972559550090379E-18;
        u = u * s + 2.810099727108632E-15;
        u = u * s - 7.647122191181588E-13;
        u = u * s + 1.605904306056645E-10;
        u = u * s - 2.5052108376350205E-8;
        u = u * s + 2.7557319223919875E-6;
        u = u * s - 1.9841269841269616E-4;
        u = u * s + 0.00833333333333333;
        u = u * s - 0.16666666666666666;
        return s * u * d + d;
    }

    public static final double sin(double d) {
        double u = d * 0.3183098861837907;
        long q = (long)(u < 0.0 ? u - 0.5 : u + 0.5);
        double x = 4.0 * (double)q;
        d -= x * 0.7853981554508209;
        d -= x * 7.946627356147928E-9;
        d -= x * 3.061616997868383E-17;
        if ((q & 1L) != 0L) {
            d = -d;
        }
        return FastMath.sincoshelper(d);
    }

    public static final double cos(double d) {
        double u = d * 0.3183098861837907 - 0.5;
        long q = 1L + 2L * (long)(u < 0.0 ? u - 0.5 : u + 0.5);
        double x = 2.0 * (double)q;
        d -= x * 0.7853981554508209;
        d -= x * 7.946627356147928E-9;
        d -= x * 3.061616997868383E-17;
        if ((q & 2L) == 0L) {
            d = -d;
        }
        return FastMath.sincoshelper(d);
    }
}

