#############################################################################
#
# MODULE:   	Grass Compilation
# AUTHOR(S):	Original author unknown - probably CERL
#		Markus Neteler - Germany/Italy - neteler@itc.it
#   	    	Justin Hickey - Thailand - jhickey@hpcc.nectec.or.th
#   	    	Huidae Cho - Korea - grass4u@gmail.com
#   	    	Eric G. Miller - egm2@jps.net
# PURPOSE:  	The source file for this Makefile is in src/CMD/head/head.in.
#		It is the top part of a file called make.rules which is used
#		for compiling all GRASS modules. This part of the file provides
#		make variables that are dependent on the results of the
#		configure script.
# COPYRIGHT:    (C) 2000 by the GRASS Development Team
#
#               This program is free software under the GNU General Public
#   	    	License (>=v2). Read the file COPYING that comes with GRASS
#   	    	for details.
#
#############################################################################

############################## Make Variables ###############################

CC                  = /usr/bin/clang
CXX                 = /usr/bin/clang++
LEX                 = flex
YACC                = bison -y
PERL                = /usr/bin/perl
AR                  = ar
RANLIB              = ranlib
MKDIR               = mkdir -p
CHMOD               = chmod
INSTALL             = /opt/local/libexec/macports/clonebin/install
INSTALL_DATA        = ${INSTALL} -m 644

prefix              = /opt/local/lib
exec_prefix         = /opt/local
ARCH                = x86_64-apple-darwin21.6.0
UNIX_BIN            = ${exec_prefix}/bin
INST_DIR            = ${prefix}/grass84

GRASS_HOME          = /opt/local/lib/grass84
RUN_GISBASE         = /opt/local/lib/grass84

GRASS_VERSION_MAJOR = 8
GRASS_VERSION_MINOR = 4
GRASS_VERSION_RELEASE = 2
GRASS_VERSION_DATE  = 2025
GRASS_VERSION_GIT   = exported

STRIPFLAG           = 
LD_SEARCH_FLAGS     = 
LD_LIBRARY_PATH_VAR = DYLD_LIBRARY_PATH

#generate static (ST) or shared (SH)
GRASS_LIBRARY_TYPE  = shlib

#static libs:
STLIB_LD            = ${AR} cr
STLIB_PREFIX        = lib
STLIB_SUFFIX        = .a

#shared libs
SHLIB_PREFIX        = lib
SHLIB_LD            = /usr/bin/clang -dynamiclib -compatibility_version ${GRASS_VERSION_MAJOR}.${GRASS_VERSION_MINOR} -current_version ${GRASS_VERSION_MAJOR}.${GRASS_VERSION_MINOR} -install_name ${INST_DIR}/lib/lib${LIB_NAME}${SHLIB_SUFFIX}
SHLIB_LDX           = /usr/bin/clang++ -dynamiclib -compatibility_version ${GRASS_VERSION_MAJOR}.${GRASS_VERSION_MINOR} -current_version ${GRASS_VERSION_MAJOR}.${GRASS_VERSION_MINOR} -install_name ${INST_DIR}/lib/lib${LIB_NAME}${SHLIB_SUFFIX}
SHLIB_LDFLAGS       = 
SHLIB_CFLAGS        = -fno-common
SHLIB_SUFFIX        = .dylib
EXE                 = 

DEFAULT_DATABASE    =
DEFAULT_LOCATION    =

CPPFLAGS            = -I/opt/local/include -isysroot/Library/Developer/CommandLineTools/SDKs/MacOSX12.sdk
CFLAGS              = -pipe -Os -DGL_SILENCE_DEPRECATION -isysroot/Library/Developer/CommandLineTools/SDKs/MacOSX12.sdk -arch x86_64 
CXXFLAGS            = -pipe -Os -std=c++17 -stdlib=libc++ -isysroot/Library/Developer/CommandLineTools/SDKs/MacOSX12.sdk -arch x86_64
INCLUDE_DIRS        = 
LINK_FLAGS          = -L/opt/local/lib -Wl,-headerpad_max_install_names -Wl,-syslibroot,/Library/Developer/CommandLineTools/SDKs/MacOSX12.sdk -arch x86_64 -Wl,-rpath,${prefix}/grass84/lib,-rpath,${GISBASE}/lib

DLLIB               = 
XCFLAGS             = 
XLIBPATH            = 
XLIB                =  
XEXTRALIBS          = 
USE_X11             = 

MATHLIB             = 
ICONVLIB            = -liconv
INTLLIB             = 
SOCKLIB             = 

#ZLIB:
ZLIB                =  -lz 
ZLIBINCPATH         = 
ZLIBLIBPATH         = 

#BZIP2:
BZIP2LIB            =  -lbz2 
BZIP2INCPATH        =  -I/opt/local/include
BZIP2LIBPATH        =  -L/opt/local/lib

#ZSTD:
ZSTDLIB             =  -lzstd 
ZSTDINCPATH         =  -I/opt/local/include
ZSTDLIBPATH         =  -L/opt/local/lib

DBMIEXTRALIB        = 

#readline
READLINEINCPATH     =  -I/opt/local/include/readline
READLINELIBPATH     =  -L/opt/local/lib
READLINELIB         =  -lreadline 
HISTORYLIB          =  -lhistory 

#PostgreSQL:
PQINCPATH           =  -I/opt/local/include/postgresql17
PQLIBPATH           =  -L/opt/local/lib/postgresql17
PQLIB               =  -lpq 
USE_POSTGRES        = 1

#MySQL:
MYSQLINCPATH        = 
MYSQLLIBPATH        = 
MYSQLLIB            = 
MYSQLDLIB           = 

#SQLite:
SQLITEINCPATH       =  -I/opt/local/include
SQLITELIBPATH       =  -L/opt/local/lib
SQLITELIB           =  -lsqlite3 

#ODBC:
ODBCINC             = 
ODBCLIB             = 

#Image formats:
PNGINC              = -I/opt/local/include/libpng16
PNGLIB              = -L/opt/local/lib -lpng16 -lz
USE_PNG             = 1

TIFFINCPATH         =  -I/opt/local/include
TIFFLIBPATH         =  -L/opt/local/lib
TIFFLIB             =  -ltiff 

#openGL files for NVIZ/r3.showdspf
OPENGLINC           = 
OPENGLLIB           =  -framework OpenGL -framework ApplicationServices -framework AGL 
OPENGLULIB          = 
OPENGL_X11          = 
OPENGL_AQUA         = 1
OPENGL_WINDOWS      = 
USE_OPENGL          = 1

#FFTW:
FFTWINC             =  -I/opt/local/include
FFTWLIB             =  -L/opt/local/lib -lfftw3 

#LAPACK/BLAS stuff for gmath lib:
BLASLIB             = 
BLASINC             = 
LAPACKLIB           = 
LAPACKINC           = 

#LIBSVM
LIBSVM_LIB          =  -lsvm 
LIBSVM_INC          = 
USE_LIBSVM          = 1

#GDAL/OGR
GDALLIBS            = -L/opt/local/lib -lgdal
GDALCFLAGS          = -I/opt/local/include
USE_GDAL            = 1
USE_OGR             = 1

#NetCDF
NETCDFLIBS          = 
NETCDFCFLAGS        = 
USE_NETCDF          = 

#LAS LiDAR through libLAS
LASLIBS             = -L/opt/local/lib -llas -llas_c -L/opt/local/libexec/boost/1.81/lib /opt/local/libexec/boost/1.81/lib/libboost_program_options-mt.dylib /opt/local/libexec/boost/1.81/lib/libboost_thread-mt.dylib /opt/local/lib/libgdal.dylib /opt/local/lib/libgeotiff.dylib /opt/local/lib/libtiff.dylib
LASCFLAGS           = -pipe -Os -DNDEBUG -I/opt/local/libexec/boost/1.81/include -I/opt/local/include -isysroot/Library/Developer/CommandLineTools/SDKs/MacOSX12.sdk
LASINC              = -I/opt/local/include -I/opt/local/include -I/opt/local/include -I/opt/local/include
USE_LIBLAS          = 1

#LAS LiDAR through PDAL
PDALLIBS             = -L/opt/local/lib -lpdalcpp -lgdal -lxml2
PDALINC              = -I/opt/local/include/pdal -I/opt/local/include/libxml2
USE_PDAL             = 1

#GEOS
GEOSLIBS            = -L/opt/local/lib -lgeos_c -lgeos_c 
GEOSCFLAGS          = -I/opt/local/include
USE_GEOS            = 1

#FreeType:
FTINC               = -I/opt/local/include/freetype2 -I/opt/local/include/libpng16 -I/opt/local/include/freetype2
FTLIB               = -L/opt/local/lib -lfreetype -L/opt/local/lib -lfreetype 

#PROJ.4:
PROJINC             =  -I/opt/local/lib/proj9/include
PROJLIB             =  -L/opt/local/lib/proj9/lib -lproj 
PROJSHARE           = /opt/local/lib/proj9/share/proj

#OPENDWG:
OPENDWGINCPATH      = 
OPENDWGLIBPATH      = 
OPENDWGLIB          = 
USE_OPENDWG         = 

#cairo
CAIROINC                  = -I/opt/local/include/cairo -I/opt/local/include/glib-2.0 -I/opt/local/lib/glib-2.0/include -I/opt/local/include/pixman-1 -I/opt/local/include/freetype2 -I/opt/local/include/libpng16 -I/opt/local/include/cairo
CAIROLIB                  = -L/opt/local/lib -lz -lcairo -lfontconfig -lfreetype -L/opt/local/lib  
USE_CAIRO                 = 1
CAIRO_HAS_XRENDER         = 1
CAIRO_HAS_XRENDER_SURFACE = 1

#Python
PYTHON = /opt/local/bin/python3.13

#regex
REGEXINCPATH        = 
REGEXLIBPATH        = 
REGEXLIB            =  
USE_REGEX           = 1

#pthreads
PTHREADINCPATH      = 
PTHREADLIBPATH      = 
PTHREADLIB          =  
USE_PTHREAD         = 1

#OpenMP
OPENMP_INCPATH      = 
OPENMP_LIBPATH      = 
OPENMP_LIB          = 
OPENMP_CFLAGS       = 
USE_OPENMP          = 

#OpenCL
OCLINCPATH          = 
OCLLIBPATH          = 
OCLLIB              = 
USE_OPENCL          = 

#i18N
HAVE_NLS            = 

#Large File Support (LFS)
USE_LARGEFILES      = 1
LFS_CFLAGS          = 

#BSD sockets
HAVE_SOCKET         = 1

MINGW		    = 
WINDRES		    = 
MACOSX_APP	    = 
MACOSX_ARCHS        = 
MACOSX_SDK          = 

# Cross compilation
CROSS_COMPILING     = 
