/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.shortestpath;

import edu.uci.ics.jung.graph.Hypergraph;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BFSDistanceLabeler<V, E> {
    private Map<V, Number> distanceDecorator = new HashMap<V, Number>();
    private List<V> mCurrentList;
    private Set<V> mUnvisitedVertices;
    private List<V> mVerticesInOrderVisited;
    private Map<V, HashSet<V>> mPredecessorMap = new HashMap<V, HashSet<V>>();

    public List<V> getVerticesInOrderVisited() {
        return this.mVerticesInOrderVisited;
    }

    public Set<V> getUnvisitedVertices() {
        return this.mUnvisitedVertices;
    }

    public int getDistance(Hypergraph<V, E> g, V v) {
        if (!g.getVertices().contains(v)) {
            throw new IllegalArgumentException("Vertex is not contained in the graph.");
        }
        return this.distanceDecorator.get(v).intValue();
    }

    public Set<V> getPredecessors(V v) {
        return this.mPredecessorMap.get(v);
    }

    protected void initialize(Hypergraph<V, E> g, Set<V> rootSet) {
        this.mVerticesInOrderVisited = new ArrayList<V>();
        this.mUnvisitedVertices = new HashSet<V>();
        for (V currentVertex : g.getVertices()) {
            this.mUnvisitedVertices.add(currentVertex);
            this.mPredecessorMap.put(currentVertex, new HashSet());
        }
        this.mCurrentList = new ArrayList<V>();
        for (V v : rootSet) {
            this.distanceDecorator.put((Number)v, new Integer(0));
            this.mCurrentList.add(v);
            this.mUnvisitedVertices.remove(v);
            this.mVerticesInOrderVisited.add(v);
        }
    }

    private void addPredecessor(V predecessor, V sucessor) {
        HashSet<V> predecessors = this.mPredecessorMap.get(sucessor);
        predecessors.add(predecessor);
    }

    public void labelDistances(Hypergraph<V, E> graph, Set<V> rootSet) {
        this.initialize(graph, rootSet);
        int distance = 1;
        while (true) {
            ArrayList<V> newList = new ArrayList<V>();
            for (V currentVertex : this.mCurrentList) {
                if (!graph.containsVertex(currentVertex)) continue;
                for (V next : graph.getSuccessors(currentVertex)) {
                    this.visitNewVertex(currentVertex, next, distance, newList);
                }
            }
            if (newList.size() == 0) break;
            this.mCurrentList = newList;
            ++distance;
        }
        for (V v : this.mUnvisitedVertices) {
            this.distanceDecorator.put((Number)v, new Integer(-1));
        }
    }

    public void labelDistances(Hypergraph<V, E> graph, V root) {
        this.labelDistances(graph, (V)Collections.singleton(root));
    }

    private void visitNewVertex(V predecessor, V neighbor, int distance, List<V> newList) {
        int successorDistance;
        int predecessorDistance;
        if (this.mUnvisitedVertices.contains(neighbor)) {
            this.distanceDecorator.put((Number)neighbor, new Integer(distance));
            newList.add(neighbor);
            this.mVerticesInOrderVisited.add(neighbor);
            this.mUnvisitedVertices.remove(neighbor);
        }
        if ((predecessorDistance = this.distanceDecorator.get(predecessor).intValue()) < (successorDistance = this.distanceDecorator.get(neighbor).intValue())) {
            this.addPredecessor(predecessor, neighbor);
        }
    }

    public Map<V, Number> getDistanceDecorator() {
        return this.distanceDecorator;
    }
}

