/*
 * Decompiled with CFR 0.152.
 */
package org.prevayler.implementation;

import java.io.File;
import java.io.IOException;
import org.prevayler.Clock;
import org.prevayler.Prevayler;
import org.prevayler.Query;
import org.prevayler.SureTransactionWithQuery;
import org.prevayler.Transaction;
import org.prevayler.TransactionWithQuery;
import org.prevayler.foundation.serialization.Serializer;
import org.prevayler.implementation.Capsule;
import org.prevayler.implementation.PrevalentSystemGuard;
import org.prevayler.implementation.TransactionCapsule;
import org.prevayler.implementation.TransactionWithQueryCapsule;
import org.prevayler.implementation.publishing.TransactionPublisher;
import org.prevayler.implementation.snapshot.GenericSnapshotManager;

public class PrevaylerImpl<P>
implements Prevayler<P> {
    private final PrevalentSystemGuard<P> _guard;
    private final Clock _clock;
    private final GenericSnapshotManager<P> _snapshotManager;
    private final TransactionPublisher _publisher;
    private final Serializer _journalSerializer;
    private boolean _transactionDeepCopyMode;

    public PrevaylerImpl(GenericSnapshotManager<P> snapshotManager, TransactionPublisher transactionPublisher, Serializer journalSerializer, boolean transactionDeepCopyMode) throws IOException, ClassNotFoundException {
        this._snapshotManager = snapshotManager;
        this._guard = this._snapshotManager.recoveredPrevalentSystem();
        this._publisher = transactionPublisher;
        this._clock = this._publisher.clock();
        this._guard.subscribeTo(this._publisher);
        this._journalSerializer = journalSerializer;
        this._transactionDeepCopyMode = transactionDeepCopyMode;
    }

    @Override
    public P prevalentSystem() {
        return this._guard.prevalentSystem();
    }

    @Override
    public Clock clock() {
        return this._clock;
    }

    @Override
    public void execute(Transaction<? super P> transaction) {
        this.publish(new TransactionCapsule<P>(transaction, this._journalSerializer, this._transactionDeepCopyMode));
    }

    private void publish(Capsule capsule) {
        this._publisher.publish(capsule);
    }

    @Override
    public <R> R execute(Query<? super P, R> sensitiveQuery) throws Exception {
        return this._guard.executeQuery(sensitiveQuery, this.clock());
    }

    @Override
    public <R> R execute(TransactionWithQuery<? super P, R> transactionWithQuery) throws Exception {
        TransactionWithQueryCapsule<P, R> capsule = new TransactionWithQueryCapsule<P, R>(transactionWithQuery, this._journalSerializer, this._transactionDeepCopyMode);
        this.publish(capsule);
        return capsule.result();
    }

    @Override
    public <R> R execute(SureTransactionWithQuery<? super P, R> sureTransactionWithQuery) {
        try {
            return this.execute((TransactionWithQuery<? super P, R>)sureTransactionWithQuery);
        }
        catch (RuntimeException runtime) {
            throw runtime;
        }
        catch (Exception checked) {
            throw new RuntimeException("Unexpected Exception thrown.", checked);
        }
    }

    @Override
    public File takeSnapshot() throws Exception {
        return this._guard.takeSnapshot(this._snapshotManager);
    }

    @Override
    public void close() throws IOException {
        this._publisher.close();
    }
}

