/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.client.tables;

import ghidra.features.bsim.query.LSHException;
import ghidra.features.bsim.query.client.RowKeySQL;
import ghidra.features.bsim.query.client.tables.CachedStatement;
import ghidra.features.bsim.query.client.tables.ExeTable;
import ghidra.features.bsim.query.client.tables.SQLComplexTable;
import ghidra.features.bsim.query.description.DescriptionManager;
import ghidra.features.bsim.query.description.ExecutableRecord;
import ghidra.features.bsim.query.description.FunctionDescription;
import ghidra.features.bsim.query.description.SignatureRecord;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.help.UnsupportedOperationException;

public class DescriptionTable
extends SQLComplexTable {
    private static final String INSERT_STMT = "INSERT INTO desctable (id,name_func,id_exe,id_signature,flags,addr) VALUES(DEFAULT,?,?,?,?,?)";
    private static final String SELECT_BY_SIGNATURE_ID_STMT = "SELECT ALL * FROM  desctable WHERE id_signature = ";
    private static final String SELECT_BY_FUNC_NAMEADDR_STMT = "SELECT ALL * FROM  desctable WHERE name_func = ? AND addr = ? AND id_exe = ?";
    private static final String SELECT_BY_FUNC_NAME_STMT = "SELECT ALL * FROM  desctable WHERE name_func = ? AND id_exe = ?";
    private String selectWithFilterTableClause = null;
    private String selectWithFilterWhereClause = null;
    private final CachedStatement<PreparedStatement> selectWithFilterStatement = new CachedStatement();
    private final CachedStatement<PreparedStatement> selectByFuncAddrAndExeStatement = new CachedStatement();
    private final CachedStatement<PreparedStatement> selectByFuncAndExeStatement = new CachedStatement();
    private final CachedStatement<PreparedStatement> insertStatement = new CachedStatement();
    private final CachedStatement<PreparedStatement> selectByRowIdStatement = new CachedStatement();
    private ExeTable exeTable = null;

    public DescriptionTable(ExeTable exeTable) {
        super("desctable", "id_exe");
        this.exeTable = exeTable;
    }

    @Override
    public void close() {
        this.selectWithFilterStatement.close();
        this.selectByFuncAddrAndExeStatement.close();
        this.selectByFuncAndExeStatement.close();
        this.insertStatement.close();
        this.selectByRowIdStatement.close();
        super.close();
    }

    @Override
    public void create(Statement st) throws SQLException {
        st.executeUpdate("CREATE TABLE  desctable (id BIGSERIAL PRIMARY KEY,name_func TEXT,id_exe INTEGER,id_signature BIGINT,flags INTEGER,addr BIGINT)");
        st.executeUpdate("CREATE INDEX sigindex ON desctable (id_signature)");
        st.executeUpdate("CREATE INDEX exefuncindex ON desctable (id_exe,name_func,addr)");
    }

    @Override
    public void drop(Statement st) throws SQLException {
        throw new UnsupportedOperationException("DescriptionTable may not be dropped");
    }

    public FunctionDescription querySingleDescriptionId(DescriptionManager descManager, long rowId) throws SQLException, LSHException {
        PreparedStatement s = this.selectByRowIdStatement.prepareIfNeeded(() -> this.db.prepareStatement("SELECT ALL * FROM desctable WHERE id = ?"));
        s.setLong(1, rowId);
        try (ResultSet rs = s.executeQuery();){
            FunctionDescription fres = this.extractSingleDescriptionRow(rs, descManager);
            if (fres == null) {
                throw new SQLException("No desctable rows matching id");
            }
            FunctionDescription functionDescription = fres;
            return functionDescription;
        }
    }

    private FunctionDescription extractSingleDescriptionRow(ResultSet resultSet, DescriptionManager descManager) throws SQLException, LSHException {
        boolean finished = false;
        DescriptionRow currow = null;
        while (resultSet.next()) {
            if (finished) continue;
            currow = new DescriptionRow();
            DescriptionTable.extractDescriptionRow(resultSet, currow);
            finished = true;
        }
        if (currow == null) {
            return null;
        }
        RowKeySQL rowKey = new RowKeySQL(currow.id_exe);
        ExecutableRecord curexe = descManager.findExecutableByRow(rowKey);
        if (curexe == null) {
            ExeTable.ExecutableRow exerow = this.exeTable.querySingleExecutableId(currow.id_exe);
            curexe = this.exeTable.makeExecutableRecord(descManager, exerow);
            descManager.cacheExecutableByRow(curexe, rowKey);
        }
        return DescriptionTable.convertDescriptionRow(currow, curexe, descManager, null);
    }

    public void convertDescriptionRows(List<FunctionDescription> descList, List<DescriptionRow> rowList, ExecutableRecord executable, DescriptionManager descManager, SignatureRecord sigRecord) {
        if (rowList.isEmpty()) {
            return;
        }
        DescriptionRow currow = rowList.get(0);
        FunctionDescription fres = DescriptionTable.convertDescriptionRow(currow, executable, descManager, sigRecord);
        descList.add(fres);
        if (sigRecord != null) {
            descManager.setSignatureId(sigRecord, currow.id_sig);
        }
        for (int i = 1; i < rowList.size(); ++i) {
            currow = rowList.get(i);
            fres = DescriptionTable.convertDescriptionRow(currow, executable, descManager, sigRecord);
            descList.add(fres);
        }
    }

    public static FunctionDescription convertDescriptionRow(DescriptionRow descRow, ExecutableRecord exeRecord, DescriptionManager descManager, SignatureRecord sigRecord) {
        FunctionDescription fres = descManager.newFunctionDescription(descRow.func_name, descRow.addr, exeRecord);
        descManager.setFunctionDescriptionId(fres, new RowKeySQL(descRow.rowid));
        descManager.setFunctionDescriptionFlags(fres, descRow.flags);
        descManager.setSignatureId(fres, descRow.id_sig);
        if (sigRecord != null) {
            descManager.attachSignature(fres, sigRecord);
        }
        return fres;
    }

    public static void extractDescriptionRow(ResultSet resultSet, DescriptionRow descRow) throws SQLException {
        descRow.rowid = resultSet.getLong(1);
        descRow.func_name = resultSet.getString(2);
        descRow.id_exe = resultSet.getInt(3);
        descRow.id_sig = resultSet.getLong(4);
        descRow.flags = resultSet.getInt(5);
        descRow.addr = resultSet.getLong(6);
    }

    public List<DescriptionRow> extractDescriptionRows(ResultSet resultSet, int maxRows) throws SQLException {
        ArrayList<DescriptionRow> descvec = new ArrayList<DescriptionRow>();
        boolean finished = false;
        while (resultSet.next()) {
            if (finished) continue;
            DescriptionRow row = new DescriptionRow();
            descvec.add(row);
            DescriptionTable.extractDescriptionRow(resultSet, row);
            if (maxRows <= 0 || descvec.size() < maxRows) continue;
            finished = true;
        }
        return descvec;
    }

    @Override
    public long insert(Object ... arguments) throws SQLException {
        if (arguments == null || arguments.length != 1 || !(arguments[0] instanceof FunctionDescription)) {
            throw new IllegalArgumentException("Insert method for KeyValueTable must take exactly one FunctionDescription argument");
        }
        FunctionDescription func = (FunctionDescription)arguments[0];
        SignatureRecord srec = func.getSignatureRecord();
        long vecid = 0L;
        if (srec != null) {
            vecid = srec.getVectorId();
        }
        PreparedStatement s = this.insertStatement.prepareIfNeeded(() -> this.db.prepareStatement(INSERT_STMT, 1));
        s.setString(1, func.getFunctionName());
        s.setInt(2, (int)func.getExecutableRecord().getRowId().getLong());
        s.setLong(3, vecid);
        s.setInt(4, func.getFlags());
        s.setLong(5, func.getAddress());
        s.executeUpdate();
        try (ResultSet rs = s.getGeneratedKeys();){
            if (!rs.next()) {
                throw new SQLException("Did not get desctable sequence number after insertion");
            }
            long l = rs.getLong(1);
            return l;
        }
    }

    public List<DescriptionRow> queryVectorIdMatch(long vectorId, int maxRows) throws SQLException {
        StringBuffer buf = new StringBuffer();
        buf.append(SELECT_BY_SIGNATURE_ID_STMT).append(vectorId);
        if (maxRows > 0) {
            buf.append(" LIMIT ").append(maxRows);
        }
        try (Statement select_desctable_id_signature_stmt = this.db.createStatement();){
            List<DescriptionRow> list;
            block13: {
                ResultSet rs = select_desctable_id_signature_stmt.executeQuery(buf.toString());
                try {
                    select_desctable_id_signature_stmt.setFetchSize(50);
                    List<DescriptionRow> descres = null;
                    list = descres = this.extractDescriptionRows(rs, maxRows);
                    if (rs == null) break block13;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return list;
        }
    }

    public List<DescriptionRow> queryVectorIdMatchFilter(long vectorId, String tableClause, String whereClause, int maxRows) throws SQLException {
        PreparedStatement s = this.selectWithFilterStatement.getStatement();
        if (s == null || !tableClause.equals(this.selectWithFilterTableClause) || !whereClause.equals(this.selectWithFilterWhereClause)) {
            this.selectWithFilterStatement.close();
            this.selectWithFilterTableClause = tableClause;
            this.selectWithFilterWhereClause = whereClause;
            StringBuffer buf = new StringBuffer();
            buf.append("SELECT desctable.id,desctable.name_func,desctable.id_exe,desctable.id_signature,desctable.flags,desctable.addr FROM desctable");
            buf.append(tableClause);
            buf.append(" WHERE desctable.id_signature = ? ");
            buf.append(whereClause);
            buf.append(" LIMIT ?");
            s = this.db.prepareStatement(buf.toString());
            this.selectWithFilterStatement.setStatement(s);
        }
        if (maxRows == 0) {
            maxRows = 1000000;
        }
        s.setLong(1, vectorId);
        s.setInt(2, maxRows);
        s.setFetchSize(50);
        try (ResultSet rs = s.executeQuery();){
            List<DescriptionRow> list = this.extractDescriptionRows(rs, maxRows);
            return list;
        }
    }

    public List<DescriptionRow> queryFuncName(long executableId, String functionName, int maxRows) throws SQLException {
        PreparedStatement s = this.selectByFuncAndExeStatement.prepareIfNeeded(() -> this.db.prepareStatement(SELECT_BY_FUNC_NAME_STMT));
        s.setString(1, functionName);
        s.setInt(2, (int)executableId);
        s.setFetchSize(50);
        try (ResultSet rs = s.executeQuery();){
            List<DescriptionRow> list = this.extractDescriptionRows(rs, maxRows);
            return list;
        }
    }

    public DescriptionRow queryFuncNameAddr(long executableId, String functionName, long functionAddress) throws SQLException {
        PreparedStatement s = this.selectByFuncAddrAndExeStatement.prepareIfNeeded(() -> this.db.prepareStatement(SELECT_BY_FUNC_NAMEADDR_STMT));
        s.setString(1, functionName);
        s.setLong(2, functionAddress);
        s.setInt(3, (int)executableId);
        s.setFetchSize(3);
        DescriptionRow resultRow = null;
        try (ResultSet rs = s.executeQuery();){
            boolean finished = false;
            while (rs.next()) {
                if (finished) continue;
                resultRow = new DescriptionRow();
                DescriptionTable.extractDescriptionRow(rs, resultRow);
                finished = true;
            }
            DescriptionRow descriptionRow = resultRow;
            return descriptionRow;
        }
    }

    public static class DescriptionRow {
        public long rowid;
        public String func_name;
        public long id_exe;
        public long id_sig;
        public long addr;
        public int flags;
    }
}

