/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.field.AttributedString;
import docking.widgets.fieldpanel.field.ClippingTextField;
import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.field.TextFieldElement;
import docking.widgets.fieldpanel.support.FieldHighlightFactory;
import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.fieldpanel.support.Highlight;
import generic.theme.GColor;
import generic.theme.GThemeDefaults;
import ghidra.app.util.ListingHighlightProvider;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.ListingFieldHighlightFactoryAdapter;
import ghidra.app.util.viewer.field.ListingTextField;
import ghidra.app.util.viewer.proxy.ProxyObj;
import java.awt.Color;

public class ErrorListingField
extends ListingTextField {
    private static Color BG_ERROR_COLOR = new GColor("color.bg.listing.error");
    private Throwable t;
    private static ListingHighlightProvider myProvider = (text, field, cursorTextOffset) -> new Highlight[]{new Highlight(0, text.length() - 1, BG_ERROR_COLOR)};

    public ErrorListingField(FieldFactory ff, ProxyObj<?> proxy, int varWidth, Throwable t) {
        super(ff, proxy, null, ErrorListingField.createHighlightFactory());
        this.t = t;
        this.field = this.createField(ff, proxy, varWidth);
    }

    private static ListingFieldHighlightFactoryAdapter createHighlightFactory() {
        return new ListingFieldHighlightFactoryAdapter(myProvider);
    }

    private ClippingTextField createField(FieldFactory ff, ProxyObj<?> proxy, int varWidth) {
        ClippingTextField textField = new ClippingTextField(ff.getStartX() + varWidth, ff.getWidth(), ErrorListingField.createElement(ff, this.t), (FieldHighlightFactory)this.hlFactory);
        return textField;
    }

    private static FieldElement createElement(FieldFactory ff, Throwable t) {
        String message = t.getMessage() == null ? t.toString() : t.getMessage();
        AttributedString as = new AttributedString("*Error*: " + message + ".  Double click for Details.", (Color)GThemeDefaults.Colors.FOREGROUND, ff.getMetrics());
        return new TextFieldElement(as, 0, 0);
    }

    public Throwable getThrowable() {
        return this.t;
    }

    @Override
    public Object getClickedObject(FieldLocation fieldLocation) {
        return this;
    }
}

