/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf.line;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.dwarf.DWARFCompilationUnit;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFAttributeValue;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFBlobAttribute;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFFormContext;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFNumericAttribute;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFStringAttribute;
import ghidra.app.util.bin.format.dwarf.line.DWARFLine;
import ghidra.app.util.bin.format.dwarf.line.DWARFLineContentType;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.program.model.data.LEB128;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;

public class DWARFFile {
    private final String name;
    private final int directory_index;
    private final long modification_time;
    private final long length;
    private final byte[] md5;

    public static DWARFFile readV4(BinaryReader reader, DWARFCompilationUnit cu) throws IOException {
        Charset charset = cu.getProgram().getCharset();
        String name = reader.readNextString(charset, 1);
        if (name.length() == 0) {
            return null;
        }
        int directory_index = reader.readNextUnsignedVarIntExact(LEB128::unsigned);
        long modification_time = reader.readNext(LEB128::unsigned);
        long length = reader.readNext(LEB128::unsigned);
        return new DWARFFile(name, directory_index, modification_time, length, null);
    }

    public static DWARFFile readV5(BinaryReader reader, List<DWARFLineContentType.Def> defs, int dwarfIntSize, DWARFCompilationUnit cu) throws IOException {
        String name = null;
        int directoryIndex = -1;
        long modTime = 0L;
        long length = 0L;
        byte[] md5 = null;
        for (DWARFLineContentType.Def def : defs) {
            DWARFFormContext context = new DWARFFormContext(reader, cu, def, dwarfIntSize);
            DWARFAttributeValue val = def.getAttributeForm().readValue(context);
            switch ((DWARFLineContentType)((Object)def.getAttributeId())) {
                case DW_LNCT_path: {
                    String string;
                    if (val instanceof DWARFStringAttribute) {
                        DWARFStringAttribute strval = (DWARFStringAttribute)val;
                        string = strval.getValue(cu);
                    } else {
                        string = null;
                    }
                    name = string;
                    break;
                }
                case DW_LNCT_directory_index: {
                    int n;
                    DWARFNumericAttribute numval;
                    if (val instanceof DWARFNumericAttribute) {
                        numval = (DWARFNumericAttribute)val;
                        n = numval.getUnsignedIntExact();
                    } else {
                        n = -1;
                    }
                    directoryIndex = n;
                    break;
                }
                case DW_LNCT_timestamp: {
                    long l;
                    DWARFNumericAttribute numval;
                    if (val instanceof DWARFNumericAttribute) {
                        numval = (DWARFNumericAttribute)val;
                        l = numval.getValue();
                    } else {
                        l = 0L;
                    }
                    modTime = l;
                    break;
                }
                case DW_LNCT_size: {
                    long l;
                    DWARFNumericAttribute numval;
                    if (val instanceof DWARFNumericAttribute) {
                        numval = (DWARFNumericAttribute)val;
                        l = numval.getUnsignedValue();
                    } else {
                        l = 0L;
                    }
                    length = l;
                    break;
                }
                case DW_LNCT_MD5: {
                    byte[] byArray;
                    if (val instanceof DWARFBlobAttribute) {
                        DWARFBlobAttribute blobval = (DWARFBlobAttribute)val;
                        byArray = blobval.getBytes();
                    } else {
                        byArray = null;
                    }
                    md5 = byArray;
                    break;
                }
            }
        }
        if (name == null) {
            throw new IOException("No name value for DWARFLine file");
        }
        return new DWARFFile(name, directoryIndex, modTime, length, md5);
    }

    public DWARFFile(String name) {
        this(name, -1, 0L, 0L, null);
    }

    public DWARFFile(String name, int directory_index, long modification_time, long length, byte[] md5) {
        this.name = name;
        this.directory_index = directory_index;
        this.modification_time = modification_time;
        this.length = length;
        this.md5 = md5;
    }

    public String getName() {
        return this.name;
    }

    public String getPathName(DWARFLine parentLine) {
        try {
            String dir = this.directory_index >= 0 ? parentLine.getDir(this.directory_index).getName() : "";
            return FSUtilities.appendPath(dir, this.name);
        }
        catch (IOException e) {
            return this.name;
        }
    }

    public DWARFFile withName(String newName) {
        return new DWARFFile(newName, this.directory_index, this.modification_time, this.length, this.md5);
    }

    public int getDirectoryIndex() {
        return this.directory_index;
    }

    public long getModificationTime() {
        return this.modification_time;
    }

    public byte[] getMD5() {
        return this.md5;
    }

    public String toString() {
        return "Filename: %s, Length: 0x%x, Time: 0x%x, DirIndex: %d".formatted(this.name, this.length, this.modification_time, this.directory_index);
    }
}

