/*
 * Decompiled with CFR 0.152.
 */
package utility.application;

import ghidra.framework.PluggableServiceRegistry;
import ghidra.util.Msg;
import java.io.File;
import java.io.IOException;
import utility.application.ApplicationUtilities;

public class ApplicationSettings {
    public static File getUserApplicationSettingsDirectory() {
        ApplicationSettings impl = PluggableServiceRegistry.getPluggableService(ApplicationSettings.class);
        return impl.doGetUserApplicationSettingsDirectory();
    }

    protected File doGetUserApplicationSettingsDirectory() {
        try {
            return ApplicationUtilities.getDefaultUserTempDir("application.settings");
        }
        catch (IOException e) {
            Msg.error(ApplicationSettings.class, "Error creating application.settings directory", e);
            return null;
        }
    }

    static {
        PluggableServiceRegistry.registerPluggableService(ApplicationSettings.class, new ApplicationSettings());
    }
}

