/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.plugintool;

import docking.framework.ApplicationInformationDisplayFactory;
import docking.framework.DockingApplicationConfiguration;
import generic.application.GenericApplicationLayout;
import ghidra.framework.Application;
import ghidra.framework.ApplicationConfiguration;
import ghidra.framework.ApplicationProperties;
import ghidra.framework.GenericRunInfo;
import ghidra.framework.PluggableServiceRegistry;
import ghidra.framework.model.ToolServices;
import ghidra.framework.plugintool.GenericStandAloneApplication;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.SettableApplicationInformationDisplayFactory;
import ghidra.framework.plugintool.StandAlonePluginTool;
import ghidra.framework.plugintool.ToolServicesAdapter;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.xml.GenericXMLOutputter;
import ghidra.util.xml.XmlUtilities;
import java.awt.Image;
import java.awt.Taskbar;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.swing.ImageIcon;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import resources.ResourceManager;
import utility.application.ApplicationLayout;

public abstract class StandAloneApplication
implements GenericStandAloneApplication {
    private static final String DEFAULT_TOOL_NAME = "DefaultTool.tool";
    private static final String SAVED_TOOL_FILE = "SavedTool.tool";
    private SettableApplicationInformationDisplayFactory displayFactory;
    protected ApplicationLayout layout;
    protected DockingApplicationConfiguration configuration;
    protected PluginTool tool;

    public StandAloneApplication(String propertiesFilename) throws IOException {
        this((ApplicationLayout)new GenericApplicationLayout(StandAloneApplication.readApplicationProperties(propertiesFilename)));
    }

    public StandAloneApplication(String name, String version) throws IOException {
        this((ApplicationLayout)new GenericApplicationLayout(name, version));
    }

    public StandAloneApplication(ApplicationLayout applicationLayout) {
        this.init(applicationLayout);
    }

    public static ApplicationProperties readApplicationProperties(String propertiesFilename) throws IOException {
        String version;
        ApplicationProperties properties = ApplicationProperties.fromFile((String)propertiesFilename);
        String name = properties.getProperty("application.name");
        if (name == null) {
            Msg.error(StandAloneApplication.class, (Object)("The application.name property is not set in " + propertiesFilename));
        }
        if ((version = properties.getProperty("application.version")) == null) {
            Msg.error(StandAloneApplication.class, (Object)("The application.name property is not set in " + propertiesFilename));
        }
        return properties;
    }

    private void init(ApplicationLayout applicationLayout) {
        this.layout = applicationLayout;
        this.configuration = new DockingApplicationConfiguration();
        this.configuration.setShowSplashScreen(false);
        this.displayFactory = new SettableApplicationInformationDisplayFactory();
    }

    public void showSpashScreen(ImageIcon splashIcon) {
        this.configuration.setShowSplashScreen(true);
        this.displayFactory.setSplashIcon128(splashIcon);
    }

    public void setWindowsIcons(List<Image> windowsIcons) {
        this.displayFactory.setWindowsIcons(windowsIcons);
    }

    public void setHomeIcon(ImageIcon icon) {
        this.displayFactory.setHomeIcon(icon);
    }

    public void setHomeCallback(Runnable callback) {
        this.displayFactory.setHomeCallback(callback);
    }

    public void start() {
        PluggableServiceRegistry.registerPluggableService(ApplicationInformationDisplayFactory.class, (Object)((Object)this.displayFactory));
        Application.initializeApplication((ApplicationLayout)this.layout, (ApplicationConfiguration)this.configuration);
        try {
            ClassSearcher.search((TaskMonitor)this.configuration.getTaskMonitor());
        }
        catch (CancelledException e) {
            Msg.debug((Object)this, (Object)"Class searching unexpectedly cancelled.");
        }
        this.setDockIcon();
        try {
            Swing.runNow(() -> {
                this.tool = this.createTool();
                return this.tool;
            });
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)"Error creating tool, exiting...", (Throwable)e);
            System.exit(0);
        }
        this.showTool();
    }

    protected void showTool() {
        this.tool.setVisible(true);
    }

    private void setDockIcon() {
        Taskbar taskbar;
        if (Taskbar.isTaskbarSupported() && (taskbar = Taskbar.getTaskbar()).isSupported(Taskbar.Feature.ICON_IMAGE)) {
            taskbar.setIconImage(ApplicationInformationDisplayFactory.getLargestWindowIcon());
        }
    }

    protected PluginTool createTool() {
        StandAlonePluginTool newTool = new StandAlonePluginTool(this, this.layout.getApplicationProperties().getApplicationName(), true);
        Element rootElement = this.getSavedToolElement();
        if (rootElement == null) {
            rootElement = this.getDefaultToolElement();
        }
        if (rootElement != null) {
            Element toolElement = rootElement.getChild("TOOL");
            Element savedDataElement = rootElement.getChild("DATA_STATE");
            this.configuration.getTaskMonitor().setMessage("Restoring Tool Configuration...");
            newTool.restoreFromXml(toolElement);
            this.configuration.getTaskMonitor().setMessage("Restoring Tool State...");
            newTool.restoreDataStateFromXml(savedDataElement);
        }
        this.initializeTool(newTool);
        return newTool;
    }

    protected void initializeTool(StandAlonePluginTool newTool) {
        newTool.addExitAction();
        newTool.installUtilityPlugins();
    }

    private Element getDefaultToolElement() {
        try {
            InputStream instream = ResourceManager.getResourceAsStream((String)DEFAULT_TOOL_NAME);
            if (instream == null) {
                return null;
            }
            SAXBuilder sax = XmlUtilities.createSecureSAXBuilder((boolean)false, (boolean)false);
            Element root = sax.build(instream).getRootElement();
            return root;
        }
        catch (Exception e) {
            Msg.showError(this.getClass(), null, (String)"Error Reading Tool", (Object)"Could not read tool: DefaultTool.tool", (Throwable)e);
            return null;
        }
    }

    private Element getSavedToolElement() {
        File userSettingsDir = Application.getUserSettingsDirectory();
        File savedToolFile = new File(userSettingsDir, SAVED_TOOL_FILE);
        if (savedToolFile.exists()) {
            return this.loadToolXml(savedToolFile);
        }
        Msg.debug((Object)this, (Object)("No saved tool found in " + String.valueOf(userSettingsDir)));
        List dirs = GenericRunInfo.getPreviousApplicationSettingsDirsByTime();
        for (File dir : dirs) {
            savedToolFile = new File(dir, SAVED_TOOL_FILE);
            Msg.debug((Object)this, (Object)("Checking for previous tool in " + String.valueOf(dir)));
            if (!savedToolFile.exists()) continue;
            Msg.debug((Object)this, (Object)("Using previous tool " + String.valueOf(savedToolFile)));
            return this.loadToolXml(savedToolFile);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element loadToolXml(File file) {
        FileInputStream fileInputStream = null;
        try {
            Element root;
            fileInputStream = new FileInputStream(file.getAbsolutePath());
            SAXBuilder sax = XmlUtilities.createSecureSAXBuilder((boolean)false, (boolean)false);
            Element element = root = sax.build((InputStream)fileInputStream).getRootElement();
            return element;
        }
        catch (Exception e) {
            Msg.showError(this.getClass(), null, (String)"Error Reading Tool", (Object)("Could not read tool: " + String.valueOf(file)), (Throwable)e);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    @Override
    public void exit() {
        this.tool.close();
    }

    @Override
    public ToolServices getToolServices() {
        return new StandAloneToolServices();
    }

    protected static class StandAloneToolServices
    extends ToolServicesAdapter {
        protected StandAloneToolServices() {
        }

        @Override
        public void closeTool(PluginTool t) {
            System.exit(0);
        }

        @Override
        public void saveTool(PluginTool saveTool) {
            Element toolElement = saveTool.saveToXml(true);
            Element dataStateElement = saveTool.saveDataStateToXml(false);
            Element rootElement = new Element("Root");
            rootElement.addContent((Content)toolElement);
            rootElement.addContent((Content)dataStateElement);
            File savedToolFile = new File(Application.getUserSettingsDirectory(), StandAloneApplication.SAVED_TOOL_FILE);
            FileOutputStream os = null;
            try {
                os = new FileOutputStream(savedToolFile);
                Document doc = new Document(rootElement);
                GenericXMLOutputter xmlout = new GenericXMLOutputter();
                xmlout.output(doc, (OutputStream)os);
                ((OutputStream)os).close();
            }
            catch (Exception e) {
                Msg.error((Object)this, (Object)"Error saving tool", (Throwable)e);
                try {
                    if (os != null) {
                        ((OutputStream)os).close();
                    }
                    savedToolFile.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

