/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.wizard.session;

import docking.widgets.conditiontestpanel.ConditionTestListener;
import docking.widgets.conditiontestpanel.ConditionTestPanel;
import docking.widgets.conditiontestpanel.ConditionTester;
import docking.wizard.WizardModel;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.gui.validator.VTPreconditionValidator;
import ghidra.feature.vt.gui.wizard.session.NewSessionData;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.classfinder.ClassSearcher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import utility.function.Callback;

public class PreconditionsPanel
extends JPanel {
    private static final Dimension DEFAULT_SIZE = new Dimension(650, 480);
    private ConditionTestPanel conditionsTestPanel;
    private boolean testsDone = false;
    private Callback statusChangedCallback;

    public PreconditionsPanel(final WizardModel<NewSessionData> model, Callback statusChangedCallback) {
        this.statusChangedCallback = statusChangedCallback;
        this.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.setLayout(new BorderLayout());
        JPanel runButtonPanel = new JPanel();
        runButtonPanel.setBorder(BorderFactory.createEmptyBorder(20, 0, 0, 0));
        runButtonPanel.setLayout(new FlowLayout());
        JButton runTestsButton = new JButton("Run Precondition Checks");
        runTestsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreconditionsPanel.this.conditionsTestPanel.runTests();
            }
        });
        runButtonPanel.add(runTestsButton);
        JButton skipTestsButton = new JButton("Skip");
        skipTestsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreconditionsPanel.this.conditionsTestPanel.skipTests();
                model.goNext();
            }
        });
        runButtonPanel.add(skipTestsButton);
        this.add((Component)runButtonPanel, "South");
    }

    void dispose() {
        if (this.conditionsTestPanel != null) {
            this.conditionsTestPanel.cancel();
        }
    }

    private ConditionTestPanel buildConditionPanel(Program source, Program destination) {
        List<ConditionTester> list = this.getConditionTests(source, destination);
        Collections.sort(list, (t1, t2) -> t1.getName().compareTo(t2.getName()));
        ConditionTestPanel panel = new ConditionTestPanel(list);
        panel.addListener(new ConditionTestListener(){

            public void testsCompleted() {
                PreconditionsPanel.this.testsDone();
            }
        });
        return panel;
    }

    private void testsDone() {
        this.testsDone = true;
        this.statusChangedCallback.call();
        if (this.hasAnyErrorStatus().booleanValue()) {
            Msg.showError(this.getClass(), (Component)this, (String)"Warning - Serious Precondition failures", (Object)"The precondition checks discovered one or more serious problems. \n\nIf you continue, your version tracking results may be invalid.\nYou should review the errors, cancel this wizard, and correct the problems.");
        }
    }

    private List<ConditionTester> getConditionTests(Program sourceProgram, Program destinationProgram) throws SecurityException {
        ArrayList<ConditionTester> list = new ArrayList<ConditionTester>();
        List vtValidatorClasses = ClassSearcher.getClasses(VTPreconditionValidator.class);
        for (Class validatorClass : vtValidatorClasses) {
            try {
                Constructor ctor = validatorClass.getConstructor(Program.class, Program.class, VTSession.class);
                VTPreconditionValidator validator = (VTPreconditionValidator)ctor.newInstance(sourceProgram, destinationProgram, null);
                list.add(validator);
            }
            catch (Exception e) {
                Msg.error((Object)this, (Object)("error including VTPreconditionValidator " + String.valueOf(validatorClass)), (Throwable)e);
            }
        }
        return list;
    }

    private Boolean hasAnyErrorStatus() {
        return this.conditionsTestPanel.getErrorCount() > 0;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension superSize = super.getPreferredSize();
        if (superSize.width > PreconditionsPanel.DEFAULT_SIZE.width && superSize.height > PreconditionsPanel.DEFAULT_SIZE.height) {
            return superSize;
        }
        return DEFAULT_SIZE;
    }

    public void initializeTests(Program sourceProgram, Program destinationProgram) {
        this.testsDone = false;
        if (this.conditionsTestPanel != null) {
            this.remove((Component)this.conditionsTestPanel);
        }
        this.conditionsTestPanel = this.buildConditionPanel(sourceProgram, destinationProgram);
        this.add((Component)this.conditionsTestPanel, "Center");
    }

    public boolean hasRunTests() {
        return this.testsDone;
    }
}

