/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.modules;

import ghidra.app.plugin.core.debug.service.modules.DebuggerStaticMappingServicePlugin;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.trace.model.DefaultTraceLocation;
import ghidra.trace.model.DefaultTraceSpan;
import ghidra.trace.model.ImmutableTraceAddressSnapRange;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.TraceLocation;
import ghidra.trace.model.TraceSpan;
import ghidra.trace.model.modules.TraceStaticMapping;
import ghidra.util.Msg;
import java.net.URL;
import java.util.Objects;

class MappingEntry {
    final TraceStaticMapping mapping;
    final TraceAddressSnapRange tasr;
    Program program;
    private AddressRange staticRange;

    public MappingEntry(TraceStaticMapping mapping) {
        this.mapping = mapping;
        this.tasr = new ImmutableTraceAddressSnapRange(mapping.getTraceAddressRange(), mapping.getLifespan());
    }

    public boolean equals(Object o) {
        if (!(o instanceof MappingEntry)) {
            return false;
        }
        MappingEntry that = (MappingEntry)o;
        if (this.mapping != that.mapping) {
            return false;
        }
        if (this.program != that.program) {
            return false;
        }
        return Objects.equals(this.staticRange, that.staticRange);
    }

    public Trace getTrace() {
        return this.mapping.getTrace();
    }

    Address addrOrMin(Program program, String addr) {
        AddressFactory factory = program.getAddressFactory();
        Address result = factory.getAddress(addr);
        if (result == null) {
            Msg.warn((Object)this, (Object)("Mapping entry has invalid static address: " + addr));
            result = factory.getDefaultAddressSpace().getMinAddress();
        }
        return result;
    }

    Address addrOrMax(Address start, long length) {
        Address result = start.addWrapSpace(length);
        if (result.compareTo((Object)start) < 0) {
            Msg.warn((Object)this, (Object)"Mapping entry caused overflow in static address space");
            return start.getAddressSpace().getMaxAddress();
        }
        return result;
    }

    void clearProgram(DebuggerStaticMappingServicePlugin.ChangeCollector cc, Program program) {
        this.program = null;
        this.staticRange = null;
        cc.traceAffected(this.getTrace());
        cc.programAffected(program);
    }

    void fillProgram(DebuggerStaticMappingServicePlugin.ChangeCollector cc, Program program) {
        this.program = program;
        Address minAddr = this.addrOrMin(program, this.mapping.getStaticAddress());
        Address maxAddr = this.addrOrMax(minAddr, this.mapping.getLength() - 1L);
        this.staticRange = new AddressRangeImpl(minAddr, maxAddr);
        cc.traceAffected(this.getTrace());
        cc.programAffected(program);
    }

    public AddressRange getTraceRange() {
        return this.mapping.getTraceAddressRange();
    }

    public Address getTraceAddress() {
        return this.mapping.getMinTraceAddress();
    }

    public AddressRange getStaticRange() {
        return this.staticRange;
    }

    public Address getStaticAddress() {
        if (this.staticRange == null) {
            return null;
        }
        return this.staticRange.getMinAddress();
    }

    public TraceSpan getTraceSpan() {
        return new DefaultTraceSpan(this.mapping.getTrace(), this.mapping.getLifespan());
    }

    public TraceAddressSnapRange getTraceAddressSnapRange() {
        return this.tasr;
    }

    public boolean isInTraceRange(Address address, Long snap) {
        return this.mapping.getTraceAddressRange().contains(address) && (snap == null || this.mapping.getLifespan().contains((Object)snap));
    }

    public boolean isInTraceRange(AddressRange rng, Long snap) {
        return this.mapping.getTraceAddressRange().intersects(rng) && (snap == null || this.mapping.getLifespan().contains((Object)snap));
    }

    public boolean isInTraceLifespan(long snap) {
        return this.mapping.getLifespan().contains(snap);
    }

    public boolean isInProgramRange(Address address) {
        if (this.staticRange == null) {
            return false;
        }
        return this.staticRange.contains(address);
    }

    public boolean isInProgramRange(AddressRange rng) {
        if (this.staticRange == null) {
            return false;
        }
        return this.staticRange.intersects(rng);
    }

    protected Address mapTraceAddressToProgram(Address address) {
        assert (this.isInTraceRange(address, null));
        long offset = address.subtract(this.mapping.getMinTraceAddress());
        return this.staticRange.getMinAddress().addWrapSpace(offset);
    }

    public ProgramLocation mapTraceAddressToProgramLocation(Address address) {
        if (this.program == null) {
            throw new IllegalStateException("Static program is not opened");
        }
        return new ProgramLocation(this.program, this.mapTraceAddressToProgram(address));
    }

    public AddressRange mapTraceRangeToProgram(AddressRange rng) {
        assert (this.isInTraceRange(rng, null));
        AddressRange part = rng.intersect(this.mapping.getTraceAddressRange());
        Address min = this.mapTraceAddressToProgram(part.getMinAddress());
        Address max = this.mapTraceAddressToProgram(part.getMaxAddress());
        return new AddressRangeImpl(min, max);
    }

    protected Address mapProgramAddressToTrace(Address address) {
        assert (this.isInProgramRange(address));
        long offset = address.subtract(this.staticRange.getMinAddress());
        return this.mapping.getMinTraceAddress().addWrapSpace(offset);
    }

    protected TraceLocation mapProgramAddressToTraceLocation(Address address) {
        return new DefaultTraceLocation(this.mapping.getTrace(), null, this.mapping.getLifespan(), this.mapProgramAddressToTrace(address));
    }

    public AddressRange mapProgramRangeToTrace(AddressRange rng) {
        assert (rng.intersects(this.staticRange));
        AddressRange part = rng.intersect(this.staticRange);
        Address min = this.mapProgramAddressToTrace(part.getMinAddress());
        Address max = this.mapProgramAddressToTrace(part.getMaxAddress());
        return new AddressRangeImpl(min, max);
    }

    public boolean isStaticProgramOpen() {
        return this.program != null;
    }

    public URL getStaticProgramUrl() {
        return this.mapping.getStaticProgramURL();
    }
}

