/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.reloc;

import db.BinaryCodedField;
import db.BinaryField;
import db.ByteField;
import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.IntField;
import db.LongField;
import db.RecordIterator;
import db.Schema;
import db.StringField;
import ghidra.framework.data.OpenMode;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.reloc.RelocationDBAdapterNoTable;
import ghidra.program.database.reloc.RelocationDBAdapterV1;
import ghidra.program.database.reloc.RelocationDBAdapterV2;
import ghidra.program.database.reloc.RelocationDBAdapterV3;
import ghidra.program.database.reloc.RelocationDBAdapterV4;
import ghidra.program.database.reloc.RelocationDBAdapterV5;
import ghidra.program.database.reloc.RelocationDBAdapterV6;
import ghidra.program.database.reloc.RelocationManager;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.reloc.Relocation;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;

abstract class RelocationDBAdapter {
    static final int ADDR_COL = 0;
    static final int FLAGS_COL = 1;
    static final int TYPE_COL = 2;
    static final int VALUE_COL = 3;
    static final int BYTES_COL = 4;
    static final int SYMBOL_NAME_COL = 5;
    static final int STATUS_FLAGS_MASK = 7;
    static final int LENGTH_FLAGS_MASK = 15;
    static final int LENGTH_FLAGS_SHIFT = 3;
    static final int LENGTH_MAX = 31;
    static final String TABLE_NAME = "Relocations";
    static final Schema SCHEMA = new Schema(6, "Index", new Field[]{LongField.INSTANCE, ByteField.INSTANCE, IntField.INSTANCE, BinaryField.INSTANCE, BinaryField.INSTANCE, StringField.INSTANCE}, new String[]{"Address", "Status", "Type", "Values", "Bytes", "Symbol Name"});

    RelocationDBAdapter() {
    }

    static RelocationDBAdapter getAdapter(DBHandle dbHandle, OpenMode openMode, AddressMap addrMap, TaskMonitor monitor) throws VersionException, IOException {
        try {
            return new RelocationDBAdapterV6(dbHandle, addrMap, openMode == OpenMode.CREATE);
        }
        catch (VersionException e) {
            if (!e.isUpgradable() || openMode == OpenMode.UPDATE) {
                throw e;
            }
            RelocationDBAdapter adapter = RelocationDBAdapter.findReadOnlyAdapter(dbHandle, addrMap);
            if (openMode == OpenMode.UPGRADE) {
                adapter = RelocationDBAdapter.upgrade(dbHandle, addrMap, adapter, monitor);
            }
            return adapter;
        }
    }

    private static RelocationDBAdapter findReadOnlyAdapter(DBHandle handle, AddressMap addrMap) throws IOException, VersionException {
        try {
            return new RelocationDBAdapterV5(handle, addrMap);
        }
        catch (VersionException versionException) {
            try {
                return new RelocationDBAdapterV4(handle, addrMap);
            }
            catch (VersionException versionException2) {
                try {
                    return new RelocationDBAdapterV3(handle, addrMap);
                }
                catch (VersionException versionException3) {
                    try {
                        return new RelocationDBAdapterV2(handle, addrMap);
                    }
                    catch (VersionException versionException4) {
                        try {
                            return new RelocationDBAdapterV1(handle, addrMap);
                        }
                        catch (VersionException versionException5) {
                            return new RelocationDBAdapterNoTable(handle);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RelocationDBAdapter upgrade(DBHandle dbHandle, AddressMap addrMap, RelocationDBAdapter oldAdapter, TaskMonitor monitor) throws VersionException, IOException {
        AddressMap oldAddrMap = addrMap.getOldAddressMap();
        try (DBHandle tmpHandle = new DBHandle();){
            tmpHandle.startTransaction();
            RelocationDBAdapterV6 tmpAdapter = new RelocationDBAdapterV6(tmpHandle, addrMap, true);
            RecordIterator iter = oldAdapter.iterator();
            while (iter.hasNext()) {
                DBRecord rec = iter.next();
                Address addr = oldAddrMap.decodeAddress(rec.getLongValue(0));
                BinaryCodedField values = new BinaryCodedField((BinaryField)rec.getFieldValue(3));
                ((RelocationDBAdapter)tmpAdapter).add(addr, rec.getByteValue(1), rec.getIntValue(2), values.getLongArray(), rec.getBinaryData(4), rec.getString(5));
            }
            dbHandle.deleteTable(TABLE_NAME);
            RelocationDBAdapterV6 newAdapter = new RelocationDBAdapterV6(dbHandle, addrMap, true);
            iter = ((RelocationDBAdapter)tmpAdapter).iterator();
            while (iter.hasNext()) {
                DBRecord rec = iter.next();
                newAdapter.put(rec);
            }
            RelocationDBAdapterV6 relocationDBAdapterV6 = newAdapter;
            return relocationDBAdapterV6;
        }
    }

    static byte getFlags(Relocation.Status status, int byteLength) {
        if (byteLength < 0 || byteLength > 31) {
            throw new IllegalArgumentException("unsupport byte-length: " + byteLength);
        }
        int flags = status.getValue() & 7;
        return (byte)(flags |= byteLength << 3);
    }

    static Relocation.Status getStatus(byte flags) {
        try {
            return Relocation.Status.getStatus(flags & 7);
        }
        catch (Exception e) {
            return Relocation.Status.UNKNOWN;
        }
    }

    static int getByteLength(byte flags) {
        return flags >> 3 & 0xF;
    }

    abstract void add(Address var1, byte var2, int var3, long[] var4, byte[] var5, String var6) throws IOException;

    abstract RecordIterator iterator() throws IOException;

    abstract RecordIterator iterator(AddressSetView var1) throws IOException;

    abstract RecordIterator iterator(Address var1) throws IOException;

    abstract int getRecordCount();

    abstract DBRecord adaptRecord(DBRecord var1);

    static void preV6DataMigrationUpgrade(RelocationDBAdapter adapter, Program program, TaskMonitor monitor) throws IOException, CancelledException {
        if (!(adapter instanceof RelocationDBAdapterV6)) {
            throw new AssertException("latest relocation adapter version expected");
        }
        RelocationDBAdapterV6 latestAdapter = (RelocationDBAdapterV6)adapter;
        AddressMap addressMap = program.getAddressMap();
        Memory memory = program.getMemory();
        AddressSetView loadedAndInitializedAddressSet = memory.getLoadedAndInitializedAddressSet();
        ArrayList<DBRecord> list = new ArrayList<DBRecord>();
        RecordIterator recIter = latestAdapter.iterator();
        while (recIter.hasNext()) {
            list.add(recIter.next());
        }
        Collections.sort(list, (r1, r2) -> {
            Address a2;
            Address a1 = addressMap.decodeAddress(r1.getLongValue(0));
            int c = a1.compareTo(a2 = addressMap.decodeAddress(r2.getLongValue(0)));
            if (c == 0) {
                c = Long.compare(r1.getKey(), r2.getKey());
            }
            return c;
        });
        for (int i = 0; i < list.size(); ++i) {
            Relocation.Status status;
            monitor.checkCancelled();
            DBRecord rec = (DBRecord)list.get(i);
            int byteLength = 0;
            Address relocAddr = addressMap.decodeAddress(rec.getLongValue(0));
            byte[] bytes = rec.getBinaryData(4);
            if (!loadedAndInitializedAddressSet.contains(relocAddr)) {
                status = Relocation.Status.FAILURE;
            } else if (bytes != null) {
                status = rec.getIntValue(2) == 0 ? Relocation.Status.APPLIED_OTHER : Relocation.Status.APPLIED;
            } else {
                byteLength = RelocationDBAdapter.computeOriginalFileBytesLength(list, relocAddr, i, program);
                if (byteLength < 0) {
                    status = Relocation.Status.PARTIAL;
                    byteLength = 0;
                } else {
                    status = byteLength == 0 ? Relocation.Status.UNKNOWN : (rec.getIntValue(2) == 0 ? Relocation.Status.APPLIED_OTHER : Relocation.Status.APPLIED);
                }
            }
            rec.setByteValue(1, RelocationDBAdapter.getFlags(status, byteLength));
            latestAdapter.put(rec);
        }
    }

    private static int computeOriginalFileBytesLength(ArrayList<DBRecord> list, Address relocAddr, int index, Program program) throws IOException {
        int byteIndex;
        DBRecord nextRec;
        Address nextAddr;
        AddressSpace space = relocAddr.getAddressSpace();
        AddressMap addrMap = program.getAddressMap();
        Memory memory = program.getMemory();
        int defaultLength = RelocationManager.getDefaultOriginalByteLength(program);
        int nextIndex = index + 1;
        if (nextIndex < list.size() && (nextAddr = addrMap.decodeAddress((nextRec = list.get(nextIndex)).getLongValue(0))).getAddressSpace().equals(relocAddr.getAddressSpace())) {
            defaultLength = (int)Math.min((long)defaultLength, nextAddr.subtract(relocAddr));
        }
        if (defaultLength == 0) {
            return 0;
        }
        try {
            relocAddr.addNoWrap(defaultLength - 1);
        }
        catch (AddressOverflowException e) {
            defaultLength = (int)space.getMaxAddress().subtract(relocAddr) + 1;
        }
        byte[] originalBytes = RelocationManager.getOriginalBytes(memory, relocAddr, defaultLength);
        byte[] currentBytes = new byte[defaultLength];
        try {
        }
        catch (MemoryAccessException e) {
            throw new AssertException((Throwable)((Object)e));
        }
        for (defaultLength = memory.getBytes(relocAddr, currentBytes); defaultLength != 0 && originalBytes[byteIndex = defaultLength - 1] == currentBytes[byteIndex]; --defaultLength) {
        }
        return defaultLength;
    }

    class RecordIteratorAdapter
    implements RecordIterator {
        RecordIterator it;

        RecordIteratorAdapter(RecordIterator it) {
            this.it = it;
        }

        public boolean delete() throws IOException {
            return this.it.delete();
        }

        public boolean hasNext() throws IOException {
            return this.it.hasNext();
        }

        public boolean hasPrevious() throws IOException {
            return this.it.hasPrevious();
        }

        public DBRecord next() throws IOException {
            DBRecord rec = this.it.next();
            return RelocationDBAdapter.this.adaptRecord(rec);
        }

        public DBRecord previous() throws IOException {
            DBRecord rec = this.it.previous();
            return RelocationDBAdapter.this.adaptRecord(rec);
        }
    }
}

