/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main;

import ghidra.framework.main.AppInfo;
import ghidra.framework.main.FrontEndPlugin;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.LinkFileInfo;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectLocator;
import ghidra.framework.protocol.ghidra.GhidraURLQuery;
import ghidra.framework.protocol.ghidra.GhidraURLQueryTask;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Set;

public class AcceptUrlContentTask
extends GhidraURLQueryTask {
    private FrontEndPlugin plugin;

    public AcceptUrlContentTask(URL url, boolean followExternalLinks, FrontEndPlugin plugin) {
        super("Accepting URL", url, null, followExternalLinks ? GhidraURLQuery.LinkFileControl.FOLLOW_EXTERNAL : GhidraURLQuery.LinkFileControl.FOLLOW_INTERNAL);
        this.plugin = plugin;
    }

    private boolean isSameLocalProject(ProjectLocator projectLoc1, ProjectLocator projectLoc2) {
        if (projectLoc1.isTransient() || projectLoc2.isTransient()) {
            return false;
        }
        if (!projectLoc1.getName().equals(projectLoc2.getName())) {
            return false;
        }
        try {
            File proj1Dir = projectLoc1.getProjectDir().getCanonicalFile();
            File proj2Dir = projectLoc2.getProjectDir().getCanonicalFile();
            return proj1Dir.equals(proj2Dir);
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public void processResult(DomainFile domainFile, URL url, TaskMonitor monitor) throws IOException {
        Project activeProject = AppInfo.getActiveProject();
        if (activeProject == null) {
            Msg.showError((Object)this, null, (String)"Ghidra Error", (Object)"Unable to accept URL without active project open");
            return;
        }
        Swing.runNow(() -> {
            LinkFileInfo linkInfo = domainFile.getLinkInfo();
            if (linkInfo != null && linkInfo.isFolderLink()) {
                if (this.isSameLocalProject(activeProject.getProjectLocator(), domainFile.getProjectLocator())) {
                    DomainFile df = activeProject.getProjectData().getFile(domainFile.getPathname());
                    if (df == null) {
                        return;
                    }
                    this.plugin.selectFiles(Set.of(df));
                } else {
                    this.plugin.showInViewedProject(url, false);
                }
            } else {
                AppInfo.getFrontEndTool().getToolServices().launchDefaultToolWithURL(url);
            }
        });
    }

    @Override
    public void processResult(DomainFolder domainFolder, URL url, TaskMonitor monitor) throws IOException {
        Project activeProject = AppInfo.getActiveProject();
        if (activeProject == null) {
            Msg.showError((Object)this, null, (String)"Ghidra Error", (Object)"Unable to accept URL without active project open");
            return;
        }
        Swing.runNow(() -> {
            if (this.isSameLocalProject(activeProject.getProjectLocator(), domainFolder.getProjectLocator())) {
                DomainFolder df = activeProject.getProjectData().getFolder(domainFolder.getPathname());
                if (df == null) {
                    return;
                }
                this.plugin.selectFolder(df);
            } else {
                this.plugin.showInViewedProject(url, true);
            }
        });
    }
}

