/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.replace;

import ghidra.features.base.quickfix.QuickFix;
import ghidra.features.base.quickfix.QuickFixTableProvider;
import ghidra.features.base.quickfix.TableDataLoader;
import ghidra.features.base.replace.SearchAndReplacePlugin;
import ghidra.features.base.replace.SearchAndReplaceQuckFixTableLoader;
import ghidra.features.base.replace.SearchAndReplaceQuery;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;

public class SearchAndReplaceProvider
extends QuickFixTableProvider {
    private SearchAndReplacePlugin plugin;
    private SearchAndReplaceQuery query;

    public SearchAndReplaceProvider(SearchAndReplacePlugin plugin, Program program, SearchAndReplaceQuery query) {
        super(plugin.getTool(), "Search And Replace", plugin.getName(), program, new SearchAndReplaceQuckFixTableLoader(program, query));
        this.plugin = plugin;
        this.query = query;
        this.setTitle(this.generateTitle());
        this.setTabText(this.getTabTitle());
        this.addToTool();
        this.setHelpLocation(new HelpLocation("Search", "Search_And_Replace_Results"));
    }

    @Override
    protected void tableLoaded(boolean wasCancelled, TableDataLoader<QuickFix> loader) {
        if (!loader.didProduceData()) {
            Msg.showInfo(((Object)((Object)this)).getClass(), (Component)this.getComponent(), (String)"No Results Found!", (Object)("No results for \"" + this.query.getSearchText() + "\" found."));
            this.closeComponent();
            return;
        }
        this.setVisible(true);
        if (loader.maxDataSizeReached()) {
            Msg.showInfo(((Object)((Object)this)).getClass(), (Component)this.getComponent(), (String)"Search Limit Exceeded!", (Object)("Stopped search after finding " + this.query.getSearchLimit() + " matches.\nThe search limit can be changed at Edit->Tool Options, under Search."));
        }
        this.toFront();
    }

    @Override
    public void closeComponent() {
        super.closeComponent();
        this.plugin.providerClosed(this);
    }

    private String getTabTitle() {
        return "\"" + this.query.getSearchText() + "\" -> \"" + this.query.getReplacementText() + "\"";
    }

    private String generateTitle() {
        return "Search & Replace:  " + this.getTabTitle();
    }

    @Override
    protected JPanel buildMainPanel() {
        JPanel quickFixPanel = super.buildMainPanel();
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)quickFixPanel, "Center");
        panel.add(this.buildButtonPanel(), "South");
        return panel;
    }

    private Component buildButtonPanel() {
        JButton replaceButton = new JButton("Replace All");
        JButton dismissButton = new JButton("Dismiss");
        replaceButton.addActionListener(e -> this.executeAll());
        dismissButton.addActionListener(e -> this.closeComponent());
        JPanel panel = new JPanel(new FlowLayout(1, 20, 0));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add(replaceButton);
        panel.add(dismissButton);
        return panel;
    }
}

