/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.equate;

import ghidra.app.plugin.core.equate.AbstractConvertAction;
import ghidra.app.plugin.core.equate.EquatePlugin;
import ghidra.program.model.data.ByteDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StringDataInstance;
import ghidra.program.model.listing.Program;
import ghidra.program.model.scalar.Scalar;

public class ConvertToCharAction
extends AbstractConvertAction {
    public static final String ACTION_NAME = "Convert To Char";

    public ConvertToCharAction(EquatePlugin plugin) {
        super(plugin, ACTION_NAME, false);
    }

    @Override
    protected String getMenuName(Program program, Scalar scalar, boolean isData) {
        String valueString = this.convertToString(program, scalar, isData);
        if (valueString == null) {
            return null;
        }
        if (scalar.bitLength() > 8) {
            return this.getStandardLengthString("Char Sequence:") + valueString;
        }
        return this.getStandardLengthString("Char") + valueString;
    }

    @Override
    protected int getFormatChoice() {
        return 4;
    }

    @Override
    protected String convertToString(Program program, Scalar scalar, boolean isData) {
        byte[] bytes = scalar.byteArrayValue();
        return StringDataInstance.getCharRepresentation((DataType)ByteDataType.dataType, (byte[])bytes, null);
    }
}

