/*
 * Decompiled with CFR 0.152.
 */
package pdb.symbolserver.ui;

import docking.widgets.table.AbstractDynamicTableColumnStub;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.GDynamicColumnTableModel;
import docking.widgets.table.GTableCellRenderingData;
import docking.widgets.table.TableColumnDescriptor;
import generic.theme.GIcon;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.framework.plugintool.ServiceProviderStub;
import ghidra.util.table.column.AbstractGColumnRenderer;
import ghidra.util.table.column.GColumnRenderer;
import java.awt.Component;
import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.table.TableColumn;
import pdb.symbolserver.SymbolServer;
import pdb.symbolserver.ui.SymbolServerRow;
import pdb.symbolserver.ui.TableColumnInitializer;
import resources.Icons;

class SymbolServerTableModel
extends GDynamicColumnTableModel<SymbolServerRow, List<SymbolServerRow>> {
    private List<SymbolServerRow> rows = new ArrayList<SymbolServerRow>();
    private boolean dataChanged;

    SymbolServerTableModel() {
        super((ServiceProvider)new ServiceProviderStub());
        this.setDefaultTableSortState(null);
    }

    boolean isEmpty() {
        return this.rows.isEmpty();
    }

    void setSymbolServers(List<SymbolServer> symbolServers) {
        this.rows.clear();
        for (SymbolServer symbolServer : symbolServers) {
            this.rows.add(new SymbolServerRow(symbolServer));
        }
        this.fireTableDataChanged();
    }

    List<SymbolServer> getSymbolServers() {
        return this.rows.stream().map(SymbolServerRow::getSymbolServer).collect(Collectors.toList());
    }

    void addSymbolServer(SymbolServer ss) {
        SymbolServerRow row = new SymbolServerRow(ss);
        this.rows.add(row);
        this.dataChanged = true;
        this.fireTableDataChanged();
    }

    void addSymbolServers(List<SymbolServer> symbolServers) {
        for (SymbolServer symbolServer : symbolServers) {
            this.rows.add(new SymbolServerRow(symbolServer));
        }
        this.dataChanged = true;
        this.fireTableDataChanged();
    }

    void deleteRows(int[] rowIndexes) {
        for (int i = rowIndexes.length - 1; i >= 0; --i) {
            this.rows.remove(rowIndexes[i]);
        }
        this.dataChanged = true;
        this.fireTableDataChanged();
    }

    void moveRow(int rowIndex, int deltaIndex) {
        int destIndex = rowIndex + deltaIndex;
        if (rowIndex < 0 || rowIndex >= this.rows.size() || destIndex < 0 || destIndex >= this.rows.size()) {
            return;
        }
        SymbolServerRow symbolServerRow1 = this.rows.get(rowIndex);
        SymbolServerRow symbolServerRow2 = this.rows.get(destIndex);
        this.rows.set(destIndex, symbolServerRow1);
        this.rows.set(rowIndex, symbolServerRow2);
        this.dataChanged = true;
        this.fireTableDataChanged();
    }

    boolean isDataChanged() {
        return this.dataChanged;
    }

    void setDataChanged(boolean b) {
        this.dataChanged = b;
    }

    public String getName() {
        return "Symbol Server Locations";
    }

    public List<SymbolServerRow> getModelData() {
        return this.rows;
    }

    public List<SymbolServerRow> getDataSource() {
        return this.rows;
    }

    public boolean isSortable(int columnIndex) {
        return false;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        DynamicTableColumn column = this.getColumn(columnIndex);
        if (column instanceof EnabledColumn && aValue instanceof Boolean) {
            SymbolServerRow row = (SymbolServerRow)this.getRowObject(rowIndex);
            row.setEnabled((Boolean)aValue);
            this.dataChanged = true;
            this.fireTableDataChanged();
        } else if (column instanceof TrustedColumn && aValue instanceof Boolean) {
            SymbolServerRow row = (SymbolServerRow)this.getRowObject(rowIndex);
            row.setTrusted((Boolean)aValue);
            this.dataChanged = true;
            this.fireTableDataChanged();
        }
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        DynamicTableColumn column = this.getColumn(columnIndex);
        return column instanceof EnabledColumn || column instanceof TrustedColumn;
    }

    protected TableColumnDescriptor<SymbolServerRow> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn((DynamicTableColumn)new EnabledColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new TrustedColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new StatusColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new LocationColumn());
        return descriptor;
    }

    private static class EnabledColumn
    extends AbstractDynamicTableColumnStub<SymbolServerRow, Boolean>
    implements TableColumnInitializer {
        private EnabledColumn() {
        }

        public String getColumnDisplayName(Settings settings) {
            return "Enabled";
        }

        public Boolean getValue(SymbolServerRow rowObject, Settings settings, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.isEnabled();
        }

        public String getColumnName() {
            return "Enabled";
        }

        @Override
        public void initializeTableColumn(TableColumn col, FontMetrics fm, int padding) {
            int colWidth = fm.stringWidth("Enabled") + padding;
            col.setPreferredWidth(colWidth);
            col.setMaxWidth(colWidth * 2);
            col.setMinWidth(colWidth);
        }
    }

    private static class TrustedColumn
    extends AbstractDynamicTableColumnStub<SymbolServerRow, Boolean>
    implements TableColumnInitializer {
        private TrustedColumn() {
        }

        public String getColumnDisplayName(Settings settings) {
            return "Trusted";
        }

        public Boolean getValue(SymbolServerRow rowObject, Settings settings, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.isTrusted();
        }

        public String getColumnName() {
            return "Trusted";
        }

        @Override
        public void initializeTableColumn(TableColumn col, FontMetrics fm, int padding) {
            int colWidth = fm.stringWidth("Trusted") + padding;
            col.setPreferredWidth(colWidth);
            col.setMaxWidth(colWidth * 2);
            col.setMinWidth(colWidth);
        }
    }

    private static class StatusColumn
    extends AbstractDynamicTableColumnStub<SymbolServerRow, SymbolServerRow.LocationStatus>
    implements TableColumnInitializer {
        private static final Icon VALID_ICON = new GIcon("icon.checkmark.green");
        private static final Icon INVALID_ICON = Icons.ERROR_ICON;
        private static Icon[] icons = new Icon[]{null, VALID_ICON, INVALID_ICON};
        private static String[] toolTips = new String[]{null, "Status: Ok", "Status: Failed"};
        EnumIconColumnRenderer<SymbolServerRow.LocationStatus> renderer = new EnumIconColumnRenderer<SymbolServerRow.LocationStatus>(SymbolServerRow.LocationStatus.class, icons, toolTips);

        private StatusColumn() {
        }

        public SymbolServerRow.LocationStatus getValue(SymbolServerRow rowObject, Settings settings, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.getStatus();
        }

        public String getColumnDisplayName(Settings settings) {
            return "Status";
        }

        public String getColumnName() {
            return "Status";
        }

        public GColumnRenderer<SymbolServerRow.LocationStatus> getColumnRenderer() {
            return this.renderer;
        }

        @Override
        public void initializeTableColumn(TableColumn col, FontMetrics fm, int padding) {
            int colWidth = fm.stringWidth("Status") + padding;
            col.setPreferredWidth(colWidth);
            col.setMaxWidth(colWidth * 2);
            col.setMinWidth(colWidth);
        }
    }

    private static class LocationColumn
    extends AbstractDynamicTableColumnStub<SymbolServerRow, String> {
        private LocationColumn() {
        }

        public String getValue(SymbolServerRow rowObject, Settings settings, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.getSymbolServer().getDescriptiveName();
        }

        public String getColumnName() {
            return "Location";
        }

        public int getColumnPreferredWidth() {
            return 250;
        }
    }

    private static class EnumIconColumnRenderer<E extends Enum<E>>
    extends AbstractGColumnRenderer<E> {
        private Icon[] icons;
        private String[] toolTips;

        EnumIconColumnRenderer(Class<E> enumClass, Icon[] icons, String[] toolTips) {
            if (((Enum[])enumClass.getEnumConstants()).length != icons.length || icons.length != toolTips.length) {
                throw new IllegalArgumentException();
            }
            this.icons = icons;
            this.toolTips = toolTips;
        }

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            JLabel renderer = (JLabel)super.getTableCellRendererComponent(data);
            Enum e = (Enum)data.getValue();
            renderer.setHorizontalAlignment(0);
            renderer.setText("");
            renderer.setIcon(e != null ? this.icons[e.ordinal()] : null);
            renderer.setToolTipText(e != null ? this.toolTips[e.ordinal()] : null);
            return renderer;
        }

        protected String getText(Object value) {
            return "";
        }

        public String getFilterString(E t, Settings settings) {
            return t == null ? "" : ((Enum)t).toString();
        }
    }
}

