/*
 * Decompiled with CFR 0.152.
 */
package ghidra.service.graph;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Attributed {
    private static final String DESCRIPTION = "Description";
    private Map<String, String> attributes = new HashMap<String, String>();

    public Map<String, String> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public String setAttribute(String key, String value) {
        return this.attributes.put(key, value);
    }

    public String getAttribute(String key) {
        return this.attributes.get(key);
    }

    public String removeAttribute(String key) {
        return this.attributes.remove(key);
    }

    public boolean hasAttribute(String key) {
        return this.attributes.containsKey(key);
    }

    public int size() {
        return this.attributes.size();
    }

    public boolean isEmpty() {
        return this.attributes.isEmpty();
    }

    public void putAttributes(Map<String, String> map) {
        this.attributes.putAll(map);
    }

    public void clear() {
        this.attributes.clear();
    }

    public Set<String> keys() {
        return this.attributes.keySet();
    }

    public Collection<String> values() {
        return this.attributes.values();
    }

    public Set<Map.Entry<String, String>> entrySet() {
        return this.attributes.entrySet();
    }

    public String setDescription(String value) {
        return this.attributes.put(DESCRIPTION, value);
    }

    public String getDescription() {
        return this.getAttribute(DESCRIPTION);
    }
}

