import { Attributes } from '@opentelemetry/api';
export interface Hash<ValueType, HashCodeType> {
    (value: ValueType): HashCodeType;
}
export declare class HashMap<KeyType, ValueType, HashCodeType> {
    private _valueMap;
    private _keyMap;
    private _hash;
    constructor(hash: Hash<KeyType, HashCodeType>);
    get(key: KeyType, hashCode?: HashCodeType): ValueType | undefined;
    getOrDefault(key: KeyType, defaultFactory: () => ValueType): ValueType | undefined;
    set(key: KeyType, value: ValueType, hashCode?: HashCodeType): void;
    has(key: KeyType, hashCode?: HashCodeType): boolean;
    keys(): IterableIterator<[KeyType, HashCodeType]>;
    entries(): IterableIterator<[KeyType, ValueType, HashCodeType]>;
    get size(): number;
}
export declare class AttributeHashMap<ValueType> extends HashMap<Attributes, ValueType, string> {
    constructor();
}
//# sourceMappingURL=HashMap.d.ts.map