import { E as Extensions, ae as AgentCard, x as MessageSendParams, F as Message, ay as Task, aQ as TaskStatusUpdateEvent, aS as TaskArtifactUpdateEvent, X as TaskQueryParams, Z as TaskIdParams, $ as TaskPushNotificationConfig, a3 as GetTaskPushNotificationConfigParams, a7 as ListTaskPushNotificationConfigParams, a9 as DeleteTaskPushNotificationConfigParams } from './extensions-DvruCIzw.cjs';

/**
 * Represents a user accessing A2A server.
 */
interface User {
    /**
     * Indicates whether the user is authenticated.
     */
    get isAuthenticated(): boolean;
    /**
     * A unique name (identifier) for the user.
     */
    get userName(): string;
}
/**
 * An implementation of {@link User} representing an unauthenticated user.
 */
declare class UnauthenticatedUser implements User {
    get isAuthenticated(): boolean;
    get userName(): string;
}

declare class ServerCallContext {
    private readonly _requestedExtensions?;
    private readonly _user?;
    private _activatedExtensions?;
    constructor(requestedExtensions?: Extensions, user?: User);
    get user(): User | undefined;
    get activatedExtensions(): Extensions | undefined;
    get requestedExtensions(): Extensions | undefined;
    addActivatedExtension(uri: string): void;
}

interface A2ARequestHandler {
    getAgentCard(): Promise<AgentCard>;
    getAuthenticatedExtendedAgentCard(context?: ServerCallContext): Promise<AgentCard>;
    sendMessage(params: MessageSendParams, context?: ServerCallContext): Promise<Message | Task>;
    sendMessageStream(params: MessageSendParams, context?: ServerCallContext): AsyncGenerator<Message | Task | TaskStatusUpdateEvent | TaskArtifactUpdateEvent, void, undefined>;
    getTask(params: TaskQueryParams, context?: ServerCallContext): Promise<Task>;
    cancelTask(params: TaskIdParams, context?: ServerCallContext): Promise<Task>;
    setTaskPushNotificationConfig(params: TaskPushNotificationConfig, context?: ServerCallContext): Promise<TaskPushNotificationConfig>;
    getTaskPushNotificationConfig(params: TaskIdParams | GetTaskPushNotificationConfigParams, context?: ServerCallContext): Promise<TaskPushNotificationConfig>;
    listTaskPushNotificationConfigs(params: ListTaskPushNotificationConfigParams, context?: ServerCallContext): Promise<TaskPushNotificationConfig[]>;
    deleteTaskPushNotificationConfig(params: DeleteTaskPushNotificationConfigParams, context?: ServerCallContext): Promise<void>;
    resubscribe(params: TaskIdParams, context?: ServerCallContext): AsyncGenerator<Task | TaskStatusUpdateEvent | TaskArtifactUpdateEvent, void, undefined>;
}

export { type A2ARequestHandler as A, ServerCallContext as S, type User as U, UnauthenticatedUser as a };
