//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
/// \file field/field02/src/F02SteppingVerbose.cc
/// \brief Implementation of the F02SteppingVerbose class
//
//
// $Id: F02SteppingVerbose.cc 76247 2013-11-08 11:18:52Z gcosmo $
//
//
//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......
//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......

#include "F02SteppingVerbose.hh"

#include "G4SteppingManager.hh"
#include "G4UnitsTable.hh"

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......

F02SteppingVerbose::F02SteppingVerbose()
 : G4SteppingVerbose()
{}

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......

F02SteppingVerbose::~F02SteppingVerbose()
{}

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......

void F02SteppingVerbose::StepInfo()
{
  CopyState();

  G4int prec = G4cout.precision(3);

  if( verboseLevel >= 1 ){
    if( verboseLevel >= 4 ) VerboseTrack();
    if( verboseLevel >= 3 ){
      G4cout << G4endl;
      G4cout << std::setw( 5) << "#Step#"     << " "
             << std::setw( 6) << "X"          << "    "
             << std::setw( 6) << "Y"          << "    "
             << std::setw( 6) << "Z"          << "    "
             << std::setw( 9) << "KineE"      << " "
             << std::setw( 9) << "dEStep"     << " "
             << std::setw(10) << "StepLeng"
             << std::setw(10) << "TrakLeng"
             << std::setw(10) << "NextVolu"
             << std::setw(10) << "Process"   << G4endl;
    }

    G4cout << std::setw( 5)<<fTrack->GetCurrentStepNumber() << " "
           << std::setw( 6)<<G4BestUnit(fTrack->GetPosition().x(),"Length")
           << std::setw( 6)<<G4BestUnit(fTrack->GetPosition().y(),"Length")
           << std::setw( 6)<<G4BestUnit(fTrack->GetPosition().z(),"Length")
           << std::setw( 6)<<G4BestUnit(fTrack->GetKineticEnergy(),"Energy")
           << std::setw( 6)<<G4BestUnit(fStep->GetTotalEnergyDeposit(),"Energy")
           << std::setw( 6)<<G4BestUnit(fStep->GetStepLength(),"Length")
           << std::setw( 6) << G4BestUnit(fTrack->GetTrackLength(),"Length");

    if( fTrack->GetNextVolume() != 0 ) {
      G4cout << std::setw(10) << fTrack->GetNextVolume()->GetName();
    } else {
      G4cout << std::setw(10) << "OutOfWorld";
    }

    if(fStep->GetPostStepPoint()->GetProcessDefinedStep() != 0){
      G4cout << std::setw(10) 
             << fStep->GetPostStepPoint()->GetProcessDefinedStep()
                                         ->GetProcessName();
    } else {
      G4cout << "   UserLimit";
    }

    G4cout << G4endl;

    if( verboseLevel == 2 ){
      G4int tN2ndariesTot = fN2ndariesAtRestDoIt +
                            fN2ndariesAlongStepDoIt +
                            fN2ndariesPostStepDoIt;
      if(tN2ndariesTot>0){
        G4cout << "    :----- List of 2ndaries - "
               << "#SpawnInStep=" << std::setw(3) << tN2ndariesTot
               << "(Rest="  << std::setw(2) << fN2ndariesAtRestDoIt
               << ",Along=" << std::setw(2) << fN2ndariesAlongStepDoIt
               << ",Post="  << std::setw(2) << fN2ndariesPostStepDoIt
               << "), "
               << " ---------------"
               << G4endl;
        G4cout << "    :-----------------------------"
               << "----------------------------------"
               << "-- EndOf2ndaries Info ---------------"
               << G4endl;
      }
    }

  }
  G4cout.precision(prec);
}

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......

void F02SteppingVerbose::TrackingStarted()
{
  CopyState();
  G4int prec = G4cout.precision(3);
  if( verboseLevel > 0 ){

    G4cout << std::setw( 5) << "Step#"      << " "
           << std::setw( 6) << "X"          << "    "
           << std::setw( 6) << "Y"          << "    "
           << std::setw( 6) << "Z"          << "    "
           << std::setw( 9) << "KineE"      << " "
           << std::setw( 9) << "dEStep"     << " "
           << std::setw(10) << "StepLeng"
           << std::setw(10) << "TrakLeng"
           << std::setw(10) << "NextVolu"
           << std::setw(10) << "Process"    << G4endl;

    G4cout << std::setw( 5)<<fTrack->GetCurrentStepNumber() << " "
           << std::setw( 6)<<G4BestUnit(fTrack->GetPosition().x(),"Length")
           << std::setw( 6)<<G4BestUnit(fTrack->GetPosition().y(),"Length")
           << std::setw( 6)<<G4BestUnit(fTrack->GetPosition().z(),"Length")
           << std::setw( 6)<<G4BestUnit(fTrack->GetKineticEnergy(),"Energy")
           << std::setw( 6)<<G4BestUnit(fStep->GetTotalEnergyDeposit(),"Energy")
           << std::setw( 6)<<G4BestUnit(fStep->GetStepLength(),"Length")
           << std::setw( 6) << G4BestUnit(fTrack->GetTrackLength(),"Length");

    if(fTrack->GetNextVolume()){
      G4cout << std::setw(10) << fTrack->GetNextVolume()->GetName() << " ";
    } else {
      G4cout << std::setw(10) << "OutOfWorld" << " ";
    }
    G4cout << std::setw(10) << "initStep" << G4endl;
  }
  G4cout.precision(prec);
}

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......
