/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class PlainView
extends View
implements TabExpander {
    Color selectedColor;
    Color unselectedColor;
    Color disabledColor;
    int selectionStart;
    int selectionEnd;
    Font font;
    float maxLineLength = -1.0f;
    Element longestLine = null;
    protected FontMetrics metrics;
    private transient Segment lineBuffer;
    private int tabBase;
    private int tabSize;

    public PlainView(Element elem) {
        super(elem);
    }

    protected void updateMetrics() {
        Container component = this.getContainer();
        Font font = component.getFont();
        if (this.font != font) {
            this.font = font;
            this.metrics = component.getFontMetrics(font);
            this.tabSize = this.getTabSize() * this.metrics.charWidth('m');
        }
    }

    protected Rectangle lineToRect(Shape a, int line) {
        this.updateMetrics();
        Rectangle rect = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
        int fontHeight = this.metrics.getHeight();
        return new Rectangle(rect.x, rect.y + line * fontHeight, rect.width, fontHeight);
    }

    public Shape modelToView(int position, Shape a, Position.Bias b) throws BadLocationException {
        this.updateMetrics();
        Document document = this.getDocument();
        int lineIndex = this.getElement().getElementIndex(position);
        Rectangle rect = this.lineToRect(a, lineIndex);
        this.tabBase = rect.x;
        Element line = this.getElement().getElement(lineIndex);
        int lineStart = line.getStartOffset();
        Segment segment = this.getLineBuffer();
        document.getText(lineStart, position - lineStart, segment);
        int xoffset = Utilities.getTabbedTextWidth(segment, this.metrics, this.tabBase, this, lineStart);
        rect.x += xoffset;
        rect.width = 1;
        rect.height = this.metrics.getHeight();
        return rect;
    }

    protected void drawLine(int lineIndex, Graphics g, int x, int y) {
        try {
            Element line = this.getElement().getElement(lineIndex);
            int startOffset = line.getStartOffset();
            int endOffset = line.getEndOffset() - 1;
            if (this.selectionStart <= startOffset) {
                if (this.selectionEnd <= startOffset) {
                    this.drawUnselectedText(g, x, y, startOffset, endOffset);
                } else if (this.selectionEnd <= endOffset) {
                    x = this.drawSelectedText(g, x, y, startOffset, this.selectionEnd);
                    this.drawUnselectedText(g, x, y, this.selectionEnd, endOffset);
                } else {
                    this.drawSelectedText(g, x, y, startOffset, endOffset);
                }
            } else if (this.selectionStart < endOffset) {
                if (this.selectionEnd < endOffset) {
                    x = this.drawUnselectedText(g, x, y, startOffset, this.selectionStart);
                    x = this.drawSelectedText(g, x, y, this.selectionStart, this.selectionEnd);
                    this.drawUnselectedText(g, x, y, this.selectionEnd, endOffset);
                } else {
                    x = this.drawUnselectedText(g, x, y, startOffset, this.selectionStart);
                    this.drawSelectedText(g, x, y, this.selectionStart, endOffset);
                }
            } else {
                this.drawUnselectedText(g, x, y, startOffset, endOffset);
            }
        }
        catch (BadLocationException e) {
            AssertionError ae = new AssertionError((Object)"Unexpected bad location");
            ((Throwable)((Object)ae)).initCause(e);
            throw ae;
        }
    }

    protected int drawSelectedText(Graphics g, int x, int y, int p0, int p1) throws BadLocationException {
        g.setColor(this.selectedColor);
        Segment segment = this.getLineBuffer();
        this.getDocument().getText(p0, p1 - p0, segment);
        return Utilities.drawTabbedText(segment, x, y, g, this, segment.offset);
    }

    protected int drawUnselectedText(Graphics g, int x, int y, int p0, int p1) throws BadLocationException {
        JTextComponent textComponent = (JTextComponent)this.getContainer();
        if (textComponent.isEnabled()) {
            g.setColor(this.unselectedColor);
        } else {
            g.setColor(this.disabledColor);
        }
        Segment segment = this.getLineBuffer();
        this.getDocument().getText(p0, p1 - p0, segment);
        return Utilities.drawTabbedText(segment, x, y, g, this, segment.offset);
    }

    public void paint(Graphics g, Shape s) {
        this.updateMetrics();
        JTextComponent textComponent = (JTextComponent)this.getContainer();
        this.selectedColor = textComponent.getSelectedTextColor();
        this.unselectedColor = textComponent.getForeground();
        this.disabledColor = textComponent.getDisabledTextColor();
        this.selectionStart = textComponent.getSelectionStart();
        this.selectionEnd = textComponent.getSelectionEnd();
        Rectangle rect = s instanceof Rectangle ? (Rectangle)s : s.getBounds();
        this.tabBase = rect.x;
        textComponent.getDocument();
        Element root = this.getElement();
        int height = this.metrics.getHeight();
        LayeredHighlighter hl = null;
        Highlighter h = textComponent.getHighlighter();
        if (h instanceof LayeredHighlighter) {
            hl = (LayeredHighlighter)h;
        }
        int count = root.getElementCount();
        Rectangle clip = g.getClipBounds();
        SwingUtilities.computeIntersection(rect.x, rect.y, rect.width, rect.height, clip);
        int line0 = (clip.y - rect.y) / height;
        line0 = Math.max(0, Math.min(line0, count - 1));
        int line1 = (clip.y + clip.height - rect.y) / height;
        line1 = Math.max(0, Math.min(line1, count - 1));
        int y = rect.y + this.metrics.getAscent() + height * line0;
        int i = line0;
        while (i <= line1) {
            if (hl != null) {
                Element lineEl = root.getElement(i);
                if (i == count) {
                    hl.paintLayeredHighlights(g, lineEl.getStartOffset(), lineEl.getEndOffset(), s, textComponent, this);
                } else {
                    hl.paintLayeredHighlights(g, lineEl.getStartOffset(), lineEl.getEndOffset() - 1, s, textComponent, this);
                }
            }
            this.drawLine(i, g, rect.x, y);
            y += height;
            ++i;
        }
    }

    protected int getTabSize() {
        Object tabSize = this.getDocument().getProperty("tabSize");
        if (tabSize == null) {
            return 8;
        }
        return (Integer)tabSize;
    }

    public float nextTabStop(float x, int tabStop) {
        float next = x;
        if (this.tabSize != 0) {
            int numTabs = ((int)x - this.tabBase) / this.tabSize;
            next = this.tabBase + (numTabs + 1) * this.tabSize;
        }
        return next;
    }

    float determineMaxLineLength() {
        if (this.maxLineLength != -1.0f) {
            return this.maxLineLength;
        }
        Element el = this.getElement();
        Segment seg = this.getLineBuffer();
        float span = 0.0f;
        int i = 0;
        while (i < el.getElementCount()) {
            int width;
            Element child = el.getElement(i);
            int start = child.getStartOffset();
            int end = child.getEndOffset() - 1;
            try {
                el.getDocument().getText(start, end - start, seg);
            }
            catch (BadLocationException ex) {
                AssertionError ae = new AssertionError((Object)"Unexpected bad location");
                ((Throwable)((Object)ae)).initCause(ex);
                throw ae;
            }
            if (seg != null && seg.array != null && seg.count != 0 && (float)(width = this.metrics.charsWidth(seg.array, seg.offset, seg.count)) > span) {
                this.longestLine = child;
                span = width;
            }
            ++i;
        }
        this.maxLineLength = span;
        return this.maxLineLength;
    }

    public float getPreferredSpan(int axis) {
        float span;
        if (axis != 0 && axis != 1) {
            throw new IllegalArgumentException();
        }
        this.updateMetrics();
        Element el = this.getElement();
        switch (axis) {
            case 0: {
                span = this.determineMaxLineLength();
                break;
            }
            default: {
                span = this.metrics.getHeight() * el.getElementCount();
            }
        }
        return span;
    }

    public int viewToModel(float x, float y, Shape a, Position.Bias[] b) {
        int pos;
        Rectangle rec = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
        this.tabBase = rec.x;
        if ((int)y < rec.y) {
            pos = this.getStartOffset();
        } else if ((int)y > rec.y + rec.height) {
            pos = this.getEndOffset() - 1;
        } else {
            Document doc = this.getDocument();
            Element root = doc.getDefaultRootElement();
            int line = Math.abs(((int)y - rec.y) / this.metrics.getHeight());
            if (line >= root.getElementCount()) {
                pos = this.getEndOffset() - 1;
            } else {
                Element lineEl = root.getElement(line);
                if (x < (float)rec.x) {
                    pos = lineEl.getStartOffset();
                } else if (x > (float)(rec.x + rec.width)) {
                    pos = lineEl.getEndOffset() - 1;
                } else {
                    try {
                        int p0 = lineEl.getStartOffset();
                        int p1 = lineEl.getEndOffset();
                        Segment s = new Segment();
                        doc.getText(p0, p1 - p0, s);
                        this.tabBase = rec.x;
                        pos = p0 + Utilities.getTabbedTextOffset(s, this.metrics, this.tabBase, (int)x, this, p0);
                    }
                    catch (BadLocationException badLocationException) {
                        pos = -1;
                    }
                }
            }
        }
        b[0] = Position.Bias.Forward;
        return pos;
    }

    protected void updateDamage(DocumentEvent changes, Shape a, ViewFactory f) {
        if (this.metrics == null) {
            this.updateMetrics();
            this.preferenceChanged(null, true, true);
            return;
        }
        Element element = this.getElement();
        if (this.longestLine == null) {
            this.findLongestLine(0, element.getElementCount() - 1);
        }
        DocumentEvent.ElementChange change = changes.getChange(element);
        if (changes.getType() == DocumentEvent.EventType.INSERT) {
            boolean linesAdded = true;
            if (change == null) {
                linesAdded = false;
            }
            int start = linesAdded ? change.getIndex() : element.getElementIndex(changes.getOffset());
            int length = 0;
            if (linesAdded) {
                length = change.getChildrenAdded().length - 1;
            }
            int oldMaxLength = (int)this.maxLineLength;
            if (this.longestLine.getEndOffset() < changes.getOffset() || this.longestLine.getStartOffset() > changes.getOffset() + changes.getLength()) {
                this.findLongestLine(start, start + length);
            } else {
                this.findLongestLine(0, element.getElementCount() - 1);
            }
            this.preferenceChanged(null, this.maxLineLength != (float)oldMaxLength, linesAdded);
            int endLine = start;
            if (linesAdded) {
                endLine = element.getElementCount() - 1;
            }
            this.damageLineRange(start, endLine, a, this.getContainer());
        } else {
            int oldMaxLength = (int)this.maxLineLength;
            if (change != null) {
                this.findLongestLine(0, element.getElementCount() - 1);
                this.preferenceChanged(null, this.maxLineLength != (float)oldMaxLength, true);
            } else {
                int lineNo = this.getElement().getElementIndex(changes.getOffset());
                Element line = this.getElement().getElement(lineNo);
                if (this.longestLine == line) {
                    this.findLongestLine(0, element.getElementCount() - 1);
                    this.preferenceChanged(null, this.maxLineLength != (float)oldMaxLength, false);
                }
                this.damageLineRange(lineNo, lineNo, a, this.getContainer());
            }
        }
    }

    public void insertUpdate(DocumentEvent changes, Shape a, ViewFactory f) {
        this.updateDamage(changes, a, f);
    }

    public void removeUpdate(DocumentEvent changes, Shape a, ViewFactory f) {
        this.updateDamage(changes, a, f);
    }

    public void changedUpdate(DocumentEvent changes, Shape a, ViewFactory f) {
        this.updateDamage(changes, a, f);
    }

    protected void damageLineRange(int line0, int line1, Shape a, Component host) {
        if (a == null) {
            return;
        }
        Rectangle rec0 = this.lineToRect(a, line0);
        Rectangle rec1 = this.lineToRect(a, line1);
        if (rec0 == null || rec1 == null) {
            host.repaint();
        } else {
            Rectangle repaintRec = SwingUtilities.computeUnion(rec0.x, rec0.y, rec0.width, rec0.height, rec1);
            host.repaint(repaintRec.x, repaintRec.y, repaintRec.width, repaintRec.height);
        }
    }

    protected final Segment getLineBuffer() {
        if (this.lineBuffer == null) {
            this.lineBuffer = new Segment();
        }
        return this.lineBuffer;
    }

    private void findLongestLine(int start, int end) {
        int i = start;
        while (i <= end) {
            int w = this.getLineLength(i);
            if ((float)w > this.maxLineLength) {
                this.maxLineLength = w;
                this.longestLine = this.getElement().getElement(i);
            }
            ++i;
        }
    }

    private int getLineLength(int line) {
        Element lineEl = this.getElement().getElement(line);
        Segment buffer = this.getLineBuffer();
        try {
            Document doc = this.getDocument();
            doc.getText(lineEl.getStartOffset(), lineEl.getEndOffset() - lineEl.getStartOffset() - 1, buffer);
        }
        catch (BadLocationException ex) {
            AssertionError err = new AssertionError((Object)"Unexpected bad location");
            ((Throwable)((Object)err)).initCause(ex);
            throw err;
        }
        return Utilities.getTabbedTextWidth(buffer, this.metrics, this.tabBase, this, lineEl.getStartOffset());
    }
}

