/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.InternalFrameFocusTraversalPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortingFocusTraversalPolicy
extends InternalFrameFocusTraversalPolicy {
    Comparator comparator;
    boolean implicitDownCycleTraversal = true;

    protected SortingFocusTraversalPolicy() {
    }

    public SortingFocusTraversalPolicy(Comparator<? super Component> comparator) {
        this.comparator = comparator;
    }

    protected boolean accept(Component comp) {
        return comp.isVisible() && comp.isDisplayable() && comp.isEnabled() && comp.isFocusable();
    }

    protected Comparator<? super Component> getComparator() {
        return this.comparator;
    }

    protected void setComparator(Comparator<? super Component> comparator) {
        this.comparator = comparator;
    }

    private TreeSet getSortedCycle(Container root, TreeSet set) {
        if (set == null) {
            TreeSet<Component> treeSet = set = this.getComparator() == null ? new TreeSet<Component>() : new TreeSet<Component>(this.getComparator());
        }
        if (root != null) {
            Component[] comps = root.getComponents();
            int i = 0;
            while (i < comps.length) {
                Component c = comps[i];
                if (this.accept(c)) {
                    set.add(c);
                }
                if (c instanceof Container) {
                    this.getSortedCycle((Container)c, set);
                }
                ++i;
            }
        }
        return set;
    }

    @Override
    public Component getComponentAfter(Container root, Component comp) {
        if (comp == null || root == null || !comp.isFocusCycleRoot(root)) {
            throw new IllegalArgumentException();
        }
        if (this.getImplicitDownCycleTraversal() && comp instanceof Container && ((Container)comp).isFocusCycleRoot()) {
            return this.getDefaultComponent((Container)comp);
        }
        TreeSet set = this.getSortedCycle(root, null);
        Iterator i = set.iterator();
        while (i.hasNext()) {
            Component c = (Component)i.next();
            if (c == null || !c.equals(comp)) continue;
            if (!i.hasNext()) break;
            return (Component)i.next();
        }
        return null;
    }

    @Override
    public Component getComponentBefore(Container root, Component comp) {
        if (comp == null || root == null || !comp.isFocusCycleRoot(root)) {
            throw new IllegalArgumentException();
        }
        TreeSet set = this.getSortedCycle(root, null);
        Iterator i = set.iterator();
        Component prev = null;
        while (i.hasNext()) {
            Component c = (Component)i.next();
            if (c != null && c.equals(comp)) break;
            prev = c;
        }
        return prev;
    }

    @Override
    public Component getDefaultComponent(Container root) {
        return this.getFirstComponent(root);
    }

    @Override
    public Component getFirstComponent(Container root) {
        if (root == null) {
            throw new IllegalArgumentException();
        }
        TreeSet set = this.getSortedCycle(root, null);
        Iterator i = set.iterator();
        if (i.hasNext()) {
            return (Component)i.next();
        }
        return null;
    }

    @Override
    public Component getLastComponent(Container root) {
        if (root == null) {
            throw new IllegalArgumentException();
        }
        TreeSet set = this.getSortedCycle(root, null);
        Iterator i = set.iterator();
        Component last = null;
        while (i.hasNext()) {
            last = (Component)i.next();
        }
        return last;
    }

    public boolean getImplicitDownCycleTraversal() {
        return this.implicitDownCycleTraversal;
    }

    public void setImplicitDownCycleTraversal(boolean down) {
        this.implicitDownCycleTraversal = down;
    }
}

