/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.DataBuffer;

public final class DataBufferByte
extends DataBuffer {
    private byte[] data;
    private byte[][] bankData;

    public DataBufferByte(int size) {
        super(0, size, 1, 0);
        this.bankData = new byte[1][];
        this.data = new byte[size];
        this.bankData[0] = this.data;
    }

    public DataBufferByte(int size, int numBanks) {
        super(0, size, numBanks);
        this.bankData = new byte[numBanks][size];
        this.data = this.bankData[0];
    }

    public DataBufferByte(byte[] dataArray, int size) {
        super(0, size, 1, 0);
        this.bankData = new byte[1][];
        this.data = dataArray;
        this.bankData[0] = this.data;
    }

    public DataBufferByte(byte[] dataArray, int size, int offset) {
        super(0, size, 1, offset);
        this.bankData = new byte[1][];
        this.data = dataArray;
        this.bankData[0] = this.data;
    }

    public DataBufferByte(byte[][] dataArray, int size) {
        super(0, size, dataArray.length);
        this.bankData = dataArray;
        this.data = this.bankData[0];
    }

    public DataBufferByte(byte[][] dataArray, int size, int[] offsets) {
        super(0, size, dataArray.length, offsets);
        this.bankData = dataArray;
        this.data = this.bankData[0];
    }

    public byte[] getData() {
        return this.data;
    }

    public byte[] getData(int bank) {
        return this.bankData[bank];
    }

    public byte[][] getBankData() {
        return this.bankData;
    }

    public int getElem(int i) {
        return this.data[i + this.offset] & 0xFF;
    }

    public int getElem(int bank, int i) {
        return this.bankData[bank][i + this.offsets[bank]] & 0xFF;
    }

    public void setElem(int i, int val) {
        this.data[i + this.offset] = (byte)val;
    }

    public void setElem(int bank, int i, int val) {
        this.bankData[bank][i + this.offsets[bank]] = (byte)val;
    }
}

