/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.GraphicAttribute;
import java.awt.geom.Rectangle2D;

public final class ShapeGraphicAttribute
extends GraphicAttribute {
    public static final boolean FILL = false;
    public static final boolean STROKE = true;
    private Shape shape;
    private boolean stroke;
    private Rectangle2D bounds;

    public ShapeGraphicAttribute(Shape shape, int alignment, boolean stroke) {
        super(alignment);
        this.shape = shape;
        this.stroke = stroke;
        this.bounds = shape.getBounds2D();
    }

    public void draw(Graphics2D graphics, float x, float y) {
        graphics.translate(x, y);
        if (this.stroke) {
            graphics.draw(this.shape);
        } else {
            graphics.fill(this.shape);
        }
        graphics.translate(-x, -y);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ShapeGraphicAttribute)) {
            return false;
        }
        return this.equals((ShapeGraphicAttribute)obj);
    }

    public boolean equals(ShapeGraphicAttribute rhs) {
        return this == rhs || this.shape.equals(rhs.shape) && this.getAlignment() == rhs.getAlignment() && this.stroke == rhs.stroke && this.getAdvance() == rhs.getAdvance() && this.getAscent() == rhs.getAscent() && this.getBounds().equals(rhs.getBounds()) && this.getDescent() == rhs.getDescent() && this.hashCode() == rhs.hashCode();
    }

    public float getAdvance() {
        return Math.max(0.0f, (float)this.bounds.getMaxX());
    }

    public float getAscent() {
        return Math.max(0.0f, -((float)this.bounds.getMinY()));
    }

    public float getDescent() {
        return Math.max(0.0f, (float)this.bounds.getMaxY());
    }

    public Rectangle2D getBounds() {
        Rectangle2D.Float bounds = new Rectangle2D.Float();
        bounds.setRect(this.bounds);
        if (this.stroke) {
            bounds.width += 1.0f;
            bounds.height += 1.0f;
        }
        return bounds;
    }

    public int hashCode() {
        return this.shape.hashCode();
    }
}

