/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.dom;

import gnu.xml.dom.DTDAttributeTypeInfo;
import gnu.xml.dom.DomAttr;
import gnu.xml.dom.DomDOMException;
import gnu.xml.dom.DomDoctype;
import gnu.xml.dom.DomElement;
import gnu.xml.dom.DomNode;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DomNamedNodeMap
implements NamedNodeMap {
    final DomNode owner;
    final short type;
    DomNode first;
    int length;
    boolean readonly;

    DomNamedNodeMap(DomNode owner, short type) {
        this.owner = owner;
        this.type = type;
    }

    public final boolean isReadonly() {
        return this.readonly;
    }

    public void makeReadonly() {
        this.readonly = true;
        DomNode ctx = this.first;
        while (ctx != null) {
            ctx.makeReadonly();
            ctx = ctx.next;
        }
    }

    public Node getNamedItem(String name) {
        DomNode ctx = this.first;
        while (ctx != null) {
            if (ctx.getNodeName().equals(name)) {
                return ctx;
            }
            ctx = ctx.next;
        }
        return null;
    }

    public Node getNamedItemNS(String namespaceURI, String localName) {
        if ("".equals(namespaceURI)) {
            namespaceURI = null;
        }
        DomNode ctx = this.first;
        while (ctx != null) {
            String name = ctx.getLocalName();
            if (localName == null && name == null || localName != null && localName.equals(name)) {
                String uri = ctx.getNamespaceURI();
                if ("".equals(uri)) {
                    uri = null;
                }
                if (namespaceURI == null && uri == null || namespaceURI != null && namespaceURI.equals(uri)) {
                    return ctx;
                }
            }
            ctx = ctx.next;
        }
        return null;
    }

    public Node setNamedItem(Node arg) {
        return this.setNamedItem(arg, false, false);
    }

    public Node setNamedItemNS(Node arg) {
        return this.setNamedItem(arg, true, false);
    }

    Node setNamedItem(Node arg, boolean ns, boolean cloning) {
        String namespaceURI;
        if (this.readonly) {
            throw new DomDOMException(7);
        }
        DomNode node2 = (DomNode)arg;
        if (!cloning && node2.owner != this.owner.owner) {
            throw new DomDOMException(4);
        }
        if (node2.nodeType != this.type) {
            throw new DomDOMException(3);
        }
        if (node2.nodeType == 2) {
            DomNode element = node2.parent;
            if (element != null && element != this.owner) {
                throw new DomDOMException(10);
            }
            node2.parent = this.owner;
            node2.depth = this.owner.depth + 1;
        }
        String nodeName = node2.getNodeName();
        String localName = ns ? node2.getLocalName() : null;
        String string = namespaceURI = ns ? node2.getNamespaceURI() : null;
        if ("".equals(namespaceURI)) {
            namespaceURI = null;
        }
        DomNode last = null;
        DomNode ctx = this.first;
        while (ctx != null) {
            boolean test = false;
            if (ns) {
                String tu;
                String tln = ctx.getLocalName();
                if (tln == null) {
                    tln = ctx.getNodeName();
                }
                if (tln.equals(localName) && ((tu = ctx.getNamespaceURI()) == null && namespaceURI == null || tu != null && tu.equals(namespaceURI))) {
                    test = true;
                }
            } else {
                test = ctx.getNodeName().equals(nodeName);
            }
            if (test) {
                node2.previous = ctx.previous;
                node2.next = ctx.next;
                if (ctx.previous != null) {
                    ctx.previous.next = node2;
                }
                if (ctx.next != null) {
                    ctx.next.previous = node2;
                }
                if (this.first == ctx) {
                    this.first = node2;
                }
                this.reparent(node2, nodeName, ctx.index);
                ctx.parent = null;
                ctx.next = null;
                ctx.previous = null;
                ctx.setDepth(0);
                ctx.index = 0;
                return ctx;
            }
            last = ctx;
            ctx = ctx.next;
        }
        if (last != null) {
            last.next = node2;
            node2.previous = last;
        } else {
            this.first = node2;
        }
        ++this.length;
        this.reparent(node2, nodeName, 0);
        return null;
    }

    void reparent(DomNode node2, String nodeName, int i) {
        node2.parent = this.owner;
        node2.setDepth(this.owner.depth + 1);
        DomNode ctx = node2;
        while (ctx != null) {
            ctx.index = i++;
            ctx = ctx.next;
        }
        boolean xmlSpace = "xml:space".equals(nodeName);
        if (xmlSpace && this.owner instanceof DomElement) {
            ((DomElement)this.owner).xmlSpace = node2.getNodeValue();
        }
    }

    public Node removeNamedItem(String name) {
        return this.removeNamedItem(null, name, false);
    }

    public Node removeNamedItemNS(String namespaceURI, String localName) {
        return this.removeNamedItem(namespaceURI, localName, true);
    }

    Node removeNamedItem(String uri, String name, boolean ns) {
        if (this.readonly) {
            throw new DomDOMException(7);
        }
        DomNode ctx = this.first;
        while (ctx != null) {
            boolean test = false;
            String nodeName = ctx.getNodeName();
            if (ns) {
                String tu;
                String tln = ctx.getLocalName();
                if (name != null && name.equals(tln) && ((tu = ctx.getNamespaceURI()) == null && uri == null || tu != null && tu.equals(uri))) {
                    test = true;
                }
            } else {
                test = nodeName.equals(name);
            }
            if (test) {
                String def;
                boolean xmlSpace = "xml:space".equals(nodeName);
                if (xmlSpace && this.owner instanceof DomElement) {
                    ((DomElement)this.owner).xmlSpace = "";
                }
                if (ctx.nodeType == 2 && (def = this.getDefaultValue(ctx.getNodeName())) != null) {
                    ctx.setNodeValue(def);
                    ((DomAttr)ctx).setSpecified(false);
                    return null;
                }
                if (ctx == this.first) {
                    this.first = ctx.next;
                }
                if (ctx.previous != null) {
                    ctx.previous.next = ctx.next;
                }
                if (ctx.next != null) {
                    ctx.next.previous = ctx.previous;
                }
                --this.length;
                ctx.previous = null;
                ctx.next = null;
                ctx.parent = null;
                ctx.setDepth(0);
                ctx.index = 0;
                return ctx;
            }
            ctx = ctx.next;
        }
        throw new DomDOMException(8);
    }

    String getDefaultValue(String name) {
        DomDoctype doctype = (DomDoctype)this.owner.owner.getDoctype();
        if (doctype == null) {
            return null;
        }
        DTDAttributeTypeInfo info = doctype.getAttributeTypeInfo(this.owner.getNodeName(), name);
        if (info == null) {
            return null;
        }
        return info.value;
    }

    public Node item(int index) {
        DomNode ctx = this.first;
        int count = 0;
        while (ctx != null && count < index) {
            ctx = ctx.next;
            ++count;
        }
        return ctx;
    }

    public int getLength() {
        return this.length;
    }
}

