/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.jce.sig;

import gnu.javax.crypto.jce.GnuCrypto;
import gnu.javax.crypto.key.dh.RFC2631;
import java.math.BigInteger;
import java.security.AlgorithmParameterGeneratorSpi;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.DHGenParameterSpec;
import javax.crypto.spec.DHParameterSpec;

public class DHParametersGenerator
extends AlgorithmParameterGeneratorSpi {
    private static final Provider GNU_CRYPTO = new GnuCrypto();
    private int modulusSize = -1;
    private int exponentSize = -1;
    private SecureRandom rnd;
    private RFC2631 rfc2631;

    protected void engineInit(int size, SecureRandom random) {
        if (size % 256 != 0 || size < 512) {
            throw new InvalidParameterException("Prime modulus (p) size (in bits) MUST be a multiple of 256, and greater than or equal to 1024");
        }
        this.modulusSize = size;
        this.rnd = random;
    }

    protected void engineInit(AlgorithmParameterSpec spec, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (spec instanceof DHParameterSpec) {
            DHParameterSpec dhSpec = (DHParameterSpec)spec;
            BigInteger p = dhSpec.getP();
            int size = p.bitLength();
            this.engineInit(size, random);
        } else if (spec instanceof DHGenParameterSpec) {
            DHGenParameterSpec dhSpec = (DHGenParameterSpec)spec;
            int size = dhSpec.getPrimeSize();
            this.engineInit(size, random);
            this.exponentSize = dhSpec.getExponentSize();
            if (this.exponentSize % 8 != 0 || this.exponentSize < 160) {
                throw new InvalidParameterException("Random exponent size (in bits) MUST be a multiple of 8, and greater than or equal to 160");
            }
            if (this.exponentSize > this.modulusSize) {
                throw new InvalidParameterException("Random exponent size (in bits) MUST be less than that of the public prime modulus (p)");
            }
        }
        throw new InvalidAlgorithmParameterException("Wrong AlgorithmParameterSpec type: " + spec.getClass().getName());
    }

    protected AlgorithmParameters engineGenerateParameters() {
        if (this.modulusSize < 1) {
            this.modulusSize = 512;
        }
        if (this.exponentSize < 1) {
            this.exponentSize = 160;
        }
        this.rfc2631 = new RFC2631(this.exponentSize, this.modulusSize, this.rnd);
        BigInteger[] params = this.rfc2631.generateParameters();
        BigInteger p = params[3];
        BigInteger g = params[5];
        int l = params[2].bitLength();
        DHParameterSpec spec = new DHParameterSpec(p, g, l);
        AlgorithmParameters result = null;
        try {
            result = AlgorithmParameters.getInstance("dh", GNU_CRYPTO);
            result.init(spec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {}
        return result;
    }
}

