/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.jce.sig;

import gnu.javax.crypto.key.dh.DHKeyPairPKCS8Codec;
import gnu.javax.crypto.key.dh.DHKeyPairX509Codec;
import gnu.javax.crypto.key.dh.GnuDHPrivateKey;
import gnu.javax.crypto.key.dh.GnuDHPublicKey;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHPrivateKeySpec;
import javax.crypto.spec.DHPublicKeySpec;

public class DHKeyFactory
extends KeyFactorySpi {
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof DHPublicKeySpec) {
            DHPublicKeySpec spec = (DHPublicKeySpec)keySpec;
            BigInteger p = spec.getP();
            BigInteger g = spec.getG();
            BigInteger y = spec.getY();
            return new GnuDHPublicKey(2, null, p, g, y);
        }
        if (keySpec instanceof X509EncodedKeySpec) {
            X509EncodedKeySpec spec = (X509EncodedKeySpec)keySpec;
            byte[] encoded = spec.getEncoded();
            try {
                PublicKey result = new DHKeyPairX509Codec().decodePublicKey(encoded);
                return result;
            }
            catch (RuntimeException x) {
                InvalidKeySpecException y = new InvalidKeySpecException();
                y.initCause(x);
                throw y;
            }
        }
        throw new InvalidKeySpecException("Unsupported (public) key specification");
    }

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof DHPrivateKeySpec) {
            DHPrivateKeySpec spec = (DHPrivateKeySpec)keySpec;
            BigInteger p = spec.getP();
            BigInteger g = spec.getG();
            BigInteger x = spec.getX();
            return new GnuDHPrivateKey(3, null, p, g, x);
        }
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            PKCS8EncodedKeySpec spec = (PKCS8EncodedKeySpec)keySpec;
            byte[] encoded = spec.getEncoded();
            try {
                PrivateKey result = new DHKeyPairPKCS8Codec().decodePrivateKey(encoded);
                return result;
            }
            catch (RuntimeException x) {
                InvalidKeySpecException y = new InvalidKeySpecException();
                y.initCause(x);
                throw y;
            }
        }
        throw new InvalidKeySpecException("Unsupported (private) key specification");
    }

    protected KeySpec engineGetKeySpec(Key key, Class keySpec) throws InvalidKeySpecException {
        if (key instanceof DHPublicKey) {
            if (keySpec.isAssignableFrom(DHPublicKeySpec.class)) {
                DHPublicKey dssKey = (DHPublicKey)key;
                BigInteger p = dssKey.getParams().getP();
                BigInteger g = dssKey.getParams().getG();
                BigInteger y = dssKey.getY();
                return new DHPublicKeySpec(y, p, g);
            }
            if (keySpec.isAssignableFrom(X509EncodedKeySpec.class)) {
                if (key instanceof GnuDHPublicKey) {
                    GnuDHPublicKey dhKey = (GnuDHPublicKey)key;
                    byte[] encoded = dhKey.getEncoded(2);
                    return new X509EncodedKeySpec(encoded);
                }
                if ("X.509".equalsIgnoreCase(key.getFormat())) {
                    byte[] encoded = key.getEncoded();
                    return new X509EncodedKeySpec(encoded);
                }
                throw new InvalidKeySpecException("Wrong key type or unsupported (public) key specification");
            }
            throw new InvalidKeySpecException("Unsupported (public) key specification");
        }
        if (key instanceof DHPrivateKey) {
            if (keySpec.isAssignableFrom(DHPrivateKeySpec.class)) {
                DHPrivateKey dhKey = (DHPrivateKey)key;
                BigInteger p = dhKey.getParams().getP();
                BigInteger g = dhKey.getParams().getG();
                BigInteger x = dhKey.getX();
                return new DHPrivateKeySpec(x, p, g);
            }
            if (keySpec.isAssignableFrom(PKCS8EncodedKeySpec.class)) {
                if (key instanceof GnuDHPrivateKey) {
                    GnuDHPrivateKey dhKey = (GnuDHPrivateKey)key;
                    byte[] encoded = dhKey.getEncoded(3);
                    return new PKCS8EncodedKeySpec(encoded);
                }
                if ("PKCS#8".equalsIgnoreCase(key.getFormat())) {
                    byte[] encoded = key.getEncoded();
                    return new PKCS8EncodedKeySpec(encoded);
                }
                throw new InvalidKeySpecException("Wrong key type or unsupported (private) key specification");
            }
            throw new InvalidKeySpecException("Unsupported (private) key specification");
        }
        throw new InvalidKeySpecException("Wrong key type or unsupported key specification");
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key instanceof GnuDHPublicKey || key instanceof GnuDHPrivateKey) {
            return key;
        }
        if (key instanceof DHPublicKey) {
            DHPublicKey dsaKey = (DHPublicKey)key;
            BigInteger p = dsaKey.getParams().getP();
            BigInteger g = dsaKey.getParams().getG();
            BigInteger y = dsaKey.getY();
            return new GnuDHPublicKey(2, null, p, g, y);
        }
        if (key instanceof DHPrivateKey) {
            DHPrivateKey dsaKey = (DHPrivateKey)key;
            BigInteger p = dsaKey.getParams().getP();
            BigInteger g = dsaKey.getParams().getG();
            BigInteger x = dsaKey.getX();
            return new GnuDHPrivateKey(3, null, p, g, x);
        }
        throw new InvalidKeyException("Wrong key type");
    }
}

