/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.AWTUtilities;
import gnu.java.awt.ClasspathToolkit;
import gnu.java.awt.EmbeddedWindow;
import gnu.java.awt.dnd.GtkMouseDragGestureRecognizer;
import gnu.java.awt.dnd.peer.gtk.GtkDragSourceContextPeer;
import gnu.java.awt.peer.ClasspathFontPeer;
import gnu.java.awt.peer.EmbeddedWindowPeer;
import gnu.java.awt.peer.gtk.AsyncImage;
import gnu.java.awt.peer.gtk.CairoSurface;
import gnu.java.awt.peer.gtk.GdkFontPeer;
import gnu.java.awt.peer.gtk.GdkGraphicsEnvironment;
import gnu.java.awt.peer.gtk.GdkPixbufDecoder;
import gnu.java.awt.peer.gtk.GdkRobotPeer;
import gnu.java.awt.peer.gtk.GtkButtonPeer;
import gnu.java.awt.peer.gtk.GtkCanvasPeer;
import gnu.java.awt.peer.gtk.GtkCheckboxMenuItemPeer;
import gnu.java.awt.peer.gtk.GtkCheckboxPeer;
import gnu.java.awt.peer.gtk.GtkChoicePeer;
import gnu.java.awt.peer.gtk.GtkClipboard;
import gnu.java.awt.peer.gtk.GtkComponentPeer;
import gnu.java.awt.peer.gtk.GtkCursor;
import gnu.java.awt.peer.gtk.GtkDialogPeer;
import gnu.java.awt.peer.gtk.GtkEmbeddedWindowPeer;
import gnu.java.awt.peer.gtk.GtkFileDialogPeer;
import gnu.java.awt.peer.gtk.GtkFramePeer;
import gnu.java.awt.peer.gtk.GtkImage;
import gnu.java.awt.peer.gtk.GtkLabelPeer;
import gnu.java.awt.peer.gtk.GtkListPeer;
import gnu.java.awt.peer.gtk.GtkMainThread;
import gnu.java.awt.peer.gtk.GtkMenuBarPeer;
import gnu.java.awt.peer.gtk.GtkMenuItemPeer;
import gnu.java.awt.peer.gtk.GtkMenuPeer;
import gnu.java.awt.peer.gtk.GtkMouseInfoPeer;
import gnu.java.awt.peer.gtk.GtkPanelPeer;
import gnu.java.awt.peer.gtk.GtkPopupMenuPeer;
import gnu.java.awt.peer.gtk.GtkScrollPanePeer;
import gnu.java.awt.peer.gtk.GtkScrollbarPeer;
import gnu.java.awt.peer.gtk.GtkTextAreaPeer;
import gnu.java.awt.peer.gtk.GtkTextFieldPeer;
import gnu.java.awt.peer.gtk.GtkWindowPeer;
import java.awt.AWTException;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.Scrollbar;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.peer.DragSourceContextPeer;
import java.awt.font.TextAttribute;
import java.awt.im.InputMethodHighlight;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.peer.ButtonPeer;
import java.awt.peer.CanvasPeer;
import java.awt.peer.CheckboxMenuItemPeer;
import java.awt.peer.CheckboxPeer;
import java.awt.peer.ChoicePeer;
import java.awt.peer.DialogPeer;
import java.awt.peer.FileDialogPeer;
import java.awt.peer.FontPeer;
import java.awt.peer.FramePeer;
import java.awt.peer.LabelPeer;
import java.awt.peer.ListPeer;
import java.awt.peer.MenuBarPeer;
import java.awt.peer.MenuItemPeer;
import java.awt.peer.MenuPeer;
import java.awt.peer.MouseInfoPeer;
import java.awt.peer.PanelPeer;
import java.awt.peer.PopupMenuPeer;
import java.awt.peer.RobotPeer;
import java.awt.peer.ScrollPanePeer;
import java.awt.peer.ScrollbarPeer;
import java.awt.peer.TextAreaPeer;
import java.awt.peer.TextFieldPeer;
import java.awt.peer.WindowPeer;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import javax.imageio.spi.IIORegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GtkToolkit
extends ClasspathToolkit {
    static final Object GTK_LOCK;
    private static EventQueue q;
    private static boolean initializedGlobalIDs;
    private LRUCache<Map, ClasspathFontPeer> fontCache = new LRUCache(50);
    private LRUCache<Object, Image> imageCache = new LRUCache(50);

    static {
        initializedGlobalIDs = false;
        System.loadLibrary("gtkpeer");
        GtkToolkit.initializeGlobalIDs();
        String portNatSyncProp = System.getProperty("gnu.classpath.awt.gtk.portable.native.sync");
        int portableNativeSync = portNatSyncProp == null ? -1 : (Boolean.valueOf(portNatSyncProp) != false ? 1 : 0);
        GTK_LOCK = new String("GTK LOCK");
        GtkToolkit.gtkInit(portableNativeSync, GTK_LOCK);
    }

    static native void gtkInit(int var0, Object var1);

    static native void gtkMain();

    static native void gtkQuit();

    private static native void initIDs();

    static synchronized void initializeGlobalIDs() {
        if (!initializedGlobalIDs) {
            GtkToolkit.initIDs();
            initializedGlobalIDs = true;
        }
    }

    @Override
    public native void beep();

    private native void getScreenSizeDimensions(int[] var1);

    @Override
    public int checkImage(Image image, int width, int height, ImageObserver observer) {
        int status = 35;
        if (image instanceof GtkImage) {
            return ((GtkImage)image).checkImage(observer);
        }
        if (image instanceof AsyncImage) {
            return ((AsyncImage)image).checkImage(observer);
        }
        if (observer != null) {
            observer.imageUpdate(image, status, -1, -1, image.getWidth(observer), image.getHeight(observer));
        }
        return status;
    }

    static Image imageOrError(Image b) {
        if (b == null) {
            return GtkImage.getErrorImage();
        }
        return b;
    }

    @Override
    public Image createImage(String filename) {
        BufferedImage image;
        if (filename.length() == 0) {
            return new GtkImage();
        }
        try {
            image = CairoSurface.getBufferedImage(new GtkImage(filename));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            image = null;
        }
        return GtkToolkit.imageOrError(image);
    }

    @Override
    public Image createImage(URL url) {
        return new AsyncImage(url);
    }

    @Override
    public Image createImage(ImageProducer producer) {
        BufferedImage image;
        if (producer == null) {
            return null;
        }
        try {
            image = CairoSurface.getBufferedImage(new GtkImage(producer));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            image = null;
        }
        return GtkToolkit.imageOrError(image);
    }

    @Override
    public Image createImage(byte[] imagedata, int imageoffset, int imagelength) {
        BufferedImage image;
        try {
            byte[] data = new byte[imagelength];
            System.arraycopy(imagedata, imageoffset, data, 0, imagelength);
            image = CairoSurface.getBufferedImage(new GtkImage(data));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            image = null;
        }
        return GtkToolkit.imageOrError(image);
    }

    public ImageProducer createImageProducer(URL url) {
        return this.createImage(url).getSource();
    }

    @Override
    public ColorModel getColorModel() {
        return new DirectColorModel(32, 255, 65280, 0xFF0000, -16777216);
    }

    @Override
    public String[] getFontList() {
        return new String[]{"Dialog", "DialogInput", "Monospaced", "Serif", "SansSerif"};
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        return ((GdkFontPeer)font.getPeer()).getFontMetrics(font);
    }

    @Override
    public Image getImage(String filename) {
        if (this.imageCache.containsKey(filename)) {
            return (Image)this.imageCache.get(filename);
        }
        Image im = this.createImage(filename);
        this.imageCache.put(filename, im);
        return im;
    }

    @Override
    public Image getImage(URL url) {
        if (this.imageCache.containsKey(url)) {
            return (Image)this.imageCache.get(url);
        }
        Image im = this.createImage(url);
        this.imageCache.put(url, im);
        return im;
    }

    @Override
    public PrintJob getPrintJob(Frame frame, String jobtitle, Properties props) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPrintJobAccess();
        }
        return null;
    }

    @Override
    public native int getScreenResolution();

    @Override
    public Dimension getScreenSize() {
        int[] dim = new int[2];
        this.getScreenSizeDimensions(dim);
        return new Dimension(dim[0], dim[1]);
    }

    @Override
    public Clipboard getSystemClipboard() {
        SecurityManager secman = System.getSecurityManager();
        if (secman != null) {
            secman.checkSystemClipboardAccess();
        }
        return GtkClipboard.getClipboardInstance();
    }

    @Override
    public Clipboard getSystemSelection() {
        SecurityManager secman = System.getSecurityManager();
        if (secman != null) {
            secman.checkSystemClipboardAccess();
        }
        return GtkClipboard.getSelectionInstance();
    }

    @Override
    public boolean prepareImage(Image image, int width, int height, ImageObserver observer) {
        if (image instanceof GtkImage) {
            return (((GtkImage)image).checkImage(observer) & 0x20) != 0;
        }
        if (image instanceof AsyncImage) {
            AsyncImage aImg = (AsyncImage)image;
            aImg.addObserver(observer);
            return aImg.realImage != null;
        }
        return true;
    }

    @Override
    public native void sync();

    protected void setComponentState(Component c, GtkComponentPeer cp) {
        if (c.getForeground() == null) {
            c.setForeground(cp.getForeground());
        }
        if (c.getBackground() == null) {
            c.setBackground(cp.getBackground());
        }
        if (!(c instanceof Window)) {
            cp.setCursor(c.getCursor());
            Rectangle bounds = c.getBounds();
            cp.setBounds(bounds.x, bounds.y, bounds.width, bounds.height);
            cp.setVisible(c.isVisible());
        }
    }

    @Override
    protected ButtonPeer createButton(Button b) {
        this.checkHeadless();
        return new GtkButtonPeer(b);
    }

    @Override
    protected CanvasPeer createCanvas(Canvas c) {
        this.checkHeadless();
        return new GtkCanvasPeer(c);
    }

    @Override
    protected CheckboxPeer createCheckbox(Checkbox cb) {
        this.checkHeadless();
        return new GtkCheckboxPeer(cb);
    }

    @Override
    protected CheckboxMenuItemPeer createCheckboxMenuItem(CheckboxMenuItem cmi) {
        this.checkHeadless();
        return new GtkCheckboxMenuItemPeer(cmi);
    }

    @Override
    protected ChoicePeer createChoice(Choice c) {
        this.checkHeadless();
        return new GtkChoicePeer(c);
    }

    @Override
    protected DialogPeer createDialog(Dialog d) {
        this.checkHeadless();
        GtkMainThread.createWindow();
        return new GtkDialogPeer(d);
    }

    @Override
    protected FileDialogPeer createFileDialog(FileDialog fd) {
        this.checkHeadless();
        return new GtkFileDialogPeer(fd);
    }

    @Override
    protected FramePeer createFrame(Frame f) {
        this.checkHeadless();
        GtkMainThread.createWindow();
        return new GtkFramePeer(f);
    }

    @Override
    protected LabelPeer createLabel(Label label) {
        this.checkHeadless();
        return new GtkLabelPeer(label);
    }

    @Override
    protected ListPeer createList(List list2) {
        this.checkHeadless();
        return new GtkListPeer(list2);
    }

    @Override
    protected MenuPeer createMenu(Menu m) {
        this.checkHeadless();
        return new GtkMenuPeer(m);
    }

    @Override
    protected MenuBarPeer createMenuBar(MenuBar mb) {
        this.checkHeadless();
        return new GtkMenuBarPeer(mb);
    }

    @Override
    protected MenuItemPeer createMenuItem(MenuItem mi) {
        this.checkHeadless();
        return new GtkMenuItemPeer(mi);
    }

    @Override
    protected PanelPeer createPanel(Panel p) {
        this.checkHeadless();
        return new GtkPanelPeer(p);
    }

    @Override
    protected PopupMenuPeer createPopupMenu(PopupMenu target) {
        this.checkHeadless();
        return new GtkPopupMenuPeer(target);
    }

    @Override
    protected ScrollPanePeer createScrollPane(ScrollPane sp) {
        this.checkHeadless();
        return new GtkScrollPanePeer(sp);
    }

    @Override
    protected ScrollbarPeer createScrollbar(Scrollbar sb) {
        this.checkHeadless();
        return new GtkScrollbarPeer(sb);
    }

    @Override
    protected TextAreaPeer createTextArea(TextArea ta) {
        this.checkHeadless();
        return new GtkTextAreaPeer(ta);
    }

    @Override
    protected TextFieldPeer createTextField(TextField tf) {
        this.checkHeadless();
        return new GtkTextFieldPeer(tf);
    }

    @Override
    protected WindowPeer createWindow(Window w) {
        this.checkHeadless();
        GtkMainThread.createWindow();
        return new GtkWindowPeer(w);
    }

    @Override
    public EmbeddedWindowPeer createEmbeddedWindow(EmbeddedWindow w) {
        this.checkHeadless();
        GtkMainThread.createWindow();
        return new GtkEmbeddedWindowPeer(w);
    }

    @Override
    protected FontPeer getFontPeer(String name, int style) {
        return this.getFontPeer(name, style, 12);
    }

    private FontPeer getFontPeer(String name, int style, int size) {
        HashMap attrs = new HashMap();
        ClasspathFontPeer.copyStyleToAttrs(style, attrs);
        ClasspathFontPeer.copySizeToAttrs(size, attrs);
        return this.getClasspathFontPeer(name, attrs);
    }

    @Override
    public ClasspathFontPeer getClasspathFontPeer(String name, Map<?, ?> attrs) {
        HashMap keyMap = new HashMap(attrs);
        keyMap.put("GtkToolkit.RequestedFontName", name);
        if (this.fontCache.containsKey(keyMap)) {
            return (ClasspathFontPeer)this.fontCache.get(keyMap);
        }
        GdkFontPeer newPeer = new GdkFontPeer(name, attrs);
        this.fontCache.put(keyMap, newPeer);
        return newPeer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected EventQueue getSystemEventQueueImpl() {
        Class<GtkToolkit> clazz = GtkToolkit.class;
        synchronized (GtkToolkit.class) {
            if (q == null) {
                q = new EventQueue();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return q;
        }
    }

    @Override
    public Cursor createCustomCursor(Image image, Point hotspot, String name) {
        return new GtkCursor(image, hotspot, name);
    }

    @Override
    protected native void loadSystemColors(int[] var1);

    @Override
    public DragSourceContextPeer createDragSourceContextPeer(DragGestureEvent e) {
        if (GraphicsEnvironment.isHeadless()) {
            throw new InvalidDnDOperationException();
        }
        return new GtkDragSourceContextPeer(e);
    }

    @Override
    public <T extends DragGestureRecognizer> T createDragGestureRecognizer(Class<T> recognizer, DragSource ds, Component comp, int actions, DragGestureListener l) {
        if (recognizer.getName().equals("java.awt.dnd.MouseDragGestureRecognizer") && !GraphicsEnvironment.isHeadless()) {
            GtkMouseDragGestureRecognizer gestureRecognizer = new GtkMouseDragGestureRecognizer(ds, comp, actions, l);
            gestureRecognizer.registerListeners();
            return (T)((DragGestureRecognizer)recognizer.cast(gestureRecognizer));
        }
        return null;
    }

    @Override
    public Map<TextAttribute, ?> mapInputMethodHighlight(InputMethodHighlight highlight) {
        throw new Error("not implemented");
    }

    public Rectangle getBounds() {
        int[] dims = new int[2];
        this.getScreenSizeDimensions(dims);
        return new Rectangle(0, 0, dims[0], dims[1]);
    }

    @Override
    public GraphicsEnvironment getLocalGraphicsEnvironment() {
        return new GdkGraphicsEnvironment();
    }

    @Override
    public Font createFont(int format, InputStream stream) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RobotPeer createRobot(GraphicsDevice screen) throws AWTException {
        return new GdkRobotPeer(screen);
    }

    @Override
    public boolean getLockingKeyState(int keyCode) {
        int state = this.getLockState(keyCode);
        if (state != -1) {
            return state == 1;
        }
        if (AWTUtilities.isValidKey(keyCode)) {
            throw new UnsupportedOperationException("cannot get locking state of key code " + keyCode);
        }
        throw new IllegalArgumentException("invalid key code " + keyCode);
    }

    protected native int getLockState(int var1);

    @Override
    public void registerImageIOSpis(IIORegistry reg) {
        GdkPixbufDecoder.registerSpis(reg);
    }

    @Override
    protected MouseInfoPeer getMouseInfoPeer() {
        return new GtkMouseInfoPeer();
    }

    @Override
    public boolean isFrameStateSupported(int state) {
        return state == 0 || state == 1 || state == 6;
    }

    private void checkHeadless() {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
    }

    @Override
    public native int getMouseNumberOfButtons();

    @Override
    public boolean isModalExclusionTypeSupported(Dialog.ModalExclusionType modalExclusionType) {
        return false;
    }

    @Override
    public boolean isModalityTypeSupported(Dialog.ModalityType modalityType) {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LRUCache<K, V>
    extends LinkedHashMap<K, V> {
        int max_entries;

        public LRUCache(int max) {
            super(max, 0.75f, true);
            this.max_entries = max;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > this.max_entries;
        }
    }
}

