/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer;

import gnu.java.awt.peer.ClasspathDesktopPeer;
import gnu.java.lang.CPStringBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;

public class GnomeDesktopPeer
extends ClasspathDesktopPeer {
    private static final String BROWSER_QUERY_GNOME = "gconftool-2 -g /desktop/gnome/url-handlers/http/command";

    protected String getCommand(String action) {
        Object command = super.getCommand(action);
        if (command == null) {
            try {
                command = action == "html" ? this.execQuery(BROWSER_QUERY_GNOME) : (action == "print" ? null : "gnome-open");
            }
            catch (Exception exception) {
                command = null;
            }
        }
        return command;
    }

    public void browse(URI url) throws IOException {
        this.checkPermissions();
        String browser = this.getCommand("html");
        if (browser == null) {
            throw new UnsupportedOperationException();
        }
        browser = String.valueOf(browser) + " " + url.toString();
        Runtime.getRuntime().exec(browser);
    }

    protected boolean supportCommand(String check) {
        if (check == "print") {
            return super.supportCommand(check);
        }
        return true;
    }

    public void mail() throws IOException {
        this.checkPermissions();
        String mail = this.getCommand("mail");
        if (mail == null) {
            throw new UnsupportedOperationException();
        }
        Runtime.getRuntime().exec(String.valueOf(mail) + " mailto:");
    }

    protected String execQuery(String command) throws IOException {
        InputStream in = null;
        CPStringBuilder output = new CPStringBuilder();
        try {
            int c;
            Process process = Runtime.getRuntime().exec(command);
            in = process.getInputStream();
            while ((c = in.read()) != -1) {
                output.append((char)c);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        int index = output.indexOf("%s");
        output.delete(index, index + 1);
        return output.toString().trim();
    }
}

