/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.font.opentype.truetype;

import gnu.java.awt.font.opentype.truetype.Fixed;
import gnu.java.awt.font.opentype.truetype.Zone;
import java.awt.geom.PathIterator;

final class ZonePathIterator
implements PathIterator {
    private static final int EMIT_SEGMENT = 0;
    private static final int EMIT_CLOSE = 1;
    private static final int EMIT_MOVETO = 2;
    private int state;
    private Zone zone;
    private int numPoints;
    private int curPoint;
    private int contourStart;
    private int type;
    float[] floats;

    ZonePathIterator(Zone zone, int t) {
        this.zone = zone;
        this.type = t;
        this.numPoints = zone.getSize() - 4;
        this.state = 2;
    }

    public int getWindingRule() {
        return 1;
    }

    public boolean isDone() {
        return this.state != 1 && this.curPoint >= this.numPoints;
    }

    public void next() {
        if (this.zone.isContourEnd(this.curPoint) && this.state != 1) {
            this.state = 1;
            return;
        }
        if (this.state == 1) {
            this.contourStart = ++this.curPoint;
            this.state = 2;
            return;
        }
        boolean onCurve = this.zone.isOnCurve(this.curPoint);
        if (this.state == 2 && !onCurve) {
            this.state = 0;
            return;
        }
        ++this.curPoint;
        if (!onCurve && this.zone.isOnCurve(this.curPoint)) {
            if (this.zone.isContourEnd(this.curPoint)) {
                this.state = 1;
                return;
            }
            ++this.curPoint;
        }
        this.state = 0;
    }

    private int getSuccessor(int p) {
        if (this.zone.isContourEnd(p)) {
            return this.contourStart;
        }
        return p + 1;
    }

    public int currentSegment(float[] coords) {
        switch (this.state) {
            case 1: {
                return 4;
            }
            case 2: {
                return this.getStartSegment(this.curPoint, coords);
            }
        }
        return this.getSegment(this.curPoint, coords);
    }

    public int currentSegment(double[] coords) {
        if (this.floats == null) {
            this.floats = new float[6];
        }
        int result = this.currentSegment(this.floats);
        int i = 0;
        while (i < 6) {
            coords[i] = this.floats[i];
            ++i;
        }
        return result;
    }

    private int getSegment(int cur, float[] coords) {
        int curX = this.zone.getX(cur, this.type);
        int curY = this.zone.getY(cur, this.type);
        coords[0] = Fixed.floatValue(curX);
        coords[1] = Fixed.floatValue(curY);
        if (this.zone.isOnCurve(cur)) {
            return 1;
        }
        int succ = this.getSuccessor(cur);
        int succX = this.zone.getX(succ, this.type);
        int succY = this.zone.getY(succ, this.type);
        if (this.zone.isOnCurve(succ)) {
            coords[2] = Fixed.floatValue(succX);
            coords[3] = Fixed.floatValue(succY);
        } else {
            coords[2] = Fixed.floatValue((curX + succX) / 2);
            coords[3] = Fixed.floatValue((curY + succY) / 2);
        }
        return 2;
    }

    private int getStartSegment(int contourStart, float[] coords) {
        int y;
        int x;
        if (this.zone.isOnCurve(contourStart)) {
            x = this.zone.getX(contourStart, this.type);
            y = this.zone.getY(contourStart, this.type);
        } else {
            int contourEnd = contourStart;
            while (!this.zone.isContourEnd(contourEnd)) {
                ++contourEnd;
            }
            if (this.zone.isOnCurve(contourEnd)) {
                x = this.zone.getX(contourEnd, this.type);
                y = this.zone.getY(contourEnd, this.type);
            } else {
                x = (this.zone.getX(contourStart, this.type) + this.zone.getX(contourEnd, this.type)) / 2;
                y = (this.zone.getY(contourStart, this.type) + this.zone.getY(contourEnd, this.type)) / 2;
            }
        }
        coords[0] = Fixed.floatValue(x);
        coords[1] = Fixed.floatValue(y);
        return 0;
    }
}

