/*
 * Decompiled with CFR 0.152.
 */
package gnu.gcj.xlib;

import gnu.gcj.RawData;
import gnu.gcj.xlib.Visual;

public class XImage {
    Object dataRef;
    public static final int XYBITMAP_FORMAT = 0;
    public static final int XYPIXMAP_FORMAT = 1;
    public static final int ZPIXMAP_FORMAT = 2;
    public static final int LEAST_SIGNIFICANT_B_FIRST_ORDER = 0;
    public static final int MOST_SIGNIFICANT_B_FIRST_ORDER = 1;
    boolean ownsData = false;
    RawData structure = null;

    public XImage(Visual visual, int depth, int format, int xoffset, int width, int height, int bitmapPad, int bytesPerLine) {
        this(visual, depth, format, xoffset, width, height, bitmapPad, bytesPerLine, 0);
    }

    public XImage(Visual visual, int depth, int format, int xoffset, int width, int height, int bitmapPad, int bytesPerLine, int bitsPerPixel) {
        if (visual == null) {
            throw new NullPointerException("a visual must be specified");
        }
        this.init(visual, depth, format, xoffset, width, height, bitmapPad, bytesPerLine, bitsPerPixel);
    }

    public native void init(Visual var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    private native void init(Visual var1, int var2, int var3);

    public XImage(Visual visual, int width, int height) {
        this(visual, width, height, true);
    }

    public XImage(Visual visual, int width, int height, boolean allocate) {
        if (visual == null) {
            throw new NullPointerException("a visual must be specified");
        }
        this.init(visual, width, height);
        if (allocate) {
            byte[] data = new byte[this.getBytesPerLine() * height];
            this.setData(data, 0);
        }
    }

    public void setData(byte[] data, int offset) {
        this.dataRef = data;
        this.internalSetData(data, offset);
    }

    public void setData(short[] data, int offset) {
        this.dataRef = data;
        this.internalSetData(data, offset);
    }

    public void setData(int[] data, int offset) {
        this.dataRef = data;
        this.internalSetData(data, offset);
    }

    private native void internalSetData(byte[] var1, int var2);

    private native void internalSetData(short[] var1, int var2);

    private native void internalSetData(int[] var1, int var2);

    protected native void finalize();

    public final native int getWidth();

    public final native int getHeight();

    public final native int getDepth();

    public final native int getFormat();

    public final boolean isZPixmapFormat() {
        return this.getFormat() == 2;
    }

    public final native int getXOffset();

    public final native int getBytesPerLine();

    public final native int getBitsPerPixel();

    public final native int getImageByteOrder();

    public final native int getBitmapBitOrder();

    public final native int getBitmapUnit();

    public final native int getBitmapPad();

    public native int getRedMask();

    public native int getGreenMask();

    public native int getBlueMask();

    public final native void setPixel(int var1, int var2, int var3);

    public String toString() {
        String bitmapBitOrder;
        String imageByteOrder;
        String format;
        switch (this.getFormat()) {
            case 2: {
                format = "ZPixmapFormat";
                break;
            }
            default: {
                format = "unknown";
            }
        }
        switch (this.getImageByteOrder()) {
            case 0: {
                imageByteOrder = "leastSignificantByteFirst";
                break;
            }
            case 1: {
                imageByteOrder = "mostSignificantByteFirst";
                break;
            }
            default: {
                imageByteOrder = "unknwon";
            }
        }
        switch (this.getBitmapBitOrder()) {
            case 0: {
                bitmapBitOrder = "leastSignificantBitFirst";
                break;
            }
            case 1: {
                bitmapBitOrder = "mostSignificantBitFirst";
                break;
            }
            default: {
                bitmapBitOrder = "unknown";
            }
        }
        return String.valueOf(this.getClass().getName()) + "[" + format + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ", bytesPerLine=" + this.getBytesPerLine() + ", xoffset=" + this.getXOffset() + ", depth=" + this.getDepth() + ", bitsPerPixel=" + this.getBitsPerPixel() + ", bitmapUnit=" + this.getBitmapUnit() + ", bitmapPad=" + this.getBitmapPad() + ", byteOrder=" + imageByteOrder + ", bitOrder=" + bitmapBitOrder + "]";
    }
}

