/*
 * Decompiled with CFR 0.152.
 */
package gnu.awt.xlib;

import gnu.awt.j2d.Graphics2DImpl;
import gnu.awt.j2d.IntegerGraphicsState;
import gnu.awt.xlib.XGraphics;
import gnu.awt.xlib.XGraphicsConfiguration;
import gnu.gcj.xlib.Drawable;
import gnu.gcj.xlib.GC;
import gnu.gcj.xlib.Pixmap;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.util.Hashtable;

public class XOffScreenImage
extends Image
implements IntegerGraphicsState.ScreenCoupledImage,
ImageConsumer {
    private Pixmap pixmap;
    private XGraphicsConfiguration config;
    private int width;
    private int height;
    private Drawable drawable;
    private ImageProducer prod;
    private GC gc;
    private ColorModel pixmapColorModel;

    XOffScreenImage(XGraphicsConfiguration config, Drawable drawable, int width, int height, ColorModel cm) {
        this.config = config;
        this.width = width;
        this.height = height;
        this.drawable = drawable;
        this.pixmapColorModel = cm;
        this.pixmap = new Pixmap(drawable, width, height, drawable.getDepth());
        this.gc = GC.create(this.pixmap);
    }

    XOffScreenImage(XGraphicsConfiguration config, Drawable drawable, ImageProducer prod, ColorModel cm) {
        this.config = config;
        this.width = 0;
        this.height = 0;
        this.drawable = drawable;
        this.prod = prod;
        this.pixmapColorModel = cm;
        prod.startProduction(this);
    }

    public Pixmap getPixmap() {
        return this.pixmap;
    }

    public void flush() {
        this.pixmap = null;
    }

    public Graphics getGraphics() {
        XGraphics gfxDevice = new XGraphics(this.pixmap, this.config);
        IntegerGraphicsState igState = new IntegerGraphicsState(gfxDevice);
        Graphics2DImpl gfx2d = new Graphics2DImpl(this.config);
        gfx2d.setState(igState);
        return gfx2d;
    }

    public int getHeight(ImageObserver observer) {
        return this.height;
    }

    public int getHeight() {
        return this.height;
    }

    public ImageProducer getSource() {
        if (this.prod == null) {
            throw new UnsupportedOperationException("getSource not supported");
        }
        return this.prod;
    }

    public int getWidth(ImageObserver observer) {
        return this.width;
    }

    public int getWidth() {
        return this.width;
    }

    public Object getProperty(String name, ImageObserver observer) {
        return null;
    }

    public GraphicsConfiguration getGraphicsConfiguration() {
        return this.config;
    }

    public void imageComplete(int status) {
    }

    public void setColorModel(ColorModel model) {
    }

    public void setDimensions(int width, int height) {
        this.width = width;
        this.height = height;
        this.pixmap = new Pixmap(this.drawable, width, height, this.drawable.getDepth());
        this.gc = GC.create(this.pixmap);
    }

    public void setHints(int flags) {
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int offset, int scansize) {
        float[] normalizedComponents = new float[4];
        int[] nArray = new int[4];
        nArray[3] = 255;
        int[] unnormalizedComponents = nArray;
        normalizedComponents[3] = 1.0f;
        int yp = y;
        while (yp < y + h) {
            int xp = x;
            while (xp < x + w) {
                int p = (yp - y) * scansize + (xp - x) + offset;
                normalizedComponents[0] = (float)model.getRed(pixels[p]) / 255.0f;
                normalizedComponents[1] = (float)model.getGreen(pixels[p]) / 255.0f;
                normalizedComponents[2] = (float)model.getBlue(pixels[p]) / 255.0f;
                this.pixmapColorModel.getUnnormalizedComponents(normalizedComponents, 0, unnormalizedComponents, 0);
                int pixelColor = this.pixmapColorModel.getDataElement(unnormalizedComponents, 0);
                this.gc.setForeground(pixelColor);
                this.gc.drawPoint(xp, yp);
                ++xp;
            }
            ++yp;
        }
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int offset, int scansize) {
        float[] normalizedComponents = new float[4];
        int[] nArray = new int[4];
        nArray[3] = 255;
        int[] unnormalizedComponents = nArray;
        normalizedComponents[3] = 1.0f;
        int yp = y;
        while (yp < y + h) {
            int xp = x;
            while (xp < x + w) {
                int p = (yp - y) * scansize + (xp - x) + offset;
                normalizedComponents[0] = (float)model.getRed(pixels[p]) / 255.0f;
                normalizedComponents[1] = (float)model.getGreen(pixels[p]) / 255.0f;
                normalizedComponents[2] = (float)model.getBlue(pixels[p]) / 255.0f;
                this.pixmapColorModel.getUnnormalizedComponents(normalizedComponents, 0, unnormalizedComponents, 0);
                int pixelColor = this.pixmapColorModel.getDataElement(unnormalizedComponents, 0);
                this.gc.setForeground(pixelColor);
                this.gc.drawPoint(xp, yp);
                ++xp;
            }
            ++yp;
        }
    }

    public void setProperties(Hashtable props) {
    }
}

