/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.javah;

import gnu.classpath.tools.javah.ClassWrapper;
import gnu.classpath.tools.javah.Main;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public abstract class Printer {
    protected Main classpath;
    protected File outputFileObject;
    protected boolean isDirectory;
    protected boolean force;
    protected boolean wrotePreamble;

    protected Printer(Main classpath, File outFile, boolean isDir, boolean force) {
        File parent;
        this.classpath = classpath;
        if (outFile == null) {
            throw new IllegalArgumentException("File argument MUST NOT be null");
        }
        this.outputFileObject = outFile;
        this.isDirectory = isDir;
        if (!this.isDirectory && (parent = this.outputFileObject.getParentFile()) != null) {
            parent.mkdirs();
        }
        this.force = force;
    }

    public abstract void printClass(File var1, ClassWrapper var2) throws IOException;

    protected abstract void writePreambleImpl(PrintStream var1);

    protected abstract PrintStream getPrintStreamImpl(FileOutputStream var1, ClassWrapper var2);

    protected PrintStream getPrintStream(String fullName, ClassWrapper klass) throws FileNotFoundException {
        PrintStream result;
        if (this.isDirectory) {
            File outFile = new File(this.outputFileObject, fullName);
            if (outFile.exists() && !this.force) {
                return null;
            }
            File parent = outFile.getParentFile();
            if (parent != null) {
                parent.mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(outFile);
            result = this.getPrintStreamImpl(fos, klass);
            this.writePreamble(result);
        } else {
            FileOutputStream fos = new FileOutputStream(this.outputFileObject, this.wrotePreamble);
            result = this.getPrintStreamImpl(fos, klass);
            if (!this.wrotePreamble) {
                this.writePreamble(result);
            }
        }
        return result;
    }

    protected void writePreamble(PrintStream out) {
        this.writePreambleImpl(out);
        this.wrotePreamble = true;
    }
}

