/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.native2ascii;

import gnu.classpath.tools.common.ClasspathToolParser;
import gnu.classpath.tools.getopt.FileArgumentCallback;
import gnu.classpath.tools.getopt.Option;
import gnu.classpath.tools.getopt.OptionException;
import gnu.classpath.tools.getopt.Parser;
import gnu.classpath.tools.native2ascii.Messages;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

public class Native2ASCII {
    String input;
    String output;
    String encoding;
    boolean reversed;

    private Parser createParser() {
        ClasspathToolParser result = new ClasspathToolParser("native2ascii", true);
        result.setHeader(Messages.getString("Native2ASCII.Usage"));
        result.add(new Option("encoding", Messages.getString("Native2ASCII.EncodingHelp"), Messages.getString("Native2ASCII.EncodingArgName")){

            public void parsed(String argument) throws OptionException {
                if (Native2ASCII.this.encoding != null) {
                    throw new OptionException(Messages.getString("Native2ASCII.EncodingSpecified"));
                }
                Native2ASCII.this.encoding = argument;
            }
        });
        result.add(new Option("reverse", Messages.getString("Native2ASCII.ReverseHelp")){

            public void parsed(String argument) throws OptionException {
                Native2ASCII.this.reversed = true;
            }
        });
        result.add(new Option("reversed", Messages.getString("Native2ASCII.ReversedHelpCompat")){

            public void parsed(String argument) throws OptionException {
                Native2ASCII.this.reversed = true;
            }
        });
        return result;
    }

    private void run(String[] args) {
        Parser argParser = this.createParser();
        argParser.parse(args, new HandleFile());
        if (this.encoding == null) {
            this.encoding = System.getProperty("file.encoding");
        }
        try {
            String s;
            InputStream is = this.input == null ? System.in : new FileInputStream(this.input);
            OutputStream os = this.output == null ? System.out : new FileOutputStream(this.output);
            BufferedReader rdr = new BufferedReader(new InputStreamReader(is, this.encoding));
            PrintWriter wtr = new PrintWriter(new BufferedWriter(new OutputStreamWriter(os, this.encoding)));
            while ((s = rdr.readLine()) != null) {
                StringBuilder sb = new StringBuilder(s.length() + 80);
                int i = 0;
                while (i < s.length()) {
                    char c = s.charAt(i);
                    if (this.reversed && i + 6 <= s.length() && s.charAt(i) == '\\' && s.charAt(i + 1) == 'u') {
                        int num = Integer.parseInt(s.substring(i + 2, i + 6), 16);
                        sb.append((char)num);
                        i += 5;
                    } else if (c <= '\u007f' || this.reversed) {
                        sb.append(c);
                    } else {
                        sb.append("\\u");
                        if (c <= '\u00ff') {
                            sb.append("00");
                        } else if (c <= '\u0fff') {
                            sb.append("0");
                        }
                        sb.append(Integer.toHexString(c));
                    }
                    ++i;
                }
                wtr.println(sb.toString());
            }
            rdr.close();
            wtr.flush();
            wtr.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        new Native2ASCII().run(args);
    }

    private class HandleFile
    extends FileArgumentCallback {
        public void notifyFile(String fileArgument) throws OptionException {
            if (Native2ASCII.this.input == null) {
                Native2ASCII.this.input = fileArgument;
            } else if (Native2ASCII.this.output == null) {
                Native2ASCII.this.output = fileArgument;
            } else {
                throw new OptionException(Messages.getString("Native2ASCII.TooManyFiles"));
            }
        }
    }
}

