/*
 * Decompiled with CFR 0.152.
 */
package java.lang.management;

import java.lang.management.LockInfo;
import java.lang.management.ThreadInfo;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.SimpleType;

public class MonitorInfo
extends LockInfo {
    private int stackDepth;
    private StackTraceElement stackFrame;

    public MonitorInfo(String className, int identityHashCode, int stackDepth, StackTraceElement stackFrame) {
        super(className, identityHashCode);
        if (stackFrame == null && stackDepth >= 0) {
            throw new IllegalArgumentException("The stack frame is null, but the stack depth is greater than or equal to zero.");
        }
        if (stackFrame != null && stackDepth < 0) {
            throw new IllegalArgumentException("The stack frame is not null, but the stack depth is less than zero.");
        }
        this.stackDepth = stackDepth;
        this.stackFrame = stackFrame;
    }

    public static MonitorInfo from(CompositeData data) {
        if (data == null) {
            return null;
        }
        CompositeType type = data.getCompositeType();
        ThreadInfo.checkAttribute(type, "ClassName", SimpleType.STRING);
        ThreadInfo.checkAttribute(type, "IdentityHashCode", SimpleType.INTEGER);
        ThreadInfo.checkAttribute(type, "LockedStackDepth", SimpleType.INTEGER);
        ThreadInfo.checkAttribute(type, "LockedStackFrame", ThreadInfo.getStackTraceType());
        CompositeData frame = (CompositeData)data.get("LockedStackFrame");
        return new MonitorInfo((String)data.get("ClassName"), (Integer)data.get("IdentityHashCode"), (Integer)data.get("LockedStackDepth"), new StackTraceElement((String)frame.get("ClassName"), (String)frame.get("MethodName"), (String)frame.get("FileName"), (Integer)frame.get("LineNumber")));
    }

    public int getLockedStackDepth() {
        return this.stackDepth;
    }

    public StackTraceElement getLockedStackFrame() {
        return this.stackFrame;
    }
}

