/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.naming.ictxImpl.trans;

import gnu.java.lang.CPStringBuilder;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.naming.InvalidNameException;
import javax.naming.Name;

public class GnuName
implements Name {
    private static final long serialVersionUID = -3617482732056931635L;
    int hash;
    String[] content;
    int from;
    int length;

    protected GnuName() {
    }

    public GnuName(String[] name) {
        this(name, 0, name.length);
    }

    public GnuName(String[] buffer, int useFrom, int useLength) {
        this.content = buffer;
        this.from = useFrom;
        this.length = useLength;
    }

    public Name add(int posn, String comp) throws InvalidNameException {
        String[] nc = new String[this.content.length + 1];
        System.arraycopy(this.content, this.from, nc, 0, posn);
        nc[posn] = comp;
        System.arraycopy(this.content, this.from + posn, nc, posn + 1, this.length - posn);
        this.content = nc;
        this.from = 0;
        this.length = this.content.length;
        this.hash = 0;
        return this;
    }

    public Name add(String comp) throws InvalidNameException {
        String[] nc = new String[this.content.length + 1];
        System.arraycopy(this.content, this.from, nc, 0, this.length);
        nc[nc.length - 1] = comp;
        this.content = nc;
        this.from = 0;
        this.length = this.content.length;
        this.hash = 0;
        return this;
    }

    public Name addAll(int posn, Name n) throws InvalidNameException {
        String[] nc = new String[this.length + n.size()];
        System.arraycopy(this.content, this.from, nc, 0, posn);
        int i = posn;
        int p = 0;
        while (p < n.size()) {
            nc[i] = n.get(p);
            ++i;
            ++p;
        }
        System.arraycopy(this.content, this.from + posn, nc, i, this.length - posn);
        this.length += n.size();
        this.hash = 0;
        this.content = nc;
        return this;
    }

    public Name addAll(Name suffix) throws InvalidNameException {
        String[] nc = new String[this.length + suffix.size()];
        System.arraycopy(this.content, this.from, nc, 0, this.length);
        int i = this.length;
        int p = 0;
        while (i < nc.length) {
            nc[i] = suffix.get(p);
            ++i;
            ++p;
        }
        this.length += suffix.size();
        this.hash = 0;
        this.content = nc;
        return this;
    }

    public int compareTo(Object obj) {
        Name n = (Name)obj;
        int l = Math.min(this.length, n.size());
        int i = 0;
        while (i < l) {
            int c = this.content[this.from + i].compareTo(n.get(i));
            if (c != 0) {
                return c;
            }
            ++i;
        }
        return this.length - n.size();
    }

    public boolean endsWith(Name n) {
        if (n.size() > this.length) {
            return false;
        }
        int ofs = this.length - n.size() + this.from;
        int i = 0;
        while (i < n.size()) {
            if (!this.content[ofs].equals(n.get(i))) {
                return false;
            }
            ++i;
            ++ofs;
        }
        return true;
    }

    public String get(int posn) {
        return this.content[this.from + posn];
    }

    public Enumeration getAll() {
        return new GnuNameEnum(0);
    }

    public Name getPrefix(int posn) {
        return new GnuName(this.content, this.from, posn);
    }

    public Name getSuffix(int posn) {
        return new GnuName(this.content, this.from + posn, this.length - posn);
    }

    public boolean isEmpty() {
        return this.length == 0;
    }

    public Object remove(int posn) throws InvalidNameException {
        if (this.length == 0) {
            throw new InvalidNameException("negative size");
        }
        --this.length;
        if (posn == 0) {
            ++this.from;
        } else if (posn < this.length) {
            String[] nc = new String[this.length];
            System.arraycopy(this.content, this.from, nc, 0, posn);
            System.arraycopy(this.content, this.from + posn + 1, nc, posn, this.length - posn);
            this.content = nc;
            this.from = 0;
        }
        this.hash = 0;
        return this;
    }

    public int size() {
        return this.length;
    }

    public boolean startsWith(Name n) {
        if (n.size() > this.length) {
            return false;
        }
        int i = 0;
        while (i < n.size()) {
            if (!this.content[this.from + i].equals(n.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Object clone() {
        return new GnuName(this.content, this.from, this.length);
    }

    public boolean equals(Object arg0) {
        if (this == arg0) {
            return true;
        }
        if (arg0 instanceof Name) {
            Name n = (Name)arg0;
            if (this.length != n.size()) {
                return false;
            }
            int i = 0;
            while (i < this.length) {
                if (!this.content[this.from + i].equals(n.get(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        if (this.hash == 0 && this.length > 0) {
            int s = 0;
            int i = this.from;
            while (i < this.from + this.length) {
                s ^= this.content[i].hashCode();
                ++i;
            }
            this.hash = s;
        }
        return this.hash;
    }

    public String toString() {
        CPStringBuilder b = new CPStringBuilder();
        int i = 0;
        while (i < this.length) {
            b.append(this.get(i));
            if (i < this.length - 1) {
                b.append('/');
            }
            ++i;
        }
        return b.toString();
    }

    class GnuNameEnum
    implements Enumeration {
        int nxt;

        GnuNameEnum(int position) {
            this.nxt = GnuName.this.from + position;
        }

        public boolean hasMoreElements() {
            return this.nxt >= 0;
        }

        public Object nextElement() {
            if (this.nxt < 0) {
                throw new NoSuchElementException();
            }
            String r = GnuName.this.content[this.nxt++];
            if (this.nxt - GnuName.this.from == GnuName.this.length) {
                this.nxt = -1;
            }
            return r;
        }
    }
}

