/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.processor;

import gnu.classpath.jdwp.exception.JdwpException;
import gnu.classpath.jdwp.exception.JdwpInternalErrorException;
import gnu.classpath.jdwp.exception.NotImplementedException;
import gnu.classpath.jdwp.id.ObjectId;
import gnu.classpath.jdwp.id.ReferenceTypeId;
import gnu.classpath.jdwp.processor.CommandSet;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ClassObjectReferenceCommandSet
extends CommandSet {
    public boolean runCommand(ByteBuffer bb, DataOutputStream os, byte command) throws JdwpException {
        try {
            switch (command) {
                case 1: {
                    this.executeReflectedType(bb, os);
                    break;
                }
                default: {
                    throw new NotImplementedException("Command " + command + " not found in ClassObject Reference Command Set.");
                }
            }
        }
        catch (IOException ex) {
            throw new JdwpInternalErrorException(ex);
        }
        return false;
    }

    public void executeReflectedType(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        ObjectId oid = this.idMan.readObjectId(bb);
        Class clazz = (Class)oid.getObject();
        ReferenceTypeId refId = this.idMan.getReferenceTypeId(clazz);
        refId.writeTagged(os);
    }
}

