/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.validation.datatype;

import gnu.xml.validation.datatype.AtomicSimpleType;
import gnu.xml.validation.datatype.TypeLibrary;
import javax.xml.namespace.QName;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

final class DurationType
extends AtomicSimpleType {
    static final int[] CONSTRAINING_FACETS = new int[]{4, 5, 6, 7, 8, 10, 9};

    DurationType() {
        super(new QName("http://www.w3.org/2001/XMLSchema", "duration"), TypeLibrary.ANY_SIMPLE_TYPE);
    }

    public int[] getConstrainingFacets() {
        return CONSTRAINING_FACETS;
    }

    public void checkValid(String value, ValidationContext context) throws DatatypeException {
        super.checkValid(value, context);
        int len = value.length();
        int expect = 80;
        boolean seenT = false;
        int i = 0;
        while (i < len) {
            int c = value.charAt(i);
            if (c != 45 || expect != 80) {
                if (c == expect) {
                    if (c == 80) {
                        expect = 89;
                    } else if (c == 89) {
                        expect = 77;
                    } else if (c == 77 && !seenT) {
                        expect = 68;
                    } else if (c == 68) {
                        expect = 84;
                    } else if (c == 84) {
                        expect = 72;
                        seenT = true;
                    } else if (c == 72) {
                        expect = 77;
                    } else if (c == 77 && seenT) {
                        expect = 83;
                    } else if (c == 83 && i + 1 != len) {
                        throw new DatatypeException(i, "illegal duration value");
                    }
                } else if (c < 48 || c > 57 || expect == 80 || expect == 84) {
                    throw new DatatypeException(i, "illegal duration value");
                }
            }
            ++i;
        }
    }

    public Object createValue(String value, ValidationContext context) {
        boolean negative = false;
        int days = 0;
        int minutes = 0;
        float seconds = 0.0f;
        int len = value.length();
        int expect = 80;
        boolean seenT = false;
        int start = 0;
        int i = 0;
        while (i < len) {
            int c = value.charAt(i);
            if (c == 45 && expect == 80) {
                negative = true;
            } else if (c == expect) {
                if (c == 80) {
                    expect = 89;
                } else if (c == 89) {
                    expect = 77;
                    Integer.parseInt(value.substring(start, i));
                } else if (c == 77 && !seenT) {
                    expect = 68;
                } else if (c == 68) {
                    expect = 84;
                } else if (c == 84) {
                    expect = 72;
                    seenT = true;
                } else if (c == 72) {
                    expect = 77;
                } else if (c == 77 && seenT) {
                    expect = 83;
                } else if (c == 83 && i + 1 != len) {
                    return null;
                }
                start = i + 1;
            } else if (c < 48 || c > 57 || expect == 80 || expect == 84) {
                return null;
            }
            ++i;
        }
        if (negative) {
            days *= -1;
            minutes *= -1;
            seconds *= -1.0f;
        }
        Duration duration = new Duration();
        duration.days = days;
        duration.minutes = minutes;
        duration.seconds = seconds;
        return duration;
    }

    static class Duration
    implements Comparable {
        int years;
        int months;
        int days;
        int minutes;
        float seconds;

        Duration() {
        }

        public int hashCode() {
            int hc = this.years;
            hc = hc * 31 + this.months;
            hc = hc * 31 + this.days;
            hc = hc * 31 + this.minutes;
            hc = hc * 31 + new Float(this.seconds).hashCode();
            return hc;
        }

        public boolean equals(Object other) {
            if (other instanceof Duration) {
                Duration duration = (Duration)other;
                return duration.years == this.years && duration.months == this.months && duration.days == this.days && duration.minutes == this.minutes && duration.seconds == this.seconds;
            }
            return false;
        }

        public int compareTo(Object other) {
            if (other instanceof Duration) {
                Duration duration = (Duration)other;
                if (duration.years != this.years) {
                    return this.years - duration.years;
                }
                if (duration.months != this.months) {
                    return this.months - duration.months;
                }
                if (duration.days != this.days) {
                    return this.days - duration.days;
                }
                if (duration.minutes != this.minutes) {
                    this.minutes = duration.minutes;
                    return this.minutes;
                }
                if (duration.seconds == this.seconds) {
                    return 0;
                }
                return this.seconds < duration.seconds ? -1 : 1;
            }
            return 0;
        }
    }
}

