/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.util.regex;

import gnu.java.util.regex.BacktrackStack;
import gnu.java.util.regex.CharIndexed;
import gnu.java.util.regex.REMatch;
import gnu.java.util.regex.REToken;
import java.util.ArrayList;

final class RETokenRepeated
extends REToken {
    private REToken token;
    private int min;
    private int max;
    private boolean stingy;
    private boolean possessive;
    private int tokenFixedLength;

    RETokenRepeated(int subIndex, REToken token, int min, int max) {
        super(subIndex);
        this.token = token;
        this.min = min;
        this.max = max;
        this.tokenFixedLength = token.returnsFixedLengthMatches() ? token.getMaximumLength() : -1;
    }

    void makeStingy() {
        this.stingy = true;
    }

    boolean isStingy() {
        return this.stingy;
    }

    void makePossessive() {
        this.possessive = true;
    }

    boolean isPossessive() {
        return this.possessive;
    }

    int getMinimumLength() {
        return this.min * this.token.getMinimumLength();
    }

    int getMaximumLength() {
        if (this.max == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        int tmax = this.token.getMaximumLength();
        if (tmax == Integer.MAX_VALUE) {
            return tmax;
        }
        return this.max * tmax;
    }

    REMatch findMatch(CharIndexed input, REMatch mymatch) {
        if (this.tokenFixedLength >= 0) {
            return this.findMatchFixedLength(input, mymatch);
        }
        BacktrackStack stack = new BacktrackStack();
        stack.push(new StackedInfo(input, 0, mymatch, null, null));
        return this.findMatch(stack);
    }

    REMatch backtrack(CharIndexed input, REMatch mymatch, Object param) {
        if (this.tokenFixedLength >= 0) {
            return this.backtrackFixedLength(input, mymatch, param);
        }
        return this.findMatch((BacktrackStack)param);
    }

    private REMatch findMatch(BacktrackStack stack) {
        return this.findMatch(stack, new FindMatchControlStack());
    }

    private REMatch findMatch(BacktrackStack stack, FindMatchControlStack controlStack) {
        REMatch result = null;
        StackedInfo si = null;
        CharIndexed input = null;
        int numRepeats = 0;
        REMatch mymatch = null;
        int[] visited = null;
        DoablesFinder finder = null;
        block8: while (true) {
            if (!stack.empty()) {
                si = (StackedInfo)stack.peek();
                input = si.input;
                numRepeats = si.numRepeats;
                mymatch = si.match;
                visited = si.visited;
                finder = si.finder;
                if (mymatch.backtrackStack == null) {
                    mymatch.backtrackStack = new BacktrackStack();
                }
                if (numRepeats >= this.max) {
                    stack.pop();
                    REMatch m1 = this.matchRest(input, mymatch);
                    if (m1 != null) {
                        if (!stack.empty()) {
                            m1.backtrackStack.push(new BacktrackStack.Backtrack(this, input, mymatch, stack));
                        }
                        result = m1;
                    } else if (this.stingy) {
                        continue;
                    }
                } else {
                    if (finder == null) {
                        si.finder = finder = new DoablesFinder(this.token, input, mymatch);
                    }
                    if (numRepeats < this.min) {
                        REMatch doable = finder.find();
                        if (doable == null) {
                            if (stack.empty()) {
                                return null;
                            }
                            stack.pop();
                            continue;
                        }
                        if (finder.noMore()) {
                            stack.pop();
                        }
                        int newNumRepeats = doable.empty ? this.min : numRepeats + 1;
                        stack.push(new StackedInfo(input, newNumRepeats, doable, visited, null));
                        continue;
                    }
                    if (visited == null) {
                        visited = RETokenRepeated.initVisited();
                    }
                    if (this.stingy) {
                        REMatch m1;
                        REMatch nextMatch = finder.find();
                        if (nextMatch != null && !nextMatch.empty) {
                            stack.push(new StackedInfo(input, numRepeats + 1, nextMatch, visited, null));
                        } else {
                            stack.pop();
                        }
                        if ((m1 = this.matchRest(input, mymatch)) == null) continue;
                        if (!stack.empty()) {
                            m1.backtrackStack.push(new BacktrackStack.Backtrack(this, input, mymatch, stack));
                        }
                        result = m1;
                    } else {
                        visited = RETokenRepeated.addVisited(mymatch.index, visited);
                        TryAnotherResult taresult = this.tryAnother(stack, input, mymatch, numRepeats, finder, visited);
                        visited = taresult.visited;
                        switch (taresult.status) {
                            case 2: {
                                controlStack.push(new FindMatchControl(finder));
                                continue block8;
                            }
                            case 1: {
                                result = taresult.result;
                                break;
                            }
                            default: {
                                REMatch m1;
                                if (!stack.empty()) {
                                    stack.pop();
                                }
                                if (this.possessive) {
                                    stack.clear();
                                }
                                if ((m1 = this.matchRest(input, mymatch)) == null) continue block8;
                                if (!stack.empty()) {
                                    m1.backtrackStack.push(new BacktrackStack.Backtrack(this, input, mymatch, stack));
                                }
                                result = m1;
                            }
                        }
                    }
                }
            }
            if (controlStack.empty()) {
                return result;
            }
            FindMatchControl control = controlStack.pop();
            if (this.possessive) {
                return result;
            }
            if (result != null) {
                result.backtrackStack.push(new BacktrackStack.Backtrack(this, input, mymatch, stack));
                return result;
            }
            finder = control.finder;
            TryAnotherResult taresult = this.tryAnother(stack, input, mymatch, numRepeats, finder, visited);
            visited = taresult.visited;
            switch (taresult.status) {
                case 2: {
                    controlStack.push(new FindMatchControl(finder));
                    continue block8;
                }
                case 1: {
                    return taresult.result;
                }
            }
        }
    }

    private TryAnotherResult tryAnother(BacktrackStack stack, CharIndexed input, REMatch mymatch, int numRepeats, DoablesFinder finder, int[] visited) {
        REMatch doable;
        TryAnotherResult taresult = new TryAnotherResult();
        taresult.visited = visited;
        boolean emptyMatchFound = false;
        while ((doable = finder.find()) != null) {
            if (doable.empty) {
                emptyMatchFound = true;
            }
            if (!emptyMatchFound) {
                int n = doable.index;
                if (RETokenRepeated.visitedContains(n, visited)) continue;
                visited = RETokenRepeated.addVisited(n, visited);
                stack.push(new StackedInfo(input, numRepeats + 1, doable, visited, null));
                taresult.visited = visited;
                taresult.status = 2;
                return taresult;
            }
            REMatch m1 = this.matchRest(input, doable);
            if (this.possessive) {
                taresult.result = m1;
                taresult.status = 1;
                return taresult;
            }
            if (m1 == null) continue;
            if (!stack.empty()) {
                m1.backtrackStack.push(new BacktrackStack.Backtrack(this, input, mymatch, stack));
            }
            taresult.result = m1;
            taresult.status = 1;
            return taresult;
        }
        taresult.status = 3;
        return taresult;
    }

    boolean match(CharIndexed input, REMatch mymatch) {
        this.setHitEnd(input, mymatch);
        REMatch m1 = this.findMatch(input, mymatch);
        if (m1 != null) {
            mymatch.assignFrom(m1);
            return true;
        }
        return false;
    }

    private static int[] initVisited() {
        int[] visited = new int[32];
        visited[0] = 0;
        return visited;
    }

    private static boolean visitedContains(int n, int[] visited) {
        int i = 1;
        while (i < visited[0]) {
            if (n == visited[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static int[] addVisited(int n, int[] visited) {
        if (RETokenRepeated.visitedContains(n, visited)) {
            return visited;
        }
        if (visited[0] >= visited.length - 1) {
            int[] newvisited = new int[visited.length + 32];
            System.arraycopy(visited, 0, newvisited, 0, visited.length);
            visited = newvisited;
        }
        visited[0] = visited[0] + 1;
        visited[visited[0]] = n;
        return visited;
    }

    private REMatch matchRest(CharIndexed input, REMatch newMatch) {
        if (this.next(input, newMatch)) {
            return newMatch;
        }
        return null;
    }

    private REMatch findMatchFixedLength(CharIndexed input, REMatch mymatch) {
        int count;
        int numRepeats;
        if (mymatch.backtrackStack == null) {
            mymatch.backtrackStack = new BacktrackStack();
        }
        if ((numRepeats = this.token.findFixedLengthMatches(input, (REMatch)mymatch.clone(), this.max)) == Integer.MAX_VALUE) {
            numRepeats = this.min;
        }
        if ((count = numRepeats - this.min + 1) <= 0) {
            return null;
        }
        int index = 0;
        index = !this.stingy ? mymatch.index + this.tokenFixedLength * numRepeats : mymatch.index + this.tokenFixedLength * this.min;
        return this.findMatchFixedLength(input, mymatch, index, count);
    }

    private REMatch backtrackFixedLength(CharIndexed input, REMatch mymatch, Object param) {
        int[] params = (int[])param;
        int index = params[0];
        int count = params[1];
        return this.findMatchFixedLength(input, mymatch, index, count);
    }

    private REMatch findMatchFixedLength(CharIndexed input, REMatch mymatch, int index, int count) {
        REMatch tryMatch = (REMatch)mymatch.clone();
        do {
            tryMatch.index = index;
            REMatch m = this.matchRest(input, tryMatch);
            --count;
            index = this.stingy ? (index += this.tokenFixedLength) : (index -= this.tokenFixedLength);
            if (this.possessive) {
                return m;
            }
            if (m == null) continue;
            if (count > 0) {
                m.backtrackStack.push(new BacktrackStack.Backtrack(this, input, mymatch, new int[]{index, count}));
            }
            return m;
        } while (count > 0);
        return null;
    }

    void dump(StringBuffer os) {
        os.append("(?:");
        this.token.dumpAll(os);
        os.append(')');
        if (this.max == Integer.MAX_VALUE && this.min <= 1) {
            os.append(this.min == 0 ? (char)'*' : '+');
        } else if (this.min == 0 && this.max == 1) {
            os.append('?');
        } else {
            os.append('{').append(this.min);
            if (this.max > this.min) {
                os.append(',');
                if (this.max != Integer.MAX_VALUE) {
                    os.append(this.max);
                }
            }
            os.append('}');
        }
        if (this.stingy) {
            os.append('?');
        }
    }

    private static class DoablesFinder {
        private REToken tk;
        private CharIndexed input;
        private REMatch rematch;
        private boolean findFirst;

        private DoablesFinder(REToken tk, CharIndexed input, REMatch mymatch) {
            this.tk = tk;
            this.input = input;
            this.rematch = (REMatch)mymatch.clone();
            this.rematch.backtrackStack = new BacktrackStack();
            this.findFirst = true;
        }

        private REMatch find() {
            REMatch rem;
            int origin = this.rematch.index;
            if (this.findFirst) {
                rem = this.tk.findMatch(this.input, this.rematch);
                this.findFirst = false;
            } else {
                BacktrackStack.Backtrack bt;
                do {
                    if (this.rematch.backtrackStack.empty()) {
                        rem = null;
                        break;
                    }
                    bt = this.rematch.backtrackStack.pop();
                } while ((rem = bt.token.backtrack(bt.input, bt.match, bt.param)) == null);
            }
            if (rem == null) {
                return null;
            }
            if (rem.index == origin) {
                rem.empty = true;
            }
            this.rematch = rem;
            return (REMatch)rem.clone();
        }

        boolean noMore() {
            return this.rematch.backtrackStack.empty();
        }
    }

    private static class FindMatchControl {
        DoablesFinder finder;

        FindMatchControl(DoablesFinder finder) {
            this.finder = finder;
        }
    }

    private static class FindMatchControlStack
    extends ArrayList {
        private FindMatchControlStack() {
        }

        private void push(FindMatchControl control) {
            this.add(control);
        }

        private FindMatchControl pop() {
            return (FindMatchControl)this.remove(this.size() - 1);
        }

        private boolean empty() {
            return this.isEmpty();
        }
    }

    private static class StackedInfo
    extends BacktrackStack.Backtrack {
        int numRepeats;
        int[] visited;
        DoablesFinder finder;

        StackedInfo(CharIndexed input, int numRepeats, REMatch match, int[] visited, DoablesFinder finder) {
            super(null, input, match, null);
            this.numRepeats = numRepeats;
            this.visited = visited;
            this.finder = finder;
        }
    }

    private static class TryAnotherResult {
        REMatch result;
        int status;
        static final int RESULT_FOUND = 1;
        static final int TRY_FURTHER = 2;
        static final int NOTHING_FOUND = 3;
        int[] visited;

        private TryAnotherResult() {
        }
    }
}

