/*
 * Decompiled with CFR 0.152.
 */
package gnu.CORBA.Interceptor;

import gnu.CORBA.ObjectCreator;
import gnu.CORBA.Poa.ORB_1_4;
import gnu.CORBA.gnuCodecFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.Object;
import org.omg.IOP.CodecFactory;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.IORInterceptor;
import org.omg.PortableInterceptor.Interceptor;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;
import org.omg.PortableInterceptor.ORBInitInfoPackage.InvalidName;
import org.omg.PortableInterceptor.ORBInitializer;
import org.omg.PortableInterceptor.ORBInitializerOperations;
import org.omg.PortableInterceptor.PolicyFactory;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

public class Registrator
extends LocalObject
implements ORBInitInfo {
    private static final long serialVersionUID = 1L;
    public static final String m_prefix = "org.omg.PortableInterceptor.ORBInitializerClass.";
    private ArrayList m_server = new ArrayList();
    private ArrayList m_client = new ArrayList();
    private ArrayList m_ior = new ArrayList();
    public Hashtable m_policyFactories = new Hashtable();
    public TreeMap m_references = new TreeMap();
    public ArrayList m_initializers = new ArrayList();
    final ORB_1_4 orb;
    final String[] m_args;
    final gnuCodecFactory m_codecFactory;

    public Registrator(ORB_1_4 an_orb, Properties props, String[] an_args) {
        this.orb = an_orb;
        this.m_args = an_args;
        this.m_codecFactory = new gnuCodecFactory(this.orb);
        this.checkProperties(props);
        this.checkProperties(System.getProperties());
        this.checkFile("user.home", null);
        this.checkFile("java.home", "lib");
    }

    private void checkProperties(Properties props) {
        if (props == null) {
            return;
        }
        Enumeration<?> names = props.propertyNames();
        while (names.hasMoreElements()) {
            String sk;
            java.lang.Object key = names.nextElement();
            if (key == null || !(sk = key.toString()).startsWith(m_prefix)) continue;
            try {
                String cn = sk.substring(m_prefix.length());
                Class iClass = ObjectCreator.forName(cn);
                ORBInitializer initializer = (ORBInitializer)iClass.newInstance();
                this.m_initializers.add(initializer);
            }
            catch (Exception exception) {
                System.err.println(String.valueOf(sk) + " failed");
            }
        }
    }

    private void checkFile(String dir, String subdir) {
        try {
            File f = new File(dir);
            if (!f.exists()) {
                return;
            }
            if (subdir != null) {
                f = new File(f, subdir);
            }
            if (!(f = new File(f, "orb.properties")).exists()) {
                return;
            }
            Properties p = new Properties();
            p.load(new BufferedInputStream(new FileInputStream(f)));
            this.checkProperties(p);
        }
        catch (IOException iOException) {}
    }

    public void pre_init() {
        for (ORBInitializerOperations initializer : this.m_initializers) {
            initializer.pre_init(this);
        }
    }

    public Map getRegisteredReferences() {
        return this.m_references;
    }

    public void post_init() {
        for (ORBInitializerOperations initializer : this.m_initializers) {
            initializer.post_init(this);
        }
    }

    public ServerRequestInterceptor[] getServerRequestInterceptors() {
        ServerRequestInterceptor[] iServer = new ServerRequestInterceptor[this.m_server.size()];
        int i = 0;
        while (i < iServer.length) {
            iServer[i] = (ServerRequestInterceptor)this.m_server.get(i);
            ++i;
        }
        return iServer;
    }

    public ClientRequestInterceptor[] getClientRequestInterceptors() {
        ClientRequestInterceptor[] iClient = new ClientRequestInterceptor[this.m_client.size()];
        int i = 0;
        while (i < iClient.length) {
            iClient[i] = (ClientRequestInterceptor)this.m_client.get(i);
            ++i;
        }
        return iClient;
    }

    public IORInterceptor[] getIORInterceptors() {
        IORInterceptor[] iIor = new IORInterceptor[this.m_ior.size()];
        int i = 0;
        while (i < iIor.length) {
            iIor[i] = (IORInterceptor)this.m_ior.get(i);
            ++i;
        }
        return iIor;
    }

    public void add_client_request_interceptor(ClientRequestInterceptor interceptor) throws DuplicateName {
        this.add(this.m_client, interceptor);
    }

    public void add_ior_interceptor(IORInterceptor interceptor) throws DuplicateName {
        this.add(this.m_ior, interceptor);
    }

    public void add_server_request_interceptor(ServerRequestInterceptor interceptor) throws DuplicateName {
        this.add(this.m_server, interceptor);
    }

    public int allocate_slot_id() {
        return this.orb.icSlotSize++;
    }

    private void add(ArrayList list2, Interceptor interceptor) throws DuplicateName {
        if (interceptor.name().length() > 0) {
            for (Interceptor ic : list2) {
                if (!ic.name().equals(interceptor.name())) continue;
                throw new DuplicateName(interceptor.name());
            }
        }
        list2.add(interceptor);
    }

    public String[] arguments() {
        return this.m_args;
    }

    public CodecFactory codec_factory() {
        return this.m_codecFactory;
    }

    public String orb_id() {
        return "orb_" + this.orb;
    }

    public void register_initial_reference(String object_name, Object object) throws InvalidName {
        if (object_name == null) {
            throw new InvalidName("null");
        }
        if (object_name.length() == 0) {
            throw new InvalidName("Empty string");
        }
        if (this.m_references.containsKey(object_name)) {
            throw new InvalidName(object_name);
        }
        this.m_references.put(object_name, object);
    }

    public void register_policy_factory(int policy_type, PolicyFactory policy_factory) {
        Integer it = new Integer(policy_type);
        if (this.m_policyFactories.containsKey(it)) {
            throw new BAD_INV_ORDER("Repetetive registration of the policy factory for type " + policy_type, 16, CompletionStatus.COMPLETED_NO);
        }
        this.m_policyFactories.put(it, policy_factory);
    }

    public Object resolve_initial_references(String object_name) throws InvalidName {
        try {
            return this.orb.resolve_initial_references(object_name);
        }
        catch (org.omg.CORBA.ORBPackage.InvalidName e) {
            InvalidName in = new InvalidName(e.getMessage());
            in.initCause(e);
            throw in;
        }
    }

    public boolean hasClientRequestInterceptors() {
        return this.m_client.size() > 0;
    }

    public boolean hasServerRequestInterceptors() {
        return this.m_server.size() > 0;
    }

    public boolean hasIorInterceptors() {
        return this.m_ior.size() > 0;
    }
}

