function __fish_g_no_subcommand
    return (commandline -opc)[1] = 'g'
end

complete -c g -l bug -d "report bug"
complete -c g -l duplicate -d "show duplicate files" -a "(__fish_complete_path)"
complete -c g -l no-config -d "do not load config file"
complete -c g -l no-path-transform -d "disable path transformation"
complete -c g -l help -s h -s \? -d "show help"
complete -c g -l version -s v -d "print the version"
complete -c g -s '#' -d "print entry number for each entry"
complete -c g -l csv -d "output in csv format"
complete -c g -l tsv -d "output in tsv format"
complete -c g -l byline -s 1 -d "print by line"
complete -c g -l classic -d "enable classic mode"
complete -c g -l color -d "set terminal color mode" -a "always auto never basic 256 24bit"
complete -c g -l colorless -d "without color"
complete -c g -l depth -d "limit recursive/tree depth" -r -f
complete -c g -l format -d "set output format" -a "across commas horizontal long single-column verbose vertical table markdown csv tsv json tree"
complete -c g -l flags -d "list file flags" -r -f
complete -c g -l file-type -d "do not append indicator to file types"
complete -c g -l md -d "output in markdown-table format"
complete -c g -l markdown -d "output in markdown-table format"
complete -c g -l table -d "output in table format"
complete -c g -l table-style -d "set table style" -a "ascii unicode"
complete -c g -l term-width -d "set screen width" -r -f
complete -c g -l theme -d "apply theme" -a "(__fish_complete_path)"
complete -c g -l tree-style -d "set tree style" -a "ascii unicode rectangle"
complete -c g -l zero -s 0 -d "end each output line with NUL"
complete -c g -s C -d "list entries by columns"
complete -c g -s F -d "append indicator to entries"
complete -c g -s R -d "recurse into directories"
complete -c g -s T -d "recursively list in tree"
complete -c g -s d -d "list directories themselves"
complete -c g -s j -d "output in json format"
complete -c g -s m -d "fill width with a comma separated list"
complete -c g -s x -d "list entries by lines"
complete -c g -l init -d "show the init script for shell" -a "zsh bash fish powershell nushell"
complete -c g -l sort -d "sort by field" -a "nature none name Name size Size time Time owner Owner group Group extension Extension inode Inode width Width mime Mime"
complete -c g -l dir-first -d "list directories before files"
complete -c g -l group-directories-first -d "list directories before files"
complete -c g -l reverse -s r -d "reverse the order of the sort"
complete -c g -l versionsort -d "sort by version numbers"
complete -c g -s S -d "sort by file size"
complete -c g -l si -d "use powers of 1000 not 1024 for size format"
complete -c g -l sizesort -d "sort by file size"
complete -c g -s U -l no-sort -d "do not sort"
complete -c g -s X -l sort-by-ext -d "sort alphabetically by entry extension"
complete -c g -l accessed -d "accessed time"
complete -c g -l all -d "show all info/use a long listing format"
complete -c g -l birth -d "birth time"
complete -c g -l blocks -d "show block size"
complete -c g -l charset -d "show charset of text file"
complete -c g -l checksum -d "show checksum of file"
complete -c g -l checksum-algorithm -d "checksum algorithm" -a "md5 sha1 sha224 sha256 sha384 sha512 crc32"
complete -c g -l created -d "created time"
complete -c g -l dereference -d "dereference symbolic links"
complete -c g -l footer -d "add a footer row"
complete -c g -l full-path -d "show full path"
complete -c g -l full-time -d "like -all/l --time-style=full-iso" -a "default iso long-iso full-iso +FORMAT"
complete -c g -l gid -d "show gid instead of groupname"
complete -c g -l git -l git-status -d "show git status"
complete -c g -l git-repo-branch -l branch -d "list root of git-tree branch"
complete -c g -l git-repo-status -l repo-status -d "list root of git-tree status"
complete -c g -l group -d "show group"
complete -c g -l header -l title -d "add a header row"
complete -c g -l hyperlink -d "attach hyperlink to filenames" -a "auto always never"
complete -c g -l icon -d "show icon"
complete -c g -l inode -s i -d "show inode"
complete -c g -l mime -d "show mime file type"
complete -c g -l mime-parent -d "show mime parent type"
complete -c g -l modified -d "modified time"
complete -c g -l mounts -d "show mount details"
complete -c g -l no-dereference -d "do not follow symbolic links"
complete -c g -l no-icon -d "disable icon"
complete -c g -l no-total-size -d "disable total size"
complete -c g -l numeric -l numeric-uid-gid -d "show numeric user and group IDs"
complete -c g -l octal-perm -d "list permission in octal format"
complete -c g -l owner -d "show owner"
complete -c g -l perm -d "show permission"
complete -c g -l recursive-size -d "show recursive size of dir"
complete -c g -l relative-to -d "show relative path" -a "(__fish_complete_path)"
complete -c g -l relative-time -d "show relative time"
complete -c g -l size -d "show file/dir size"
complete -c g -l size-unit -l block-size -d "set size unit" -a "bit \"bit\" b \"byte\" k m g t p e z y bb nb auto"
complete -c g -l smart-group -d "only show group if different from owner"
complete -c g -l statistic -d "show statistic info"
complete -c g -l stdin -d "read path from stdin, split by newline"
complete -c g -l time -d "show time"
complete -c g -l time-style -d "set time/date format" -r -f
complete -c g -l time-type -d "set time type" -a "mod \"modified\" create access all birth"
complete -c g -l total-size -d "show total size"
complete -c g -l uid -d "show uid instead of username"
complete -c g -s G -l no-group -d "do not print group names in a long listing"
complete -c g -s H -l link -d "list number of hard links for each file"
complete -c g -s N -l literal -d "print entry names without quoting"
complete -c g -s O -l no-owner -d "do not print owner names in a long listing"
complete -c g -s Q -l quote-name -d "enclose entry names in double quotes"
complete -c g -s g -d "like -all, but do not list owner"
complete -c g -s l -l long -d "use a long listing format"
complete -c g -s o -d "like -all, but do not list group information"
complete -c g -f -a "(__fish_complete_path)"
