/**
 * SECTION:individual-aggregator
 * @short_description: Stores <link linkend="FolksIndividual"><type>FolksIndividual</type></link>s which have been created through aggregation of all the <link linkend="FolksPersona"><type>FolksPersona</type></link>s provided by the various <link linkend="FolksBackend"><type>FolksBackend</type></link>s.
 * 
 * <para>This is the main interface for client applications.</para><para>Linking and unlinking of personas and individuals is performed entirely through the aggregator. Personas may be linked together to form individuals; for example, the personas which form <code>individual1</code> and <code>individual2</code> may be linked together with <code>another_persona</code> to give a new <link linkend="FolksIndividual"><type>FolksIndividual</type></link>:</para><para>
 * |[
 *   var personas = new HashSet&lt;Persona&gt; ();
 *   personas.add_all (individual1.personas);
 *   personas.add_all (individual2.personas);
 *   personas.add (another_persona);
 *   yield my_individual_aggregator.link_personas (personas);
 * ]|
 * </para><para>The individuals which contained those personas will be removed when <link linkend="folks-individual-aggregator-link-personas"><function>folks_individual_aggregator_link_personas()</function></link> is called. Any personas in those individuals which were not included in the linking call may end up implicitly linked to the new individual, or may be aggregated into other new individuals.</para><para>For example, consider the situation where <code>individual1</code> contains two personas, <code>persona1A</code> and <code>persona1B</code>; <code>individual2</code> contains one persona, <code>persona2A</code>; and <code>another_persona</code> comes from <code>individual3</code>, which also contains <code>persona3A</code> and <code>persona3B</code>. Calling <link linkend="folks-individual-aggregator-link-personas"><function>folks_individual_aggregator_link_personas()</function></link> on <code>persona1A</code>, <code>persona1B</code>, <code>persona2A</code> and <code>another_persona</code> will result in <code>individual1</code> and <code>individual2</code> being removed. A new <link linkend="FolksIndividual"><type>FolksIndividual</type></link> will be created containing all the personas passed to the linking function. It might also contain <code>persona3A</code> and <code>persona3B</code>; or they might be in one or two other new individuals.</para><para>An existing individual may be unlinked to form singleton individuals for each of its personas: 
 * |[
 *   yield my_individual_aggregator.unlink_individual (my_individual);
 * ]|
 * </para><para>Note that to link two individuals together, their two sets of personas must be linked together. There is no API to directly link the individuals themselves, as conceptually folks links <link linkend="FolksPersona"><type>FolksPersona</type></link>s, not <link linkend="FolksIndividual"><type>FolksIndividual</type></link>s.</para><para>Folks does not support having more than one IndividualAggregator instantiated at the same time. Most clients should use <link linkend="folks-individual-aggregator-dup"><function>folks_individual_aggregator_dup()</function></link> to retrieve the IndividualAggregator singleton.</para>
 */
/**
 * FOLKS_TYPE_INDIVIDUAL_AGGREGATOR:
 * 
 * The type for <link linkend="FolksIndividualAggregator"><type>FolksIndividualAggregator</type></link>.
 */
/**
 * folks_individual_aggregator_prepare:
 * @self: the <link linkend="FolksIndividualAggregator"><type>FolksIndividualAggregator</type></link> instance
 * @_callback_: (scope async): callback to call when the request is satisfied
 * @_user_data_: (closure): the data to pass to @_callback_ function
 * 
 * Prepare the IndividualAggregator for use.
 * 
 * <para>This loads all the available backends and prepares them for use by the IndividualAggregator. This should be called <emphasis>after</emphasis> connecting to the <link linkend="FolksIndividualAggregator-individuals-changed"><type>"individuals-changed"</type></link> signal (or <link linkend="FolksIndividualAggregator-individuals-changed-detailed"><type>"individuals-changed-detailed"</type></link> signal), or a race condition could occur, with the signal being emitted before your code has connected to them, and <link linkend="FolksIndividual"><type>FolksIndividual</type></link>s getting &quot;lost&quot; as a result.</para><para>This function is guaranteed to be idempotent (since version 0.3.0).</para><para>Concurrent calls to this function from different threads will block until preparation has completed. However, concurrent calls to this function from a single thread might not, i.e. the first call will block but subsequent calls might return before the first one. (Though they will be safe in every other respect.)</para>
 * <para><link linkend="GError"><type>GError</type></link> will be returned in @error <para>if preparing any of the backends failed — this error will be passed through from <link linkend="folks-backend-store-load-backends"><function>folks_backend_store_load_backends()</function></link> </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-individual-aggregator-prepare-finish"><function>folks_individual_aggregator_prepare_finish()</function></link>
 *
 * Since: 0.1.11
 */
/**
 * folks_individual_aggregator_prepare_finish:
 * @self: the <link linkend="FolksIndividualAggregator"><type>FolksIndividualAggregator</type></link> instance
 * @_res_: a <link linkend="GAsyncResult"><type>GAsyncResult</type></link>
 * @error: location to store the error occurring, or %NULL to ignore
 * 
 * Prepare the IndividualAggregator for use.
 * 
 * <para>This loads all the available backends and prepares them for use by the IndividualAggregator. This should be called <emphasis>after</emphasis> connecting to the <link linkend="FolksIndividualAggregator-individuals-changed"><type>"individuals-changed"</type></link> signal (or <link linkend="FolksIndividualAggregator-individuals-changed-detailed"><type>"individuals-changed-detailed"</type></link> signal), or a race condition could occur, with the signal being emitted before your code has connected to them, and <link linkend="FolksIndividual"><type>FolksIndividual</type></link>s getting &quot;lost&quot; as a result.</para><para>This function is guaranteed to be idempotent (since version 0.3.0).</para><para>Concurrent calls to this function from different threads will block until preparation has completed. However, concurrent calls to this function from a single thread might not, i.e. the first call will block but subsequent calls might return before the first one. (Though they will be safe in every other respect.)</para>
 * <para><link linkend="GError"><type>GError</type></link> will be returned in @error <para>if preparing any of the backends failed — this error will be passed through from <link linkend="folks-backend-store-load-backends"><function>folks_backend_store_load_backends()</function></link> </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-individual-aggregator-prepare"><function>folks_individual_aggregator_prepare()</function></link>
 *
 * Since: 0.1.11
 */
/**
 * folks_individual_aggregator_unprepare:
 * @self: the <link linkend="FolksIndividualAggregator"><type>FolksIndividualAggregator</type></link> instance
 * @_callback_: (scope async): callback to call when the request is satisfied
 * @_user_data_: (closure): the data to pass to @_callback_ function
 * 
 * Clean up and release resources used by the aggregator.
 * 
 * <para>This will disconnect the aggregator cleanly from any resources it or its persona stores are using. It is recommended to call this method before finalising the individual aggregator, but calling it is not required. If this method is not called then, for example, unsaved changes in backends may not be flushed.</para><para>Concurrent calls to this function from different threads will block until preparation has completed. However, concurrent calls to this function from a single thread might not, i.e. the first call will block but subsequent calls might return before the first one. (Though they will be safe in every other respect.)</para>
 * <para><link linkend="GError"><type>GError</type></link> will be returned in @error <para>if unpreparing the backend-specific services failed — this will be a backend-specific error </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-individual-aggregator-unprepare-finish"><function>folks_individual_aggregator_unprepare_finish()</function></link>
 *
 * Since: 0.7.3
 */
/**
 * folks_individual_aggregator_unprepare_finish:
 * @self: the <link linkend="FolksIndividualAggregator"><type>FolksIndividualAggregator</type></link> instance
 * @_res_: a <link linkend="GAsyncResult"><type>GAsyncResult</type></link>
 * @error: location to store the error occurring, or %NULL to ignore
 * 
 * Clean up and release resources used by the aggregator.
 * 
 * <para>This will disconnect the aggregator cleanly from any resources it or its persona stores are using. It is recommended to call this method before finalising the individual aggregator, but calling it is not required. If this method is not called then, for example, unsaved changes in backends may not be flushed.</para><para>Concurrent calls to this function from different threads will block until preparation has completed. However, concurrent calls to this function from a single thread might not, i.e. the first call will block but subsequent calls might return before the first one. (Though they will be safe in every other respect.)</para>
 * <para><link linkend="GError"><type>GError</type></link> will be returned in @error <para>if unpreparing the backend-specific services failed — this will be a backend-specific error </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-individual-aggregator-unprepare"><function>folks_individual_aggregator_unprepare()</function></link>
 *
 * Since: 0.7.3
 */
/**
 * folks_individual_aggregator_get_potential_matches:
 * @self: the <link linkend="FolksIndividualAggregator"><type>FolksIndividualAggregator</type></link> instance
 * @matchee: (in): &nbsp;.  <para>the individual to find matches for </para>
 * @min_threshold: (in): &nbsp;.  <para>the threshold for accepting a match </para>
 * 
 * Get all matches for a given <link linkend="FolksIndividual"><type>FolksIndividual</type></link>.
 * 
 * Returns: <para>a map from matched individuals to the degree with which they match <code>matchee</code> (which is guaranteed to at least equal <code>min_threshold</code>); if no matches could be found, an empty map is returned </para>
 *
 * Since: 0.5.1
 */
/**
 * folks_individual_aggregator_get_all_potential_matches:
 * @self: the <link linkend="FolksIndividualAggregator"><type>FolksIndividualAggregator</type></link> instance
 * @min_threshold: (in): &nbsp;.  <para>the threshold for accepting a match </para>
 * 
 * Get all combinations between all <link linkend="FolksIndividual"><type>FolksIndividual</type></link>s.
 * 
 * Returns: <para>a map from each individual in the aggregator to a map of the other individuals in the aggregator which can be matched with that individual, mapped to the degree with which they match the original individual (which is guaranteed to at least equal <code>min_threshold</code>) </para>
 *
 * Since: 0.5.1
 */
/**
 * folks_individual_aggregator_add_persona_from_details:
 * @self: the <link linkend="FolksIndividualAggregator"><type>FolksIndividualAggregator</type></link> instance
 * @parent: (in) (allow-none): &nbsp;.  <para>an optional <link linkend="FolksIndividual"><type>FolksIndividual</type></link> to add the new <link linkend="FolksPersona"><type>FolksPersona</type></link> to. This persona will be appended to its ordered list of personas. </para>
 * @persona_store: (in): &nbsp;.  <para>the <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> to add the persona to </para>
 * @details: (in): &nbsp;.  <para>a key-value map of details to use in creating the new <link linkend="FolksPersona"><type>FolksPersona</type></link> </para>
 * @_callback_: (scope async): callback to call when the request is satisfied
 * @_user_data_: (closure): the data to pass to @_callback_ function
 * 
 * Add a new persona in the given <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> based on the <code>details</code> provided.
 * 
 * <para>If the target store is offline, this function will throw <link linkend="FOLKS-INDIVIDUAL-AGGREGATOR-ERROR-STORE-OFFLINE:CAPS"><literal>FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_STORE_OFFLINE</literal></link>. It&apos;s the responsibility of the caller to cache details and re-try this function if it wishes to make offline adds work.</para><para>The details hash is a backend-specific mapping of key, value strings. Common keys include:</para><itemizedlist><listitem><para>contact - service-specific contact ID</para></listitem><listitem><para>message - a user-readable message to pass to the persona being added</para></listitem></itemizedlist><para>If a <link linkend="FolksPersona"><type>FolksPersona</type></link> with the given details already exists in the store, no error will be thrown and this function will return <code>null</code>.</para>
 * <para><link linkend="FOLKS-INDIVIDUAL-AGGREGATOR-ERROR-STORE-OFFLINE:CAPS"><literal>FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_STORE_OFFLINE</literal></link> will be returned in @error <para>if the persona store was offline </para></para>
 * <para><link linkend="FOLKS-INDIVIDUAL-AGGREGATOR-ERROR-ADD-FAILED:CAPS"><literal>FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_ADD_FAILED</literal></link> will be returned in @error <para>if any other error occurred while adding the persona </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-individual-aggregator-add-persona-from-details-finish"><function>folks_individual_aggregator_add_persona_from_details_finish()</function></link>
 *
 * Since: 0.3.5
 */
/**
 * folks_individual_aggregator_add_persona_from_details_finish:
 * @self: the <link linkend="FolksIndividualAggregator"><type>FolksIndividualAggregator</type></link> instance
 * @_res_: a <link linkend="GAsyncResult"><type>GAsyncResult</type></link>
 * @error: (error-domains FolksIndividualAggregatorError): location to store the error occurring, or %NULL to ignore
 * 
 * Add a new persona in the given <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> based on the <code>details</code> provided.
 * 
 * <para>If the target store is offline, this function will throw <link linkend="FOLKS-INDIVIDUAL-AGGREGATOR-ERROR-STORE-OFFLINE:CAPS"><literal>FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_STORE_OFFLINE</literal></link>. It&apos;s the responsibility of the caller to cache details and re-try this function if it wishes to make offline adds work.</para><para>The details hash is a backend-specific mapping of key, value strings. Common keys include:</para><itemizedlist><listitem><para>contact - service-specific contact ID</para></listitem><listitem><para>message - a user-readable message to pass to the persona being added</para></listitem></itemizedlist><para>If a <link linkend="FolksPersona"><type>FolksPersona</type></link> with the given details already exists in the store, no error will be thrown and this function will return <code>null</code>.</para>
 * <para><link linkend="FOLKS-INDIVIDUAL-AGGREGATOR-ERROR-STORE-OFFLINE:CAPS"><literal>FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_STORE_OFFLINE</literal></link> will be returned in @error <para>if the persona store was offline </para></para>
 * <para><link linkend="FOLKS-INDIVIDUAL-AGGREGATOR-ERROR-ADD-FAILED:CAPS"><literal>FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_ADD_FAILED</literal></link> will be returned in @error <para>if any other error occurred while adding the persona </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-individual-aggregator-add-persona-from-details"><function>folks_individual_aggregator_add_persona_from_details()</function></link>
 * 
 * Returns: <para>the new <link linkend="FolksPersona"><type>FolksPersona</type></link> or <code>null</code> if the corresponding <link linkend="FolksPersona"><type>FolksPersona</type></link> already existed. If non-<code>null</code>, the new <link linkend="FolksPersona"><type>FolksPersona</type></link> will also be added to a new or existing <link linkend="FolksIndividual"><type>FolksIndividual</type></link> as necessary. </para>
 *
 * Since: 0.3.5
 */
/**
 * folks_individual_aggregator_remove_individual:
 * @self: the <link linkend="FolksIndividualAggregator"><type>FolksIndividualAggregator</type></link> instance
 * @individual: (in): &nbsp;.  <para>the <link linkend="FolksIndividual"><type>FolksIndividual</type></link> to remove </para>
 * @_callback_: (scope async): callback to call when the request is satisfied
 * @_user_data_: (closure): the data to pass to @_callback_ function
 * 
 * Completely remove the individual and all of its personas from their backing stores.
 * 
 * <para>This method is safe to call multiple times concurrently (for the same individual or different individuals).</para>
 * <para><link linkend="GError"><type>GError</type></link> will be returned in @error <para>if removing the persona failed — this will be passed through from <link linkend="folks-persona-store-remove-persona"><function>folks_persona_store_remove_persona()</function></link> </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-individual-aggregator-remove-individual-finish"><function>folks_individual_aggregator_remove_individual_finish()</function></link>
 *
 * Since: 0.1.11
 */
/**
 * folks_individual_aggregator_remove_individual_finish:
 * @self: the <link linkend="FolksIndividualAggregator"><type>FolksIndividualAggregator</type></link> instance
 * @_res_: a <link linkend="GAsyncResult"><type>GAsyncResult</type></link>
 * @error: location to store the error occurring, or %NULL to ignore
 * 
 * Completely remove the individual and all of its personas from their backing stores.
 * 
 * <para>This method is safe to call multiple times concurrently (for the same individual or different individuals).</para>
 * <para><link linkend="GError"><type>GError</type></link> will be returned in @error <para>if removing the persona failed — this will be passed through from <link linkend="folks-persona-store-remove-persona"><function>folks_persona_store_remove_persona()</function></link> </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-individual-aggregator-remove-individual"><function>folks_individual_aggregator_remove_individual()</function></link>
 *
 * Since: 0.1.11
 */
/**
 * folks_individual_aggregator_remove_persona:
 * @self: the <link linkend="FolksIndividualAggregator"><type>FolksIndividualAggregator</type></link> instance
 * @persona: (in): &nbsp;.  <para>the <link linkend="FolksPersona"><type>FolksPersona</type></link> to remove </para>
 * @_callback_: (scope async): callback to call when the request is satisfied
 * @_user_data_: (closure): the data to pass to @_callback_ function
 * 
 * Completely remove the persona from its backing store.
 * 
 * <para>This will leave other personas in the same individual alone.</para><para>This method is safe to call multiple times concurrently (for the same persona or different personas).</para>
 * <para><link linkend="GError"><type>GError</type></link> will be returned in @error <para>if removing the persona failed — this will be passed through from <link linkend="folks-persona-store-remove-persona"><function>folks_persona_store_remove_persona()</function></link> </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-individual-aggregator-remove-persona-finish"><function>folks_individual_aggregator_remove_persona_finish()</function></link>
 *
 * Since: 0.1.11
 */
/**
 * folks_individual_aggregator_remove_persona_finish:
 * @self: the <link linkend="FolksIndividualAggregator"><type>FolksIndividualAggregator</type></link> instance
 * @_res_: a <link linkend="GAsyncResult"><type>GAsyncResult</type></link>
 * @error: location to store the error occurring, or %NULL to ignore
 * 
 * Completely remove the persona from its backing store.
 * 
 * <para>This will leave other personas in the same individual alone.</para><para>This method is safe to call multiple times concurrently (for the same persona or different personas).</para>
 * <para><link linkend="GError"><type>GError</type></link> will be returned in @error <para>if removing the persona failed — this will be passed through from <link linkend="folks-persona-store-remove-persona"><function>folks_persona_store_remove_persona()</function></link> </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-individual-aggregator-remove-persona"><function>folks_individual_aggregator_remove_persona()</function></link>
 *
 * Since: 0.1.11
 */
/**
 * folks_individual_aggregator_link_personas:
 * @self: the <link linkend="FolksIndividualAggregator"><type>FolksIndividualAggregator</type></link> instance
 * @personas: (in): &nbsp;.  <para>the <link linkend="FolksPersona"><type>FolksPersona</type></link>s to be linked </para>
 * @_callback_: (scope async): callback to call when the request is satisfied
 * @_user_data_: (closure): the data to pass to @_callback_ function
 * 
 * Link the given <link linkend="FolksPersona"><type>FolksPersona</type></link>s together.
 * 
 * <para>Create links between the given <link linkend="FolksPersona"><type>FolksPersona</type></link>s so that they form a single <link linkend="FolksIndividual"><type>FolksIndividual</type></link>. The new <link linkend="FolksIndividual"><type>FolksIndividual</type></link> will be returned via the <link linkend="FolksIndividualAggregator-individuals-changed"><type>"individuals-changed"</type></link> signal.</para><para>Removal of the <link linkend="FolksIndividual"><type>FolksIndividual</type></link>s which the <link linkend="FolksPersona"><type>FolksPersona</type></link>s were in before is signalled by <link linkend="FolksIndividualAggregator-individuals-changed"><type>"individuals-changed"</type></link> and <link linkend="FolksIndividual-removed"><type>"removed"</type></link>.</para><para>This method is safe to call multiple times concurrently.</para>
 * <para><link linkend="FOLKS-INDIVIDUAL-AGGREGATOR-ERROR-NO-PRIMARY-STORE:CAPS"><literal>FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_NO_PRIMARY_STORE</literal></link> will be returned in @error <para>if no primary store has been configured for the individual aggregator </para></para>
 * <para><link linkend="FolksIndividualAggregatorError"><type>FolksIndividualAggregatorError</type></link> will be returned in @error <para>if adding the linking persona failed — this will be passed through from <link linkend="folks-individual-aggregator-add-persona-from-details"><function>folks_individual_aggregator_add_persona_from_details()</function></link> </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-individual-aggregator-link-personas-finish"><function>folks_individual_aggregator_link_personas_finish()</function></link>
 *
 * Since: 0.5.1
 */
/**
 * folks_individual_aggregator_link_personas_finish:
 * @self: the <link linkend="FolksIndividualAggregator"><type>FolksIndividualAggregator</type></link> instance
 * @_res_: a <link linkend="GAsyncResult"><type>GAsyncResult</type></link>
 * @error: (error-domains FolksIndividualAggregatorError): location to store the error occurring, or %NULL to ignore
 * 
 * Link the given <link linkend="FolksPersona"><type>FolksPersona</type></link>s together.
 * 
 * <para>Create links between the given <link linkend="FolksPersona"><type>FolksPersona</type></link>s so that they form a single <link linkend="FolksIndividual"><type>FolksIndividual</type></link>. The new <link linkend="FolksIndividual"><type>FolksIndividual</type></link> will be returned via the <link linkend="FolksIndividualAggregator-individuals-changed"><type>"individuals-changed"</type></link> signal.</para><para>Removal of the <link linkend="FolksIndividual"><type>FolksIndividual</type></link>s which the <link linkend="FolksPersona"><type>FolksPersona</type></link>s were in before is signalled by <link linkend="FolksIndividualAggregator-individuals-changed"><type>"individuals-changed"</type></link> and <link linkend="FolksIndividual-removed"><type>"removed"</type></link>.</para><para>This method is safe to call multiple times concurrently.</para>
 * <para><link linkend="FOLKS-INDIVIDUAL-AGGREGATOR-ERROR-NO-PRIMARY-STORE:CAPS"><literal>FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_NO_PRIMARY_STORE</literal></link> will be returned in @error <para>if no primary store has been configured for the individual aggregator </para></para>
 * <para><link linkend="FolksIndividualAggregatorError"><type>FolksIndividualAggregatorError</type></link> will be returned in @error <para>if adding the linking persona failed — this will be passed through from <link linkend="folks-individual-aggregator-add-persona-from-details"><function>folks_individual_aggregator_add_persona_from_details()</function></link> </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-individual-aggregator-link-personas"><function>folks_individual_aggregator_link_personas()</function></link>
 *
 * Since: 0.5.1
 */
/**
 * folks_individual_aggregator_unlink_individual:
 * @self: the <link linkend="FolksIndividualAggregator"><type>FolksIndividualAggregator</type></link> instance
 * @individual: (in): &nbsp;.  <para>the <link linkend="FolksIndividual"><type>FolksIndividual</type></link> to unlink </para>
 * @_callback_: (scope async): callback to call when the request is satisfied
 * @_user_data_: (closure): the data to pass to @_callback_ function
 * 
 * Unlinks the given <link linkend="FolksIndividual"><type>FolksIndividual</type></link> into its constituent <link linkend="FolksPersona"><type>FolksPersona</type></link>s.
 * 
 * <para>This completely unlinks the given <link linkend="FolksIndividual"><type>FolksIndividual</type></link>, destroying all of its writeable <link linkend="FolksPersona"><type>FolksPersona</type></link>s.</para><para>The <link linkend="FolksIndividual"><type>FolksIndividual</type></link>&apos;s removal is signalled by <link linkend="FolksIndividualAggregator-individuals-changed"><type>"individuals-changed"</type></link> and <link linkend="FolksIndividual-removed"><type>"removed"</type></link>.</para><para>The <link linkend="FolksPersona"><type>FolksPersona</type></link>s comprising the <link linkend="FolksIndividual"><type>FolksIndividual</type></link> will be re-linked into one or more new <link linkend="FolksIndividual"><type>FolksIndividual</type></link>s, depending on how much linking data remains (typically only implicit links remain). The addition of these new <link linkend="FolksIndividual"><type>FolksIndividual</type></link>s will be signalled by <link linkend="FolksIndividualAggregator-individuals-changed"><type>"individuals-changed"</type></link>.</para><para>This method is safe to call multiple times concurrently, although concurrent calls for the same individual may result in duplicate personas being created.</para>
 * <para><link linkend="GError"><type>GError</type></link> will be returned in @error <para>if removing the linking persona failed — this will be passed through from <link linkend="folks-persona-store-remove-persona"><function>folks_persona_store_remove_persona()</function></link> </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-individual-aggregator-unlink-individual-finish"><function>folks_individual_aggregator_unlink_individual_finish()</function></link>
 *
 * Since: 0.1.13
 */
/**
 * folks_individual_aggregator_unlink_individual_finish:
 * @self: the <link linkend="FolksIndividualAggregator"><type>FolksIndividualAggregator</type></link> instance
 * @_res_: a <link linkend="GAsyncResult"><type>GAsyncResult</type></link>
 * @error: location to store the error occurring, or %NULL to ignore
 * 
 * Unlinks the given <link linkend="FolksIndividual"><type>FolksIndividual</type></link> into its constituent <link linkend="FolksPersona"><type>FolksPersona</type></link>s.
 * 
 * <para>This completely unlinks the given <link linkend="FolksIndividual"><type>FolksIndividual</type></link>, destroying all of its writeable <link linkend="FolksPersona"><type>FolksPersona</type></link>s.</para><para>The <link linkend="FolksIndividual"><type>FolksIndividual</type></link>&apos;s removal is signalled by <link linkend="FolksIndividualAggregator-individuals-changed"><type>"individuals-changed"</type></link> and <link linkend="FolksIndividual-removed"><type>"removed"</type></link>.</para><para>The <link linkend="FolksPersona"><type>FolksPersona</type></link>s comprising the <link linkend="FolksIndividual"><type>FolksIndividual</type></link> will be re-linked into one or more new <link linkend="FolksIndividual"><type>FolksIndividual</type></link>s, depending on how much linking data remains (typically only implicit links remain). The addition of these new <link linkend="FolksIndividual"><type>FolksIndividual</type></link>s will be signalled by <link linkend="FolksIndividualAggregator-individuals-changed"><type>"individuals-changed"</type></link>.</para><para>This method is safe to call multiple times concurrently, although concurrent calls for the same individual may result in duplicate personas being created.</para>
 * <para><link linkend="GError"><type>GError</type></link> will be returned in @error <para>if removing the linking persona failed — this will be passed through from <link linkend="folks-persona-store-remove-persona"><function>folks_persona_store_remove_persona()</function></link> </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-individual-aggregator-unlink-individual"><function>folks_individual_aggregator_unlink_individual()</function></link>
 *
 * Since: 0.1.13
 */
/**
 * folks_individual_aggregator_ensure_individual_property_writeable:
 * @self: the <link linkend="FolksIndividualAggregator"><type>FolksIndividualAggregator</type></link> instance
 * @individual: (in): &nbsp;.  <para>the individual for which <code>property_name</code> should be writeable </para>
 * @property_name: (in): &nbsp;.  <para>the name of the property which needs to be writeable (this should be in lower case using hyphens, e.g. “web-service-addresses”) </para>
 * @_callback_: (scope async): callback to call when the request is satisfied
 * @_user_data_: (closure): the data to pass to @_callback_ function
 * 
 * Ensure that the given property is writeable for the given <link linkend="FolksIndividual"><type>FolksIndividual</type></link>.
 * 
 * <para>This makes sure that there is at least one <link linkend="FolksPersona"><type>FolksPersona</type></link> in the individual which has <code>property_name</code> in its <link linkend="FolksPersona--writeable-properties"><type>"writeable-properties"</type></link>. If no such persona exists in the individual, a new one will be created and linked to the individual. (Note that due to the design of the aggregator, this will result in the previous individual being removed and replaced by a new one with the new persona; listen to the <link linkend="FolksIndividual-removed"><type>"removed"</type></link> signal to see the replacement.)</para><para>It may not be possible to create a new persona which has the given property as writeable. In that case, a <link linkend="FOLKS-INDIVIDUAL-AGGREGATOR-ERROR-NO-PRIMARY-STORE:CAPS"><literal>FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_NO_PRIMARY_STORE</literal></link> or <link linkend="FOLKS-INDIVIDUAL-AGGREGATOR-ERROR-PROPERTY-NOT-WRITEABLE:CAPS"><literal>FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_PROPERTY_NOT_WRITEABLE</literal></link> error will be thrown.</para><para>This method is safe to call multiple times concurrently, although concurrent calls for the same individual may result in duplicate personas being created.</para>
 * <para><link linkend="FOLKS-INDIVIDUAL-AGGREGATOR-ERROR-NO-PRIMARY-STORE:CAPS"><literal>FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_NO_PRIMARY_STORE</literal></link> will be returned in @error <para>if no primary store was configured for this individual aggregator </para></para>
 * <para><link linkend="FOLKS-INDIVIDUAL-AGGREGATOR-ERROR-PROPERTY-NOT-WRITEABLE:CAPS"><literal>FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_PROPERTY_NOT_WRITEABLE</literal></link> will be returned in @error <para>if the given <code>property_name</code> referred to a non-writeable property </para></para>
 * <para><link linkend="FolksIndividualAggregatorError"><type>FolksIndividualAggregatorError</type></link> will be returned in @error <para>if adding a new persona (using <link linkend="folks-individual-aggregator-add-persona-from-details"><function>folks_individual_aggregator_add_persona_from_details()</function></link>) failed, or if linking personas (using <link linkend="folks-individual-aggregator-link-personas"><function>folks_individual_aggregator_link_personas()</function></link>) failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-individual-aggregator-ensure-individual-property-writeable-finish"><function>folks_individual_aggregator_ensure_individual_property_writeable_finish()</function></link>
 *
 * Since: 0.6.2
 */
/**
 * folks_individual_aggregator_ensure_individual_property_writeable_finish:
 * @self: the <link linkend="FolksIndividualAggregator"><type>FolksIndividualAggregator</type></link> instance
 * @_res_: a <link linkend="GAsyncResult"><type>GAsyncResult</type></link>
 * @error: (error-domains FolksIndividualAggregatorError): location to store the error occurring, or %NULL to ignore
 * 
 * Ensure that the given property is writeable for the given <link linkend="FolksIndividual"><type>FolksIndividual</type></link>.
 * 
 * <para>This makes sure that there is at least one <link linkend="FolksPersona"><type>FolksPersona</type></link> in the individual which has <code>property_name</code> in its <link linkend="FolksPersona--writeable-properties"><type>"writeable-properties"</type></link>. If no such persona exists in the individual, a new one will be created and linked to the individual. (Note that due to the design of the aggregator, this will result in the previous individual being removed and replaced by a new one with the new persona; listen to the <link linkend="FolksIndividual-removed"><type>"removed"</type></link> signal to see the replacement.)</para><para>It may not be possible to create a new persona which has the given property as writeable. In that case, a <link linkend="FOLKS-INDIVIDUAL-AGGREGATOR-ERROR-NO-PRIMARY-STORE:CAPS"><literal>FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_NO_PRIMARY_STORE</literal></link> or <link linkend="FOLKS-INDIVIDUAL-AGGREGATOR-ERROR-PROPERTY-NOT-WRITEABLE:CAPS"><literal>FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_PROPERTY_NOT_WRITEABLE</literal></link> error will be thrown.</para><para>This method is safe to call multiple times concurrently, although concurrent calls for the same individual may result in duplicate personas being created.</para>
 * <para><link linkend="FOLKS-INDIVIDUAL-AGGREGATOR-ERROR-NO-PRIMARY-STORE:CAPS"><literal>FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_NO_PRIMARY_STORE</literal></link> will be returned in @error <para>if no primary store was configured for this individual aggregator </para></para>
 * <para><link linkend="FOLKS-INDIVIDUAL-AGGREGATOR-ERROR-PROPERTY-NOT-WRITEABLE:CAPS"><literal>FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_PROPERTY_NOT_WRITEABLE</literal></link> will be returned in @error <para>if the given <code>property_name</code> referred to a non-writeable property </para></para>
 * <para><link linkend="FolksIndividualAggregatorError"><type>FolksIndividualAggregatorError</type></link> will be returned in @error <para>if adding a new persona (using <link linkend="folks-individual-aggregator-add-persona-from-details"><function>folks_individual_aggregator_add_persona_from_details()</function></link>) failed, or if linking personas (using <link linkend="folks-individual-aggregator-link-personas"><function>folks_individual_aggregator_link_personas()</function></link>) failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-individual-aggregator-ensure-individual-property-writeable"><function>folks_individual_aggregator_ensure_individual_property_writeable()</function></link>
 * 
 * Returns: <para>a persona (new or existing) which has the given property as writeable </para>
 *
 * Since: 0.6.2
 */
/**
 * folks_individual_aggregator_look_up_individual:
 * @self: the <link linkend="FolksIndividualAggregator"><type>FolksIndividualAggregator</type></link> instance
 * @id: (in): &nbsp;.  <para>ID of the individual to look up </para>
 * @_callback_: (scope async): callback to call when the request is satisfied
 * @_user_data_: (closure): the data to pass to @_callback_ function
 * 
 * Look up an individual in the aggregator.
 * 
 * <para>This returns the <link linkend="FolksIndividual"><type>FolksIndividual</type></link> with the given <code>id</code> if it exists in the aggregator, and <code>null</code> otherwise.</para><para>In future, when lazy-loading of individuals&apos; properties is added to folks, this method guarantees to load all properties of the individual, even if the aggregator hasn&apos;t lazy-loaded anything else.</para><para>This method is safe to call before <link linkend="folks-individual-aggregator-prepare"><function>folks_individual_aggregator_prepare()</function></link> has been called, and will call <link linkend="folks-individual-aggregator-prepare"><function>folks_individual_aggregator_prepare()</function></link> itself in that case.</para><para>This method is safe to call multiple times concurrently.</para>
 * <para><link linkend="GError"><type>GError</type></link> will be returned in @error <para>from <link linkend="folks-individual-aggregator-prepare"><function>folks_individual_aggregator_prepare()</function></link> </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-individual-aggregator-look-up-individual-finish"><function>folks_individual_aggregator_look_up_individual_finish()</function></link>
 *
 * Since: 0.7.0
 */
/**
 * folks_individual_aggregator_look_up_individual_finish:
 * @self: the <link linkend="FolksIndividualAggregator"><type>FolksIndividualAggregator</type></link> instance
 * @_res_: a <link linkend="GAsyncResult"><type>GAsyncResult</type></link>
 * @error: location to store the error occurring, or %NULL to ignore
 * 
 * Look up an individual in the aggregator.
 * 
 * <para>This returns the <link linkend="FolksIndividual"><type>FolksIndividual</type></link> with the given <code>id</code> if it exists in the aggregator, and <code>null</code> otherwise.</para><para>In future, when lazy-loading of individuals&apos; properties is added to folks, this method guarantees to load all properties of the individual, even if the aggregator hasn&apos;t lazy-loaded anything else.</para><para>This method is safe to call before <link linkend="folks-individual-aggregator-prepare"><function>folks_individual_aggregator_prepare()</function></link> has been called, and will call <link linkend="folks-individual-aggregator-prepare"><function>folks_individual_aggregator_prepare()</function></link> itself in that case.</para><para>This method is safe to call multiple times concurrently.</para>
 * <para><link linkend="GError"><type>GError</type></link> will be returned in @error <para>from <link linkend="folks-individual-aggregator-prepare"><function>folks_individual_aggregator_prepare()</function></link> </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-individual-aggregator-look-up-individual"><function>folks_individual_aggregator_look_up_individual()</function></link>
 * 
 * Returns: <para>individual with <code>id</code>, or <code>null</code> if no such individual was found </para>
 *
 * Since: 0.7.0
 */
/**
 * folks_individual_aggregator_new:
 * 
 * Create a new IndividualAggregator.
 * 
 * <para>Clients should connect to the <link linkend="FolksIndividualAggregator-individuals-changed"><type>"individuals-changed"</type></link> signal (or the <link linkend="FolksIndividualAggregator-individuals-changed-detailed"><type>"individuals-changed-detailed"</type></link> signal), then call <link linkend="folks-individual-aggregator-prepare"><function>folks_individual_aggregator_prepare()</function></link> to load the backends and start aggregating individuals.</para><para>An example of how to set up an IndividualAggregator: 
 * |[
 *   IndividualAggregator agg = new IndividualAggregator ();
 *   agg.individuals_changed_detailed.connect (individuals_changed_cb);
 *   agg.prepare ();
 * ]|
 * </para><para>Folks does not support having more than one IndividualAggregator instantiated at the same time. So it&apos;s recommended to use <link linkend="folks-individual-aggregator-dup"><function>folks_individual_aggregator_dup()</function></link> instead.</para>
 *
 * Deprecated: 0.9.5: Replaced by folks_individual_aggregator_dup ().
 */
/**
 * folks_individual_aggregator_new_with_backend_store:
 * @store: (in): &nbsp;.  <para>the <link linkend="FolksBackendStore"><type>FolksBackendStore</type></link> to use instead of the default one. </para>
 * 
 * Create a new IndividualAggregator with a custom <link linkend="FolksBackendStore"><type>FolksBackendStore</type></link>.
 * 
 * <para>This behaves the same as the default constructor for <link linkend="folks-individual-aggregator-new"><function>folks_individual_aggregator_new()</function></link>, but uses the given <link linkend="FolksBackendStore"><type>FolksBackendStore</type></link> rather than the default one.</para>
 *
 * Since: 0.9.0
 * Deprecated: 0.9.5: Replaced by folks_individual_aggregator_dup_with_backend_store ().
 */
/**
 * FolksIndividualAggregator:is-prepared:
 * 
 * Whether <link linkend="folks-individual-aggregator-prepare"><function>folks_individual_aggregator_prepare()</function></link> has successfully completed for this aggregator.
 *
 * Since: 0.3.0
 */
/**
 * folks_individual_aggregator_get_is_prepared:
 * @self: the <link linkend="FolksIndividualAggregator"><type>FolksIndividualAggregator</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksIndividualAggregator--is-prepared"><type>"is-prepared"</type></link> property.
 * 
 * Whether <link linkend="folks-individual-aggregator-prepare"><function>folks_individual_aggregator_prepare()</function></link> has successfully completed for this aggregator.
 * 
 * Returns: the value of the <link linkend="FolksIndividualAggregator--is-prepared"><type>"is-prepared"</type></link> property
 *
 * Since: 0.3.0
 */
/**
 * FolksIndividualAggregator:is-quiescent:
 * 
 * Whether the aggregator has reached a quiescent state. This will happen at some point after <link linkend="folks-individual-aggregator-prepare"><function>folks_individual_aggregator_prepare()</function></link> has successfully completed for the aggregator. An aggregator is in a quiescent state when all the <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link>s listed by its backends have reached a quiescent state. Once it&apos;s reached a quiescent state, this property will never change again (from <code>true</code> to <code>false</code>).
 * 
 * <para>It&apos;s guaranteed that this property&apos;s value will only ever change after <link linkend="FolksIndividualAggregator--is-prepared"><type>"is-prepared"</type></link> has changed to <code>true</code>.</para>
 *
 * Since: 0.6.2
 */
/**
 * folks_individual_aggregator_get_is_quiescent:
 * @self: the <link linkend="FolksIndividualAggregator"><type>FolksIndividualAggregator</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksIndividualAggregator--is-quiescent"><type>"is-quiescent"</type></link> property.
 * 
 * Whether the aggregator has reached a quiescent state. This will happen at some point after <link linkend="folks-individual-aggregator-prepare"><function>folks_individual_aggregator_prepare()</function></link> has successfully completed for the aggregator. An aggregator is in a quiescent state when all the <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link>s listed by its backends have reached a quiescent state. Once it&apos;s reached a quiescent state, this property will never change again (from <code>true</code> to <code>false</code>).
 * 
 * <para>It&apos;s guaranteed that this property&apos;s value will only ever change after <link linkend="FolksIndividualAggregator--is-prepared"><type>"is-prepared"</type></link> has changed to <code>true</code>.</para>
 * 
 * Returns: the value of the <link linkend="FolksIndividualAggregator--is-quiescent"><type>"is-quiescent"</type></link> property
 *
 * Since: 0.6.2
 */
/**
 * FolksIndividualAggregator:primary-store:
 * 
 * Our configured primary (writeable) store.
 * 
 * <para>Which one to use is decided (in order or precedence) by:</para><para>- the FOLKS_PRIMARY_STORE env var (mostly for debugging) - the GSettings key set in <code>_PRIMARY_STORE_CONFIG_KEY</code> (system set store) - going with the <code>key-file</code> or <code>eds</code> store as the fall-back option</para>
 *
 * Since: 0.5.0
 */
/**
 * folks_individual_aggregator_get_primary_store:
 * @self: the <link linkend="FolksIndividualAggregator"><type>FolksIndividualAggregator</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksIndividualAggregator--primary-store"><type>"primary-store"</type></link> property.
 * 
 * Our configured primary (writeable) store.
 * 
 * <para>Which one to use is decided (in order or precedence) by:</para><para>- the FOLKS_PRIMARY_STORE env var (mostly for debugging) - the GSettings key set in <code>_PRIMARY_STORE_CONFIG_KEY</code> (system set store) - going with the <code>key-file</code> or <code>eds</code> store as the fall-back option</para>
 * 
 * Returns: the value of the <link linkend="FolksIndividualAggregator--primary-store"><type>"primary-store"</type></link> property
 *
 * Since: 0.5.0
 */
/**
 * FolksIndividualAggregator:backend-store:
 * 
 * The backend store providing the persona stores for this aggregator.
 *
 * Since: 0.9.7
 */
/**
 * folks_individual_aggregator_get_backend_store:
 * @self: the <link linkend="FolksIndividualAggregator"><type>FolksIndividualAggregator</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksIndividualAggregator--backend-store"><type>"backend-store"</type></link> property.
 * 
 * The backend store providing the persona stores for this aggregator.
 * 
 * Returns: the value of the <link linkend="FolksIndividualAggregator--backend-store"><type>"backend-store"</type></link> property
 *
 * Since: 0.9.7
 */
/**
 * FolksIndividualAggregator:individuals:
 * 
 * A map from <link linkend="FolksIndividual--id"><type>"id"</type></link>s to their <link linkend="FolksIndividual"><type>FolksIndividual</type></link>s.
 * 
 * <para>This is the canonical set of <link linkend="FolksIndividual"><type>FolksIndividual</type></link>s provided by this IndividualAggregator.</para><para><link linkend="FolksIndividual"><type>FolksIndividual</type></link>s may be added or removed using <link linkend="folks-individual-aggregator-add-persona-from-details"><function>folks_individual_aggregator_add_persona_from_details()</function></link> and <link linkend="folks-individual-aggregator-remove-individual"><function>folks_individual_aggregator_remove_individual()</function></link>, respectively.</para>
 *
 * Since: 0.5.1
 */
/**
 * folks_individual_aggregator_get_individuals:
 * @self: the <link linkend="FolksIndividualAggregator"><type>FolksIndividualAggregator</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksIndividualAggregator--individuals"><type>"individuals"</type></link> property.
 * 
 * A map from <link linkend="FolksIndividual--id"><type>"id"</type></link>s to their <link linkend="FolksIndividual"><type>FolksIndividual</type></link>s.
 * 
 * <para>This is the canonical set of <link linkend="FolksIndividual"><type>FolksIndividual</type></link>s provided by this IndividualAggregator.</para><para><link linkend="FolksIndividual"><type>FolksIndividual</type></link>s may be added or removed using <link linkend="folks-individual-aggregator-add-persona-from-details"><function>folks_individual_aggregator_add_persona_from_details()</function></link> and <link linkend="folks-individual-aggregator-remove-individual"><function>folks_individual_aggregator_remove_individual()</function></link>, respectively.</para>
 * 
 * Returns: the value of the <link linkend="FolksIndividualAggregator--individuals"><type>"individuals"</type></link> property
 *
 * Since: 0.5.1
 */
/**
 * FolksIndividualAggregator:user:
 * 
 * The <link linkend="FolksIndividual"><type>FolksIndividual</type></link> representing the user.
 * 
 * <para>If it exists, this holds the <link linkend="FolksIndividual"><type>FolksIndividual</type></link> who is the user: the <link linkend="FolksIndividual"><type>FolksIndividual</type></link> containing the <link linkend="FolksPersona"><type>FolksPersona</type></link>s who are the owners of the accounts for their respective backends.</para>
 *
 * Since: 0.3.0
 */
/**
 * folks_individual_aggregator_get_user:
 * @self: the <link linkend="FolksIndividualAggregator"><type>FolksIndividualAggregator</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksIndividualAggregator--user"><type>"user"</type></link> property.
 * 
 * The <link linkend="FolksIndividual"><type>FolksIndividual</type></link> representing the user.
 * 
 * <para>If it exists, this holds the <link linkend="FolksIndividual"><type>FolksIndividual</type></link> who is the user: the <link linkend="FolksIndividual"><type>FolksIndividual</type></link> containing the <link linkend="FolksPersona"><type>FolksPersona</type></link>s who are the owners of the accounts for their respective backends.</para>
 * 
 * Returns: the value of the <link linkend="FolksIndividualAggregator--user"><type>"user"</type></link> property
 *
 * Since: 0.3.0
 */
/**
 * FolksIndividualAggregator::individuals-changed:
 * @individual_aggregator: the <link linkend="FolksIndividualAggregator"><type>FolksIndividualAggregator</type></link> instance that received the signal
 * @added: &nbsp;.  <para>a list of <link linkend="FolksIndividual"><type>FolksIndividual</type></link>s which have been added </para><para></para>
 * @removed: &nbsp;.  <para>a list of <link linkend="FolksIndividual"><type>FolksIndividual</type></link>s which have been removed </para><para></para>
 * @message: &nbsp;.  <para>a string message from the backend, if any </para><para></para>
 * @actor: &nbsp;.  <para>the <link linkend="FolksPersona"><type>FolksPersona</type></link> who made the change, if known </para><para></para>
 * @reason: &nbsp;.  <para>the reason for the change </para><para></para>
 * 
 * Emitted when one or more <link linkend="FolksIndividual"><type>FolksIndividual</type></link>s are added to or removed from the aggregator.
 * 
 * <para>If more information about the relationships between <link linkend="FolksIndividual"><type>FolksIndividual</type></link>s which have been linked and unlinked is needed, consider connecting to <link linkend="FolksIndividualAggregator-individuals-changed-detailed"><type>"individuals-changed-detailed"</type></link> instead, which is emitted at the same time as this signal.</para><para>This will not be emitted until after <link linkend="folks-individual-aggregator-prepare"><function>folks_individual_aggregator_prepare()</function></link> has been called.</para>
 *
 * Since: 0.5.1
 * Deprecated: 0.6.2: Replaced by #FolksIndividualAggregator::individuals-changed-detailed.
 */
/**
 * FolksIndividualAggregator::individuals-changed-detailed:
 * @individual_aggregator: the <link linkend="FolksIndividualAggregator"><type>FolksIndividualAggregator</type></link> instance that received the signal
 * @changes: &nbsp;.  <para>a mapping of old <link linkend="FolksIndividual"><type>FolksIndividual</type></link>s to new <link linkend="FolksIndividual"><type>FolksIndividual</type></link>s for the individuals which have changed in the aggregator </para><para></para>
 * 
 * Emitted when one or more <link linkend="FolksIndividual"><type>FolksIndividual</type></link>s are added to or removed from the aggregator.
 * 
 * <para>This is emitted at the same time as <link linkend="FolksIndividualAggregator-individuals-changed"><type>"individuals-changed"</type></link>, but includes more information about the relationships between <link linkend="FolksIndividual"><type>FolksIndividual</type></link>s which have been linked and unlinked.</para><para>Individuals which have been linked will be listed in the multi-map as mappings from the old individuals to the single new individual which replaces them (i.e. each of the old individuals will map to the same new individual). This new individual is the one which will be specified as the <code>replacement_individual</code> in the <link linkend="FolksIndividual-removed"><type>"removed"</type></link> signal for the old individuals.</para><para>Individuals which have been unlinked will be listed in the multi-map as a mapping from the unlinked individual to a set of one or more individuals which replace it.</para><para>Individuals which have been added will be listed in the multi-map as a mapping from <code>null</code> to the set of added individuals. If <code>null</code> doesn&apos;t map to anything, no individuals have been added to the aggregator.</para><para>Individuals which have been removed will be listed in the multi-map as mappings from the removed individual to <code>null</code>.</para><para>This will not be emitted until after <link linkend="folks-individual-aggregator-prepare"><function>folks_individual_aggregator_prepare()</function></link> has been called.</para>
 *
 * Since: 0.6.2
 */
/**
 * folks_individual_aggregator_dup:
 * 
 * Create or return the singleton <link linkend="folks-individual-aggregator-new"><function>folks_individual_aggregator_new()</function></link> class instance. If the instance doesn&apos;t exist already, it will be created with the default <link linkend="FolksBackendStore"><type>FolksBackendStore</type></link>.
 * 
 * <para>This function is thread-safe.</para>
 * 
 * Returns: <para>Singleton <link linkend="folks-individual-aggregator-new"><function>folks_individual_aggregator_new()</function></link> instance </para>
 *
 * Since: 0.9.5
 */
/**
 * folks_individual_aggregator_dup_with_backend_store:
 * @store: (in): &nbsp;.  <para>the <link linkend="FolksBackendStore"><type>FolksBackendStore</type></link> to use instead of the default one. </para>
 * 
 * Create or return the singleton <link linkend="folks-individual-aggregator-new"><function>folks_individual_aggregator_new()</function></link> class instance with a custom <link linkend="FolksBackendStore"><type>FolksBackendStore</type></link>. If the instance doesn&apos;t exist already, it will be created with the given <link linkend="FolksBackendStore"><type>FolksBackendStore</type></link> rather than the default one. If the instance already exists but is using another <link linkend="FolksBackendStore"><type>FolksBackendStore</type></link> then a warning is raised and null is returned.
 * 
 * <para>This function is thread-safe.</para>
 * 
 * Returns: <para>Singleton <link linkend="folks-individual-aggregator-new"><function>folks_individual_aggregator_new()</function></link> instance, or null </para>
 *
 * Since: 0.9.5
 */
/**
 * FolksIndividualAggregator:
 * 
 * Stores <link linkend="FolksIndividual"><type>FolksIndividual</type></link>s which have been created through aggregation of all the <link linkend="FolksPersona"><type>FolksPersona</type></link>s provided by the various <link linkend="FolksBackend"><type>FolksBackend</type></link>s.
 * 
 * <para>This is the main interface for client applications.</para><para>Linking and unlinking of personas and individuals is performed entirely through the aggregator. Personas may be linked together to form individuals; for example, the personas which form <code>individual1</code> and <code>individual2</code> may be linked together with <code>another_persona</code> to give a new <link linkend="FolksIndividual"><type>FolksIndividual</type></link>:</para><para>
 * |[
 *   var personas = new HashSet&lt;Persona&gt; ();
 *   personas.add_all (individual1.personas);
 *   personas.add_all (individual2.personas);
 *   personas.add (another_persona);
 *   yield my_individual_aggregator.link_personas (personas);
 * ]|
 * </para><para>The individuals which contained those personas will be removed when <link linkend="folks-individual-aggregator-link-personas"><function>folks_individual_aggregator_link_personas()</function></link> is called. Any personas in those individuals which were not included in the linking call may end up implicitly linked to the new individual, or may be aggregated into other new individuals.</para><para>For example, consider the situation where <code>individual1</code> contains two personas, <code>persona1A</code> and <code>persona1B</code>; <code>individual2</code> contains one persona, <code>persona2A</code>; and <code>another_persona</code> comes from <code>individual3</code>, which also contains <code>persona3A</code> and <code>persona3B</code>. Calling <link linkend="folks-individual-aggregator-link-personas"><function>folks_individual_aggregator_link_personas()</function></link> on <code>persona1A</code>, <code>persona1B</code>, <code>persona2A</code> and <code>another_persona</code> will result in <code>individual1</code> and <code>individual2</code> being removed. A new <link linkend="FolksIndividual"><type>FolksIndividual</type></link> will be created containing all the personas passed to the linking function. It might also contain <code>persona3A</code> and <code>persona3B</code>; or they might be in one or two other new individuals.</para><para>An existing individual may be unlinked to form singleton individuals for each of its personas: 
 * |[
 *   yield my_individual_aggregator.unlink_individual (my_individual);
 * ]|
 * </para><para>Note that to link two individuals together, their two sets of personas must be linked together. There is no API to directly link the individuals themselves, as conceptually folks links <link linkend="FolksPersona"><type>FolksPersona</type></link>s, not <link linkend="FolksIndividual"><type>FolksIndividual</type></link>s.</para><para>Folks does not support having more than one IndividualAggregator instantiated at the same time. Most clients should use <link linkend="folks-individual-aggregator-dup"><function>folks_individual_aggregator_dup()</function></link> to retrieve the IndividualAggregator singleton.</para>
 */
/**
 * FolksIndividualAggregatorClass:
 * @parent_class: the parent class structure
 * 
 * The class structure for <link linkend="FOLKS-TYPE-INDIVIDUAL-AGGREGATOR:CAPS"><literal>FOLKS_TYPE_INDIVIDUAL_AGGREGATOR</literal></link>. All the fields in this structure are private and should never be accessed directly.
 */
/**
 * FolksIndividualAggregatorError:
 * @FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_ADD_FAILED: Adding a <link linkend="FolksPersona"><type>FolksPersona</type></link> to a <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> failed.
 * @FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_NO_WRITEABLE_STORE: An operation which required the use of a writeable store failed because no writeable store was available.
 * @FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_STORE_OFFLINE: The <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> was offline (ie, this is a temporary failure).
 * @FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_PROPERTY_NOT_WRITEABLE: The <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> did not support writing to a property which the user requested to write to, or which was necessary to write to for storing linking information.
 * @FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_NO_PRIMARY_STORE: An operation which required the use of a primary store failed because no primary store was available.
 * 
 * Errors from <link linkend="FolksIndividualAggregator"><type>FolksIndividualAggregator</type></link>s.
 */
