/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.spi.v1;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

class LoggingInterceptor
implements ClientInterceptor {
    private final Logger logger;
    private final Level level;

    LoggingInterceptor(Logger logger, Level level) {
        this.logger = logger;
        this.level = level;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        if (!this.logger.isLoggable(this.level)) {
            return next.newCall(method, callOptions);
        }
        final CallLogger callLogger = new CallLogger(method);
        callLogger.log("Start");
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                super.start((ClientCall.Listener)new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                    public void onMessage(RespT message) {
                        callLogger.logfmt("Received:\n%s", message);
                        super.onMessage(message);
                    }

                    public void onClose(Status status, Metadata trailers) {
                        callLogger.logfmt("Closed with status %s and trailers %s", status, trailers);
                        super.onClose(status, trailers);
                    }
                }, headers);
            }

            public void sendMessage(ReqT message) {
                callLogger.logfmt("Send:\n%s", message);
                super.sendMessage(message);
            }

            public void cancel(@Nullable String message, @Nullable Throwable cause) {
                callLogger.logfmt("Cancelled with message %s", message);
                super.cancel(message, cause);
            }
        };
    }

    private class CallLogger {
        private final MethodDescriptor<?, ?> method;

        CallLogger(MethodDescriptor<?, ?> method) {
            this.method = method;
        }

        void log(String message) {
            LoggingInterceptor.this.logger.log(LoggingInterceptor.this.level, "{0}[{1}]: {2}", new Object[]{this.method.getFullMethodName(), Integer.toHexString(System.identityHashCode(this)), message});
        }

        void logfmt(String message, Object ... params) {
            this.log(String.format(message, params));
        }
    }
}

