/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.verb.migrate.migrators;

import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import org.flywaydb.core.ProgressLogger;
import org.flywaydb.core.api.LoadableMigrationInfo;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.MigrationState;
import org.flywaydb.core.api.callback.Event;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.output.CommandResultFactory;
import org.flywaydb.core.api.output.MigrateResult;
import org.flywaydb.core.api.resource.LoadableResource;
import org.flywaydb.core.experimental.ExperimentalDatabase;
import org.flywaydb.core.internal.exception.FlywayMigrateException;
import org.flywaydb.core.internal.parser.ParsingContext;
import org.flywaydb.core.internal.util.FileUtils;
import org.flywaydb.core.internal.util.StopWatch;
import org.flywaydb.nc.callbacks.CallbackManager;
import org.flywaydb.nc.executors.Executor;
import org.flywaydb.nc.executors.ExecutorFactory;
import org.flywaydb.nc.executors.NonJdbcExecutorExecutionUnit;
import org.flywaydb.nc.readers.Reader;
import org.flywaydb.nc.readers.ReaderFactory;
import org.flywaydb.nc.utils.ErrorUtils;
import org.flywaydb.nc.utils.VerbUtils;
import org.flywaydb.verb.migrate.MigrationExecutionGroup;
import org.flywaydb.verb.migrate.migrators.Migrator;

public class ExecutableMigrator
extends Migrator {
    private static final Log LOG = LogFactory.getLog(ExecutableMigrator.class);

    @Override
    public List<MigrationExecutionGroup> createGroups(MigrationInfo[] allPendingMigrations, Configuration configuration, ExperimentalDatabase experimentalDatabase, MigrateResult migrateResult, ParsingContext parsingContext) {
        return Arrays.stream(allPendingMigrations).map(x -> new MigrationExecutionGroup(List.of(x), true)).toList();
    }

    @Override
    public int doExecutionGroup(Configuration configuration, MigrationExecutionGroup executionGroup, ExperimentalDatabase experimentalDatabase, MigrateResult migrateResult, ParsingContext parsingContext, int installedRank, CallbackManager callbackManager, ProgressLogger progress) {
        boolean executeInTransaction;
        boolean bl = executeInTransaction = configuration.isExecuteInTransaction() && executionGroup.shouldExecuteInTransaction();
        if (executeInTransaction) {
            experimentalDatabase.startTransaction();
        }
        this.doIndividualMigration(executionGroup.migrations().get(0), experimentalDatabase, configuration, migrateResult, installedRank, parsingContext, callbackManager, progress);
        return installedRank + 1;
    }

    private void doIndividualMigration(MigrationInfo migrationInfo, ExperimentalDatabase experimentalDatabase, Configuration configuration, MigrateResult migrateResult, int installedRank, ParsingContext parsingContext, CallbackManager callbackManager, ProgressLogger progress) {
        StopWatch watch = new StopWatch();
        watch.start();
        boolean outOfOrder = migrationInfo.getState() == MigrationState.OUT_OF_ORDER && configuration.isOutOfOrder();
        String migrationText = VerbUtils.toMigrationText((MigrationInfo)migrationInfo, (boolean)false, (ExperimentalDatabase)experimentalDatabase, (boolean)outOfOrder);
        Executor executor = ExecutorFactory.getExecutor((ExperimentalDatabase)experimentalDatabase, (Configuration)configuration);
        Reader reader = ReaderFactory.getReader((ExperimentalDatabase)experimentalDatabase, (Configuration)configuration);
        try {
            if (configuration.isSkipExecutingMigrations()) {
                LOG.debug("Skipping execution of migration of " + migrationText);
                progress.log("Skipping migration of " + migrationInfo.getScript());
            } else {
                LOG.debug("Starting migration of " + migrationText + " ...");
                progress.log("Starting migration of " + migrationInfo.getScript() + " ...");
                if (!migrationInfo.getType().isUndo()) {
                    callbackManager.handleEvent(Event.BEFORE_EACH_MIGRATE, experimentalDatabase, configuration, parsingContext);
                }
                if (!migrationInfo.getType().isUndo()) {
                    LOG.info("Migrating " + migrationText);
                    progress.log("Migrating " + migrationInfo.getScript());
                } else {
                    LOG.info("Undoing migration of " + migrationText);
                }
                if (migrationInfo instanceof LoadableMigrationInfo) {
                    LoadableMigrationInfo loadableMigrationInfo = (LoadableMigrationInfo)migrationInfo;
                    NonJdbcExecutorExecutionUnit nonJdbcExecutorExecutionUnit = new NonJdbcExecutorExecutionUnit((String)reader.read(configuration, experimentalDatabase, parsingContext, loadableMigrationInfo.getLoadableResource(), null).findFirst().get(), FileUtils.getParentDir((String)loadableMigrationInfo.getLoadableResource().getAbsolutePath()));
                    executor.execute(experimentalDatabase, (Object)nonJdbcExecutorExecutionUnit, configuration);
                    executor.finishExecution(experimentalDatabase, configuration);
                }
                if (!migrationInfo.getType().isUndo()) {
                    callbackManager.handleEvent(Event.AFTER_EACH_MIGRATE, experimentalDatabase, configuration, parsingContext);
                }
            }
        }
        catch (Exception e) {
            watch.stop();
            int totalTimeMillis = (int)watch.getTotalTimeMillis();
            this.handleMigrationError(e, experimentalDatabase, migrationInfo, migrateResult, configuration.getTable(), configuration.isOutOfOrder(), installedRank, experimentalDatabase.getInstalledBy(configuration), totalTimeMillis);
        }
        watch.stop();
        progress.log("Successfully completed migration of " + migrationInfo.getScript());
        ++migrateResult.migrationsExecuted;
        int totalTimeMillis = (int)watch.getTotalTimeMillis();
        migrateResult.putSuccessfulMigration(migrationInfo, totalTimeMillis);
        if (migrationInfo.isVersioned()) {
            migrateResult.targetSchemaVersion = migrationInfo.getVersion().getVersion();
        }
        migrateResult.migrations.add(CommandResultFactory.createMigrateOutput((MigrationInfo)migrationInfo, (int)totalTimeMillis, null));
        ExecutableMigrator.updateSchemaHistoryTable(configuration.getTable(), migrationInfo, totalTimeMillis, installedRank, experimentalDatabase, experimentalDatabase.getInstalledBy(configuration), true);
    }

    private void handleMigrationError(Exception e, ExperimentalDatabase experimentalDatabase, MigrationInfo migrationInfo, MigrateResult migrateResult, String schemaHistoryTableName, boolean outOfOrder, int installedRank, String installedBy, int totalTimeMillis) {
        String migrationText = VerbUtils.toMigrationText((MigrationInfo)migrationInfo, (boolean)false, (ExperimentalDatabase)experimentalDatabase, (boolean)outOfOrder);
        String failedMsg = !migrationInfo.getType().isUndo() ? "Migration of " + migrationText + " failed!" : "Undo of migration of " + migrationText + " failed!";
        migrateResult.putFailedMigration(migrationInfo, totalTimeMillis);
        migrateResult.setSuccess(false);
        LOG.error(failedMsg + " Please restore backups and roll back database and code!");
        ExecutableMigrator.updateSchemaHistoryTable(schemaHistoryTableName, migrationInfo, totalTimeMillis, installedRank, experimentalDatabase, installedBy, false);
        String message = experimentalDatabase.redactUrl(e.getMessage());
        throw new FlywayMigrateException(migrationInfo, this.calculateErrorMessage(message, migrationInfo), true, migrateResult);
    }

    private String calculateErrorMessage(String message, MigrationInfo migrationInfo) {
        String title = "Script " + String.valueOf(Paths.get(migrationInfo.getScript(), new String[0]).getFileName()) + " failed";
        LoadableResource loadableResource = null;
        if (migrationInfo instanceof LoadableMigrationInfo) {
            LoadableMigrationInfo loadableMigrationInfo = (LoadableMigrationInfo)migrationInfo;
            loadableResource = loadableMigrationInfo.getLoadableResource();
        }
        return ErrorUtils.calculateErrorMessage((String)title, (LoadableResource)loadableResource, (String)migrationInfo.getPhysicalLocation(), null, null, (String)("Message    : " + message + "\n"));
    }
}

