/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.scanners;

import java.util.List;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.resource.ResourceName;
import org.flywaydb.core.internal.util.Pair;
import org.flywaydb.core.internal.util.StringUtils;

public class ScannerUtils {
    private static final Log LOG = LogFactory.getLog(ScannerUtils.class);

    public static void validateMigrationNaming(List<Pair<String, ResourceName>> resources, boolean validateMigrationNaming, String ... sqlMigrationSuffixes) {
        List<String> validErrors = resources.stream().filter(pair -> !((ResourceName)pair.getRight()).isValid()).filter(pair -> StringUtils.startsAndEndsWith((String)((String)pair.getLeft()), (String)"", (String[])sqlMigrationSuffixes)).map(pair -> ((ResourceName)pair.getRight()).getValidityMessage()).toList();
        if (!validErrors.isEmpty()) {
            if (validateMigrationNaming) {
                throw new FlywayException("Invalid SQL filenames found:\r\n" + StringUtils.collectionToDelimitedString(validErrors, (String)"\r\n"));
            }
            LOG.info(validErrors.size() + " SQL migrations were detected but not run because they did not follow the filename convention.");
            LOG.info("Set 'validateMigrationNaming' to true to fail fast and see a list of the invalid file names.");
        }
    }

    private ScannerUtils() {
    }
}

