/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Enum Utility Definitions                                                   *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|* From: CUFAttr.td                                                           *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

namespace cuf {
::llvm::StringRef stringifyDataAttribute(DataAttribute val) {
  switch (val) {
    case DataAttribute::Constant: return "constant";
    case DataAttribute::Device: return "device";
    case DataAttribute::Managed: return "managed";
    case DataAttribute::Pinned: return "pinned";
    case DataAttribute::Shared: return "shared";
    case DataAttribute::Unified: return "unified";
  }
  return "";
}

::std::optional<DataAttribute> symbolizeDataAttribute(::llvm::StringRef str) {
  return ::llvm::StringSwitch<::std::optional<DataAttribute>>(str)
      .Case("constant", DataAttribute::Constant)
      .Case("device", DataAttribute::Device)
      .Case("managed", DataAttribute::Managed)
      .Case("pinned", DataAttribute::Pinned)
      .Case("shared", DataAttribute::Shared)
      .Case("unified", DataAttribute::Unified)
      .Default(::std::nullopt);
}
::std::optional<DataAttribute> symbolizeDataAttribute(uint32_t value) {
  switch (value) {
  case 0: return DataAttribute::Constant;
  case 1: return DataAttribute::Device;
  case 2: return DataAttribute::Managed;
  case 3: return DataAttribute::Pinned;
  case 4: return DataAttribute::Shared;
  case 5: return DataAttribute::Unified;
  default: return ::std::nullopt;
  }
}

} // namespace cuf

namespace cuf {
::llvm::StringRef stringifyDataTransferKind(DataTransferKind val) {
  switch (val) {
    case DataTransferKind::DeviceHost: return "device_host";
    case DataTransferKind::HostDevice: return "host_device";
    case DataTransferKind::DeviceDevice: return "device_device";
  }
  return "";
}

::std::optional<DataTransferKind> symbolizeDataTransferKind(::llvm::StringRef str) {
  return ::llvm::StringSwitch<::std::optional<DataTransferKind>>(str)
      .Case("device_host", DataTransferKind::DeviceHost)
      .Case("host_device", DataTransferKind::HostDevice)
      .Case("device_device", DataTransferKind::DeviceDevice)
      .Default(::std::nullopt);
}
::std::optional<DataTransferKind> symbolizeDataTransferKind(uint32_t value) {
  switch (value) {
  case 0: return DataTransferKind::DeviceHost;
  case 1: return DataTransferKind::HostDevice;
  case 2: return DataTransferKind::DeviceDevice;
  default: return ::std::nullopt;
  }
}

} // namespace cuf

namespace cuf {
::llvm::StringRef stringifyProcAttribute(ProcAttribute val) {
  switch (val) {
    case ProcAttribute::Host: return "host";
    case ProcAttribute::Device: return "device";
    case ProcAttribute::HostDevice: return "host_device";
    case ProcAttribute::Global: return "global";
    case ProcAttribute::GridGlobal: return "grid_global";
  }
  return "";
}

::std::optional<ProcAttribute> symbolizeProcAttribute(::llvm::StringRef str) {
  return ::llvm::StringSwitch<::std::optional<ProcAttribute>>(str)
      .Case("host", ProcAttribute::Host)
      .Case("device", ProcAttribute::Device)
      .Case("host_device", ProcAttribute::HostDevice)
      .Case("global", ProcAttribute::Global)
      .Case("grid_global", ProcAttribute::GridGlobal)
      .Default(::std::nullopt);
}
::std::optional<ProcAttribute> symbolizeProcAttribute(uint32_t value) {
  switch (value) {
  case 0: return ProcAttribute::Host;
  case 1: return ProcAttribute::Device;
  case 2: return ProcAttribute::HostDevice;
  case 3: return ProcAttribute::Global;
  case 4: return ProcAttribute::GridGlobal;
  default: return ::std::nullopt;
  }
}

} // namespace cuf

