/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Op Definitions                                                             *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_OP_LIST
#undef GET_OP_LIST

::fir::cg::XArrayCoorOp,
::fir::cg::XEmboxOp,
::fir::cg::XReboxOp
#endif  // GET_OP_LIST

#ifdef GET_OP_CLASSES
#undef GET_OP_CLASSES


//===----------------------------------------------------------------------===//
// Local Utility Method Definitions
//===----------------------------------------------------------------------===//

namespace fir {
namespace cg {

static ::mlir::LogicalResult __mlir_ods_local_type_constraint_CGOps0(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!(((type.isa<::fir::ReferenceType>())) || ((type.isa<::fir::HeapType>())) || ((type.isa<::fir::PointerType>())) || ((type.isa<::fir::BoxType>())))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be any reference or box, but got " << type;
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_type_constraint_CGOps1(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((((type.isSignlessIntOrIndex())) || ((((type.isa<::mlir::VectorType>())) && ((type.cast<::mlir::VectorType>().getRank() > 0))) && ([](::mlir::Type elementType) { return (elementType.isSignlessIntOrIndex()); }(type.cast<::mlir::ShapedType>().getElementType()))) || (((type.isa<::mlir::TensorType>())) && ([](::mlir::Type elementType) { return (elementType.isSignlessIntOrIndex()); }(type.cast<::mlir::ShapedType>().getElementType())))) || ((type.isSignedInteger())) || ((type.isa<::fir::IntegerType>())))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be any integer, but got " << type;
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_type_constraint_CGOps2(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!(((type.isSignlessInteger())) || ((type.isa<::mlir::IndexType>())) || ((type.isa<::fir::IntegerType>())) || ((type.isa<::fir::FieldType>())) || ((type.isa<::fir::LenType>())))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be coordinate type, but got " << type;
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_type_constraint_CGOps3(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((type.isa<::fir::ReferenceType>()))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be Reference to an entity type, but got " << type;
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_type_constraint_CGOps4(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!(((type.isa<::fir::ReferenceType>())) || ((type.isa<::fir::HeapType>())) || ((type.isa<::fir::PointerType>())) || ((type.isa<::fir::LLVMPointerType>())))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be any reference, but got " << type;
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_type_constraint_CGOps5(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((type.isa<::fir::BoxType>()))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be The type of a Fortran descriptor, but got " << type;
  }
  return ::mlir::success();
}
} // namespace cg
} // namespace fir
namespace fir {
namespace cg {

//===----------------------------------------------------------------------===//
// ::fir::cg::XArrayCoorOp definitions
//===----------------------------------------------------------------------===//

XArrayCoorOpAdaptor::XArrayCoorOpAdaptor(::mlir::ValueRange values, ::mlir::DictionaryAttr attrs, ::mlir::RegionRange regions) : odsOperands(values), odsAttrs(attrs), odsRegions(regions) {}

XArrayCoorOpAdaptor::XArrayCoorOpAdaptor(XArrayCoorOp &op) : odsOperands(op->getOperands()), odsAttrs(op->getAttrDictionary()), odsRegions(op->getRegions()) {}

::mlir::ValueRange XArrayCoorOpAdaptor::getOperands() {
  return odsOperands;
}

std::pair<unsigned, unsigned> XArrayCoorOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  assert(odsAttrs && "missing segment size attribute for op");
  auto sizeAttr = odsAttrs.get("operand_segment_sizes").cast<::mlir::DenseIntElementsAttr>();

  const uint32_t *sizeAttrValueIt = &*sizeAttr.value_begin<uint32_t>();
  if (sizeAttr.isSplat())
    return {*sizeAttrValueIt * index, *sizeAttrValueIt};

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttrValueIt[i];
  return {start, sizeAttrValueIt[index]};
}

::mlir::ValueRange XArrayCoorOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

::mlir::Value XArrayCoorOpAdaptor::memref() {
  return *getODSOperands(0).begin();
}

::mlir::ValueRange XArrayCoorOpAdaptor::shape() {
  return getODSOperands(1);
}

::mlir::ValueRange XArrayCoorOpAdaptor::shift() {
  return getODSOperands(2);
}

::mlir::ValueRange XArrayCoorOpAdaptor::slice() {
  return getODSOperands(3);
}

::mlir::ValueRange XArrayCoorOpAdaptor::subcomponent() {
  return getODSOperands(4);
}

::mlir::ValueRange XArrayCoorOpAdaptor::indices() {
  return getODSOperands(5);
}

::mlir::ValueRange XArrayCoorOpAdaptor::lenParams() {
  return getODSOperands(6);
}

::mlir::DictionaryAttr XArrayCoorOpAdaptor::getAttributes() {
  return odsAttrs;
}

::mlir::LogicalResult XArrayCoorOpAdaptor::verify(::mlir::Location loc) {
  {
    auto sizeAttr = odsAttrs.get("operand_segment_sizes").dyn_cast<::mlir::DenseIntElementsAttr>();
    if (!sizeAttr)
      return emitError(loc, "'fircg.ext_array_coor' op ""missing segment sizes attribute 'operand_segment_sizes'");
    auto numElements =
        sizeAttr.getType().cast<::mlir::ShapedType>().getNumElements();
    if (numElements != 7)
      return emitError(loc, "'fircg.ext_array_coor' op ""'operand_segment_sizes' attribute for specifying operand segments must have 7 "
                "elements, but got ") << numElements;
  }
    return ::mlir::success();
}

std::pair<unsigned, unsigned> XArrayCoorOp::getODSOperandIndexAndLength(unsigned index) {
  auto sizeAttr =
      (*this)->getAttr(operand_segment_sizesAttrName()).cast<::mlir::DenseIntElementsAttr>();

  const uint32_t *sizeAttrValueIt = &*sizeAttr.value_begin<uint32_t>();
  if (sizeAttr.isSplat())
    return {*sizeAttrValueIt * index, *sizeAttrValueIt};

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttrValueIt[i];
  return {start, sizeAttrValueIt[index]};
}

::mlir::Operation::operand_range XArrayCoorOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value XArrayCoorOp::memref() {
  return *getODSOperands(0).begin();
}

::mlir::Operation::operand_range XArrayCoorOp::shape() {
  return getODSOperands(1);
}

::mlir::Operation::operand_range XArrayCoorOp::shift() {
  return getODSOperands(2);
}

::mlir::Operation::operand_range XArrayCoorOp::slice() {
  return getODSOperands(3);
}

::mlir::Operation::operand_range XArrayCoorOp::subcomponent() {
  return getODSOperands(4);
}

::mlir::Operation::operand_range XArrayCoorOp::indices() {
  return getODSOperands(5);
}

::mlir::Operation::operand_range XArrayCoorOp::lenParams() {
  return getODSOperands(6);
}

::mlir::MutableOperandRange XArrayCoorOp::memrefMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(0u, *getOperation()->getAttrDictionary().getNamed(operand_segment_sizesAttrName())));
  return mutableRange;
}

::mlir::MutableOperandRange XArrayCoorOp::shapeMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(1u, *getOperation()->getAttrDictionary().getNamed(operand_segment_sizesAttrName())));
  return mutableRange;
}

::mlir::MutableOperandRange XArrayCoorOp::shiftMutable() {
  auto range = getODSOperandIndexAndLength(2);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(2u, *getOperation()->getAttrDictionary().getNamed(operand_segment_sizesAttrName())));
  return mutableRange;
}

::mlir::MutableOperandRange XArrayCoorOp::sliceMutable() {
  auto range = getODSOperandIndexAndLength(3);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(3u, *getOperation()->getAttrDictionary().getNamed(operand_segment_sizesAttrName())));
  return mutableRange;
}

::mlir::MutableOperandRange XArrayCoorOp::subcomponentMutable() {
  auto range = getODSOperandIndexAndLength(4);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(4u, *getOperation()->getAttrDictionary().getNamed(operand_segment_sizesAttrName())));
  return mutableRange;
}

::mlir::MutableOperandRange XArrayCoorOp::indicesMutable() {
  auto range = getODSOperandIndexAndLength(5);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(5u, *getOperation()->getAttrDictionary().getNamed(operand_segment_sizesAttrName())));
  return mutableRange;
}

::mlir::MutableOperandRange XArrayCoorOp::lenParamsMutable() {
  auto range = getODSOperandIndexAndLength(6);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(6u, *getOperation()->getAttrDictionary().getNamed(operand_segment_sizesAttrName())));
  return mutableRange;
}

std::pair<unsigned, unsigned> XArrayCoorOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range XArrayCoorOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

void XArrayCoorOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value memref, ::mlir::ValueRange shape, ::mlir::ValueRange shift, ::mlir::ValueRange slice, ::mlir::ValueRange subcomponent, ::mlir::ValueRange indices, ::mlir::ValueRange lenParams) {
  odsState.addOperands(memref);
  odsState.addOperands(shape);
  odsState.addOperands(shift);
  odsState.addOperands(slice);
  odsState.addOperands(subcomponent);
  odsState.addOperands(indices);
  odsState.addOperands(lenParams);
  odsState.addAttribute(operand_segment_sizesAttrName(odsState.name), odsBuilder.getI32VectorAttr({1, static_cast<int32_t>(shape.size()), static_cast<int32_t>(shift.size()), static_cast<int32_t>(slice.size()), static_cast<int32_t>(subcomponent.size()), static_cast<int32_t>(indices.size()), static_cast<int32_t>(lenParams.size())}));
  odsState.addTypes(resultType0);
}

void XArrayCoorOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value memref, ::mlir::ValueRange shape, ::mlir::ValueRange shift, ::mlir::ValueRange slice, ::mlir::ValueRange subcomponent, ::mlir::ValueRange indices, ::mlir::ValueRange lenParams) {
  odsState.addOperands(memref);
  odsState.addOperands(shape);
  odsState.addOperands(shift);
  odsState.addOperands(slice);
  odsState.addOperands(subcomponent);
  odsState.addOperands(indices);
  odsState.addOperands(lenParams);
  odsState.addAttribute(operand_segment_sizesAttrName(odsState.name), odsBuilder.getI32VectorAttr({1, static_cast<int32_t>(shape.size()), static_cast<int32_t>(shift.size()), static_cast<int32_t>(slice.size()), static_cast<int32_t>(subcomponent.size()), static_cast<int32_t>(indices.size()), static_cast<int32_t>(lenParams.size())}));
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void XArrayCoorOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult XArrayCoorOp::verify() {
  {
    auto sizeAttr = (*this)->getAttr(operand_segment_sizesAttrName()).dyn_cast<::mlir::DenseIntElementsAttr>();
    if (!sizeAttr)
      return emitOpError("missing segment sizes attribute 'operand_segment_sizes'");
    auto numElements =
        sizeAttr.getType().cast<::mlir::ShapedType>().getNumElements();
    if (numElements != 7)
      return emitOpError("'operand_segment_sizes' attribute for specifying operand segments must have 7 "
                "elements, but got ") << numElements;
  }
    {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_CGOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_CGOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_CGOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup3 = getODSOperands(3);

    for (auto v : valueGroup3) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_CGOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup4 = getODSOperands(4);

    for (auto v : valueGroup4) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_CGOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup5 = getODSOperands(5);

    for (auto v : valueGroup5) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_CGOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup6 = getODSOperands(6);

    for (auto v : valueGroup6) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_CGOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_CGOps3(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::ParseResult XArrayCoorOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::OperandType memrefRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::OperandType> memrefOperands(memrefRawOperands);  ::llvm::SMLoc memrefOperandsLoc;
  (void)memrefOperandsLoc;
  ::mlir::SmallVector<::mlir::OpAsmParser::OperandType, 4> shapeOperands;
  ::llvm::SMLoc shapeOperandsLoc;
  (void)shapeOperandsLoc;
  ::mlir::SmallVector<::mlir::OpAsmParser::OperandType, 4> shiftOperands;
  ::llvm::SMLoc shiftOperandsLoc;
  (void)shiftOperandsLoc;
  ::mlir::SmallVector<::mlir::OpAsmParser::OperandType, 4> sliceOperands;
  ::llvm::SMLoc sliceOperandsLoc;
  (void)sliceOperandsLoc;
  ::mlir::SmallVector<::mlir::OpAsmParser::OperandType, 4> subcomponentOperands;
  ::llvm::SMLoc subcomponentOperandsLoc;
  (void)subcomponentOperandsLoc;
  ::mlir::SmallVector<::mlir::OpAsmParser::OperandType, 4> indicesOperands;
  ::llvm::SMLoc indicesOperandsLoc;
  (void)indicesOperandsLoc;
  ::mlir::SmallVector<::mlir::OpAsmParser::OperandType, 4> lenParamsOperands;
  ::llvm::SMLoc lenParamsOperandsLoc;
  (void)lenParamsOperandsLoc;
  ::llvm::ArrayRef<::mlir::Type> allOperandTypes;
  ::llvm::ArrayRef<::mlir::Type> allResultTypes;

  memrefOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(memrefRawOperands[0]))
    return ::mlir::failure();
  if (succeeded(parser.parseOptionalLParen())) {

  shapeOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(shapeOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
  }
  if (succeeded(parser.parseOptionalKeyword("origin"))) {

  shiftOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(shiftOperands))
    return ::mlir::failure();
  }
  if (succeeded(parser.parseOptionalLSquare())) {

  sliceOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(sliceOperands))
    return ::mlir::failure();
  if (parser.parseRSquare())
    return ::mlir::failure();
  }
  if (succeeded(parser.parseOptionalKeyword("path"))) {

  subcomponentOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(subcomponentOperands))
    return ::mlir::failure();
  }
  if (parser.parseLess())
    return ::mlir::failure();

  indicesOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(indicesOperands))
    return ::mlir::failure();
  if (parser.parseGreater())
    return ::mlir::failure();
  if (succeeded(parser.parseOptionalKeyword("typeparams"))) {

  lenParamsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(lenParamsOperands))
    return ::mlir::failure();
  }
  if (parser.parseOptionalAttrDict(result.attributes))
    return ::mlir::failure();
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType allOperand__allResult_functionType;
  if (parser.parseType(allOperand__allResult_functionType))
    return ::mlir::failure();
  allOperandTypes = allOperand__allResult_functionType.getInputs();
  allResultTypes = allOperand__allResult_functionType.getResults();
  result.addAttribute("operand_segment_sizes", parser.getBuilder().getI32VectorAttr({1, static_cast<int32_t>(shapeOperands.size()), static_cast<int32_t>(shiftOperands.size()), static_cast<int32_t>(sliceOperands.size()), static_cast<int32_t>(subcomponentOperands.size()), static_cast<int32_t>(indicesOperands.size()), static_cast<int32_t>(lenParamsOperands.size())}));
  result.addTypes(allResultTypes);
  if (parser.resolveOperands(::llvm::concat<const ::mlir::OpAsmParser::OperandType>(memrefOperands, shapeOperands, shiftOperands, sliceOperands, subcomponentOperands, indicesOperands, lenParamsOperands), allOperandTypes, parser.getNameLoc(), result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void XArrayCoorOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << memref();
  if (!shape().empty()) {
  _odsPrinter << "(";
  _odsPrinter << shape();
  _odsPrinter << ")";
  }
  if (!shift().empty()) {
  _odsPrinter << ' ' << "origin";
  _odsPrinter << ' ';
  _odsPrinter << shift();
  }
  if (!slice().empty()) {
  _odsPrinter << "[";
  _odsPrinter << slice();
  _odsPrinter << "]";
  }
  if (!subcomponent().empty()) {
  _odsPrinter << ' ' << "path";
  _odsPrinter << ' ';
  _odsPrinter << subcomponent();
  }
  _odsPrinter << "<";
  _odsPrinter << indices();
  _odsPrinter << ">";
  if (!lenParams().empty()) {
  _odsPrinter << ' ' << "typeparams";
  _odsPrinter << ' ';
  _odsPrinter << lenParams();
  }
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), /*elidedAttrs=*/{"operand_segment_sizes", });
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(getOperation()->getOperandTypes(), getOperation()->getResultTypes());
}

} // namespace cg
} // namespace fir
DEFINE_EXPLICIT_TYPE_ID(::fir::cg::XArrayCoorOp)

namespace fir {
namespace cg {

//===----------------------------------------------------------------------===//
// ::fir::cg::XEmboxOp definitions
//===----------------------------------------------------------------------===//

XEmboxOpAdaptor::XEmboxOpAdaptor(::mlir::ValueRange values, ::mlir::DictionaryAttr attrs, ::mlir::RegionRange regions) : odsOperands(values), odsAttrs(attrs), odsRegions(regions) {}

XEmboxOpAdaptor::XEmboxOpAdaptor(XEmboxOp &op) : odsOperands(op->getOperands()), odsAttrs(op->getAttrDictionary()), odsRegions(op->getRegions()) {}

::mlir::ValueRange XEmboxOpAdaptor::getOperands() {
  return odsOperands;
}

std::pair<unsigned, unsigned> XEmboxOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  assert(odsAttrs && "missing segment size attribute for op");
  auto sizeAttr = odsAttrs.get("operand_segment_sizes").cast<::mlir::DenseIntElementsAttr>();

  const uint32_t *sizeAttrValueIt = &*sizeAttr.value_begin<uint32_t>();
  if (sizeAttr.isSplat())
    return {*sizeAttrValueIt * index, *sizeAttrValueIt};

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttrValueIt[i];
  return {start, sizeAttrValueIt[index]};
}

::mlir::ValueRange XEmboxOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

::mlir::Value XEmboxOpAdaptor::memref() {
  return *getODSOperands(0).begin();
}

::mlir::ValueRange XEmboxOpAdaptor::shape() {
  return getODSOperands(1);
}

::mlir::ValueRange XEmboxOpAdaptor::shift() {
  return getODSOperands(2);
}

::mlir::ValueRange XEmboxOpAdaptor::slice() {
  return getODSOperands(3);
}

::mlir::ValueRange XEmboxOpAdaptor::subcomponent() {
  return getODSOperands(4);
}

::mlir::ValueRange XEmboxOpAdaptor::substr() {
  return getODSOperands(5);
}

::mlir::ValueRange XEmboxOpAdaptor::lenParams() {
  return getODSOperands(6);
}

::mlir::DictionaryAttr XEmboxOpAdaptor::getAttributes() {
  return odsAttrs;
}

::mlir::LogicalResult XEmboxOpAdaptor::verify(::mlir::Location loc) {
  {
    auto sizeAttr = odsAttrs.get("operand_segment_sizes").dyn_cast<::mlir::DenseIntElementsAttr>();
    if (!sizeAttr)
      return emitError(loc, "'fircg.ext_embox' op ""missing segment sizes attribute 'operand_segment_sizes'");
    auto numElements =
        sizeAttr.getType().cast<::mlir::ShapedType>().getNumElements();
    if (numElements != 7)
      return emitError(loc, "'fircg.ext_embox' op ""'operand_segment_sizes' attribute for specifying operand segments must have 7 "
                "elements, but got ") << numElements;
  }
    return ::mlir::success();
}

std::pair<unsigned, unsigned> XEmboxOp::getODSOperandIndexAndLength(unsigned index) {
  auto sizeAttr =
      (*this)->getAttr(operand_segment_sizesAttrName()).cast<::mlir::DenseIntElementsAttr>();

  const uint32_t *sizeAttrValueIt = &*sizeAttr.value_begin<uint32_t>();
  if (sizeAttr.isSplat())
    return {*sizeAttrValueIt * index, *sizeAttrValueIt};

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttrValueIt[i];
  return {start, sizeAttrValueIt[index]};
}

::mlir::Operation::operand_range XEmboxOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value XEmboxOp::memref() {
  return *getODSOperands(0).begin();
}

::mlir::Operation::operand_range XEmboxOp::shape() {
  return getODSOperands(1);
}

::mlir::Operation::operand_range XEmboxOp::shift() {
  return getODSOperands(2);
}

::mlir::Operation::operand_range XEmboxOp::slice() {
  return getODSOperands(3);
}

::mlir::Operation::operand_range XEmboxOp::subcomponent() {
  return getODSOperands(4);
}

::mlir::Operation::operand_range XEmboxOp::substr() {
  return getODSOperands(5);
}

::mlir::Operation::operand_range XEmboxOp::lenParams() {
  return getODSOperands(6);
}

::mlir::MutableOperandRange XEmboxOp::memrefMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(0u, *getOperation()->getAttrDictionary().getNamed(operand_segment_sizesAttrName())));
  return mutableRange;
}

::mlir::MutableOperandRange XEmboxOp::shapeMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(1u, *getOperation()->getAttrDictionary().getNamed(operand_segment_sizesAttrName())));
  return mutableRange;
}

::mlir::MutableOperandRange XEmboxOp::shiftMutable() {
  auto range = getODSOperandIndexAndLength(2);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(2u, *getOperation()->getAttrDictionary().getNamed(operand_segment_sizesAttrName())));
  return mutableRange;
}

::mlir::MutableOperandRange XEmboxOp::sliceMutable() {
  auto range = getODSOperandIndexAndLength(3);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(3u, *getOperation()->getAttrDictionary().getNamed(operand_segment_sizesAttrName())));
  return mutableRange;
}

::mlir::MutableOperandRange XEmboxOp::subcomponentMutable() {
  auto range = getODSOperandIndexAndLength(4);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(4u, *getOperation()->getAttrDictionary().getNamed(operand_segment_sizesAttrName())));
  return mutableRange;
}

::mlir::MutableOperandRange XEmboxOp::substrMutable() {
  auto range = getODSOperandIndexAndLength(5);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(5u, *getOperation()->getAttrDictionary().getNamed(operand_segment_sizesAttrName())));
  return mutableRange;
}

::mlir::MutableOperandRange XEmboxOp::lenParamsMutable() {
  auto range = getODSOperandIndexAndLength(6);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(6u, *getOperation()->getAttrDictionary().getNamed(operand_segment_sizesAttrName())));
  return mutableRange;
}

std::pair<unsigned, unsigned> XEmboxOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range XEmboxOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

void XEmboxOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value memref, ::mlir::ValueRange shape, ::mlir::ValueRange shift, ::mlir::ValueRange slice, ::mlir::ValueRange subcomponent, ::mlir::ValueRange substr, ::mlir::ValueRange lenParams) {
  odsState.addOperands(memref);
  odsState.addOperands(shape);
  odsState.addOperands(shift);
  odsState.addOperands(slice);
  odsState.addOperands(subcomponent);
  odsState.addOperands(substr);
  odsState.addOperands(lenParams);
  odsState.addAttribute(operand_segment_sizesAttrName(odsState.name), odsBuilder.getI32VectorAttr({1, static_cast<int32_t>(shape.size()), static_cast<int32_t>(shift.size()), static_cast<int32_t>(slice.size()), static_cast<int32_t>(subcomponent.size()), static_cast<int32_t>(substr.size()), static_cast<int32_t>(lenParams.size())}));
  odsState.addTypes(resultType0);
}

void XEmboxOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value memref, ::mlir::ValueRange shape, ::mlir::ValueRange shift, ::mlir::ValueRange slice, ::mlir::ValueRange subcomponent, ::mlir::ValueRange substr, ::mlir::ValueRange lenParams) {
  odsState.addOperands(memref);
  odsState.addOperands(shape);
  odsState.addOperands(shift);
  odsState.addOperands(slice);
  odsState.addOperands(subcomponent);
  odsState.addOperands(substr);
  odsState.addOperands(lenParams);
  odsState.addAttribute(operand_segment_sizesAttrName(odsState.name), odsBuilder.getI32VectorAttr({1, static_cast<int32_t>(shape.size()), static_cast<int32_t>(shift.size()), static_cast<int32_t>(slice.size()), static_cast<int32_t>(subcomponent.size()), static_cast<int32_t>(substr.size()), static_cast<int32_t>(lenParams.size())}));
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void XEmboxOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult XEmboxOp::verify() {
  {
    auto sizeAttr = (*this)->getAttr(operand_segment_sizesAttrName()).dyn_cast<::mlir::DenseIntElementsAttr>();
    if (!sizeAttr)
      return emitOpError("missing segment sizes attribute 'operand_segment_sizes'");
    auto numElements =
        sizeAttr.getType().cast<::mlir::ShapedType>().getNumElements();
    if (numElements != 7)
      return emitOpError("'operand_segment_sizes' attribute for specifying operand segments must have 7 "
                "elements, but got ") << numElements;
  }
    {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_CGOps4(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_CGOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_CGOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup3 = getODSOperands(3);

    for (auto v : valueGroup3) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_CGOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup4 = getODSOperands(4);

    for (auto v : valueGroup4) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_CGOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup5 = getODSOperands(5);

    for (auto v : valueGroup5) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_CGOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup6 = getODSOperands(6);

    for (auto v : valueGroup6) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_CGOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_CGOps5(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::ParseResult XEmboxOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::OperandType memrefRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::OperandType> memrefOperands(memrefRawOperands);  ::llvm::SMLoc memrefOperandsLoc;
  (void)memrefOperandsLoc;
  ::mlir::SmallVector<::mlir::OpAsmParser::OperandType, 4> shapeOperands;
  ::llvm::SMLoc shapeOperandsLoc;
  (void)shapeOperandsLoc;
  ::mlir::SmallVector<::mlir::OpAsmParser::OperandType, 4> shiftOperands;
  ::llvm::SMLoc shiftOperandsLoc;
  (void)shiftOperandsLoc;
  ::mlir::SmallVector<::mlir::OpAsmParser::OperandType, 4> sliceOperands;
  ::llvm::SMLoc sliceOperandsLoc;
  (void)sliceOperandsLoc;
  ::mlir::SmallVector<::mlir::OpAsmParser::OperandType, 4> subcomponentOperands;
  ::llvm::SMLoc subcomponentOperandsLoc;
  (void)subcomponentOperandsLoc;
  ::mlir::SmallVector<::mlir::OpAsmParser::OperandType, 4> substrOperands;
  ::llvm::SMLoc substrOperandsLoc;
  (void)substrOperandsLoc;
  ::mlir::SmallVector<::mlir::OpAsmParser::OperandType, 4> lenParamsOperands;
  ::llvm::SMLoc lenParamsOperandsLoc;
  (void)lenParamsOperandsLoc;
  ::llvm::ArrayRef<::mlir::Type> allOperandTypes;
  ::llvm::ArrayRef<::mlir::Type> allResultTypes;

  memrefOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(memrefRawOperands[0]))
    return ::mlir::failure();
  if (succeeded(parser.parseOptionalLParen())) {

  shapeOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(shapeOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
  }
  if (succeeded(parser.parseOptionalKeyword("origin"))) {

  shiftOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(shiftOperands))
    return ::mlir::failure();
  }
  if (succeeded(parser.parseOptionalLSquare())) {

  sliceOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(sliceOperands))
    return ::mlir::failure();
  if (parser.parseRSquare())
    return ::mlir::failure();
  }
  if (succeeded(parser.parseOptionalKeyword("path"))) {

  subcomponentOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(subcomponentOperands))
    return ::mlir::failure();
  }
  if (succeeded(parser.parseOptionalKeyword("substr"))) {

  substrOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(substrOperands))
    return ::mlir::failure();
  }
  if (succeeded(parser.parseOptionalKeyword("typeparams"))) {

  lenParamsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(lenParamsOperands))
    return ::mlir::failure();
  }
  if (parser.parseOptionalAttrDict(result.attributes))
    return ::mlir::failure();
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType allOperand__allResult_functionType;
  if (parser.parseType(allOperand__allResult_functionType))
    return ::mlir::failure();
  allOperandTypes = allOperand__allResult_functionType.getInputs();
  allResultTypes = allOperand__allResult_functionType.getResults();
  result.addAttribute("operand_segment_sizes", parser.getBuilder().getI32VectorAttr({1, static_cast<int32_t>(shapeOperands.size()), static_cast<int32_t>(shiftOperands.size()), static_cast<int32_t>(sliceOperands.size()), static_cast<int32_t>(subcomponentOperands.size()), static_cast<int32_t>(substrOperands.size()), static_cast<int32_t>(lenParamsOperands.size())}));
  result.addTypes(allResultTypes);
  if (parser.resolveOperands(::llvm::concat<const ::mlir::OpAsmParser::OperandType>(memrefOperands, shapeOperands, shiftOperands, sliceOperands, subcomponentOperands, substrOperands, lenParamsOperands), allOperandTypes, parser.getNameLoc(), result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void XEmboxOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << memref();
  if (!shape().empty()) {
  _odsPrinter << "(";
  _odsPrinter << shape();
  _odsPrinter << ")";
  }
  if (!shift().empty()) {
  _odsPrinter << ' ' << "origin";
  _odsPrinter << ' ';
  _odsPrinter << shift();
  }
  if (!slice().empty()) {
  _odsPrinter << "[";
  _odsPrinter << slice();
  _odsPrinter << "]";
  }
  if (!subcomponent().empty()) {
  _odsPrinter << ' ' << "path";
  _odsPrinter << ' ';
  _odsPrinter << subcomponent();
  }
  if (!substr().empty()) {
  _odsPrinter << ' ' << "substr";
  _odsPrinter << ' ';
  _odsPrinter << substr();
  }
  if (!lenParams().empty()) {
  _odsPrinter << ' ' << "typeparams";
  _odsPrinter << ' ';
  _odsPrinter << lenParams();
  }
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), /*elidedAttrs=*/{"operand_segment_sizes", });
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(getOperation()->getOperandTypes(), getOperation()->getResultTypes());
}

} // namespace cg
} // namespace fir
DEFINE_EXPLICIT_TYPE_ID(::fir::cg::XEmboxOp)

namespace fir {
namespace cg {

//===----------------------------------------------------------------------===//
// ::fir::cg::XReboxOp definitions
//===----------------------------------------------------------------------===//

XReboxOpAdaptor::XReboxOpAdaptor(::mlir::ValueRange values, ::mlir::DictionaryAttr attrs, ::mlir::RegionRange regions) : odsOperands(values), odsAttrs(attrs), odsRegions(regions) {}

XReboxOpAdaptor::XReboxOpAdaptor(XReboxOp &op) : odsOperands(op->getOperands()), odsAttrs(op->getAttrDictionary()), odsRegions(op->getRegions()) {}

::mlir::ValueRange XReboxOpAdaptor::getOperands() {
  return odsOperands;
}

std::pair<unsigned, unsigned> XReboxOpAdaptor::getODSOperandIndexAndLength(unsigned index) {
  assert(odsAttrs && "missing segment size attribute for op");
  auto sizeAttr = odsAttrs.get("operand_segment_sizes").cast<::mlir::DenseIntElementsAttr>();

  const uint32_t *sizeAttrValueIt = &*sizeAttr.value_begin<uint32_t>();
  if (sizeAttr.isSplat())
    return {*sizeAttrValueIt * index, *sizeAttrValueIt};

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttrValueIt[i];
  return {start, sizeAttrValueIt[index]};
}

::mlir::ValueRange XReboxOpAdaptor::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(odsOperands.begin(), valueRange.first),
           std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
}

::mlir::Value XReboxOpAdaptor::box() {
  return *getODSOperands(0).begin();
}

::mlir::ValueRange XReboxOpAdaptor::shape() {
  return getODSOperands(1);
}

::mlir::ValueRange XReboxOpAdaptor::shift() {
  return getODSOperands(2);
}

::mlir::ValueRange XReboxOpAdaptor::slice() {
  return getODSOperands(3);
}

::mlir::ValueRange XReboxOpAdaptor::subcomponent() {
  return getODSOperands(4);
}

::mlir::ValueRange XReboxOpAdaptor::substr() {
  return getODSOperands(5);
}

::mlir::DictionaryAttr XReboxOpAdaptor::getAttributes() {
  return odsAttrs;
}

::mlir::LogicalResult XReboxOpAdaptor::verify(::mlir::Location loc) {
  {
    auto sizeAttr = odsAttrs.get("operand_segment_sizes").dyn_cast<::mlir::DenseIntElementsAttr>();
    if (!sizeAttr)
      return emitError(loc, "'fircg.ext_rebox' op ""missing segment sizes attribute 'operand_segment_sizes'");
    auto numElements =
        sizeAttr.getType().cast<::mlir::ShapedType>().getNumElements();
    if (numElements != 6)
      return emitError(loc, "'fircg.ext_rebox' op ""'operand_segment_sizes' attribute for specifying operand segments must have 6 "
                "elements, but got ") << numElements;
  }
    return ::mlir::success();
}

std::pair<unsigned, unsigned> XReboxOp::getODSOperandIndexAndLength(unsigned index) {
  auto sizeAttr =
      (*this)->getAttr(operand_segment_sizesAttrName()).cast<::mlir::DenseIntElementsAttr>();

  const uint32_t *sizeAttrValueIt = &*sizeAttr.value_begin<uint32_t>();
  if (sizeAttr.isSplat())
    return {*sizeAttrValueIt * index, *sizeAttrValueIt};

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttrValueIt[i];
  return {start, sizeAttrValueIt[index]};
}

::mlir::Operation::operand_range XReboxOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value XReboxOp::box() {
  return *getODSOperands(0).begin();
}

::mlir::Operation::operand_range XReboxOp::shape() {
  return getODSOperands(1);
}

::mlir::Operation::operand_range XReboxOp::shift() {
  return getODSOperands(2);
}

::mlir::Operation::operand_range XReboxOp::slice() {
  return getODSOperands(3);
}

::mlir::Operation::operand_range XReboxOp::subcomponent() {
  return getODSOperands(4);
}

::mlir::Operation::operand_range XReboxOp::substr() {
  return getODSOperands(5);
}

::mlir::MutableOperandRange XReboxOp::boxMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(0u, *getOperation()->getAttrDictionary().getNamed(operand_segment_sizesAttrName())));
  return mutableRange;
}

::mlir::MutableOperandRange XReboxOp::shapeMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(1u, *getOperation()->getAttrDictionary().getNamed(operand_segment_sizesAttrName())));
  return mutableRange;
}

::mlir::MutableOperandRange XReboxOp::shiftMutable() {
  auto range = getODSOperandIndexAndLength(2);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(2u, *getOperation()->getAttrDictionary().getNamed(operand_segment_sizesAttrName())));
  return mutableRange;
}

::mlir::MutableOperandRange XReboxOp::sliceMutable() {
  auto range = getODSOperandIndexAndLength(3);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(3u, *getOperation()->getAttrDictionary().getNamed(operand_segment_sizesAttrName())));
  return mutableRange;
}

::mlir::MutableOperandRange XReboxOp::subcomponentMutable() {
  auto range = getODSOperandIndexAndLength(4);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(4u, *getOperation()->getAttrDictionary().getNamed(operand_segment_sizesAttrName())));
  return mutableRange;
}

::mlir::MutableOperandRange XReboxOp::substrMutable() {
  auto range = getODSOperandIndexAndLength(5);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(5u, *getOperation()->getAttrDictionary().getNamed(operand_segment_sizesAttrName())));
  return mutableRange;
}

std::pair<unsigned, unsigned> XReboxOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range XReboxOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

void XReboxOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value box, ::mlir::ValueRange shape, ::mlir::ValueRange shift, ::mlir::ValueRange slice, ::mlir::ValueRange subcomponent, ::mlir::ValueRange substr) {
  odsState.addOperands(box);
  odsState.addOperands(shape);
  odsState.addOperands(shift);
  odsState.addOperands(slice);
  odsState.addOperands(subcomponent);
  odsState.addOperands(substr);
  odsState.addAttribute(operand_segment_sizesAttrName(odsState.name), odsBuilder.getI32VectorAttr({1, static_cast<int32_t>(shape.size()), static_cast<int32_t>(shift.size()), static_cast<int32_t>(slice.size()), static_cast<int32_t>(subcomponent.size()), static_cast<int32_t>(substr.size())}));
  odsState.addTypes(resultType0);
}

void XReboxOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value box, ::mlir::ValueRange shape, ::mlir::ValueRange shift, ::mlir::ValueRange slice, ::mlir::ValueRange subcomponent, ::mlir::ValueRange substr) {
  odsState.addOperands(box);
  odsState.addOperands(shape);
  odsState.addOperands(shift);
  odsState.addOperands(slice);
  odsState.addOperands(subcomponent);
  odsState.addOperands(substr);
  odsState.addAttribute(operand_segment_sizesAttrName(odsState.name), odsBuilder.getI32VectorAttr({1, static_cast<int32_t>(shape.size()), static_cast<int32_t>(shift.size()), static_cast<int32_t>(slice.size()), static_cast<int32_t>(subcomponent.size()), static_cast<int32_t>(substr.size())}));
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void XReboxOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult XReboxOp::verify() {
  {
    auto sizeAttr = (*this)->getAttr(operand_segment_sizesAttrName()).dyn_cast<::mlir::DenseIntElementsAttr>();
    if (!sizeAttr)
      return emitOpError("missing segment sizes attribute 'operand_segment_sizes'");
    auto numElements =
        sizeAttr.getType().cast<::mlir::ShapedType>().getNumElements();
    if (numElements != 6)
      return emitOpError("'operand_segment_sizes' attribute for specifying operand segments must have 6 "
                "elements, but got ") << numElements;
  }
    {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_CGOps5(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_CGOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_CGOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup3 = getODSOperands(3);

    for (auto v : valueGroup3) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_CGOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup4 = getODSOperands(4);

    for (auto v : valueGroup4) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_CGOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup5 = getODSOperands(5);

    for (auto v : valueGroup5) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_CGOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_CGOps5(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::ParseResult XReboxOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::OperandType boxRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::OperandType> boxOperands(boxRawOperands);  ::llvm::SMLoc boxOperandsLoc;
  (void)boxOperandsLoc;
  ::mlir::SmallVector<::mlir::OpAsmParser::OperandType, 4> shapeOperands;
  ::llvm::SMLoc shapeOperandsLoc;
  (void)shapeOperandsLoc;
  ::mlir::SmallVector<::mlir::OpAsmParser::OperandType, 4> shiftOperands;
  ::llvm::SMLoc shiftOperandsLoc;
  (void)shiftOperandsLoc;
  ::mlir::SmallVector<::mlir::OpAsmParser::OperandType, 4> sliceOperands;
  ::llvm::SMLoc sliceOperandsLoc;
  (void)sliceOperandsLoc;
  ::mlir::SmallVector<::mlir::OpAsmParser::OperandType, 4> subcomponentOperands;
  ::llvm::SMLoc subcomponentOperandsLoc;
  (void)subcomponentOperandsLoc;
  ::mlir::SmallVector<::mlir::OpAsmParser::OperandType, 4> substrOperands;
  ::llvm::SMLoc substrOperandsLoc;
  (void)substrOperandsLoc;
  ::llvm::ArrayRef<::mlir::Type> allOperandTypes;
  ::llvm::ArrayRef<::mlir::Type> allResultTypes;

  boxOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(boxRawOperands[0]))
    return ::mlir::failure();
  if (succeeded(parser.parseOptionalLParen())) {

  shapeOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(shapeOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
  }
  if (succeeded(parser.parseOptionalKeyword("origin"))) {

  shiftOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(shiftOperands))
    return ::mlir::failure();
  }
  if (succeeded(parser.parseOptionalLSquare())) {

  sliceOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(sliceOperands))
    return ::mlir::failure();
  if (parser.parseRSquare())
    return ::mlir::failure();
  }
  if (succeeded(parser.parseOptionalKeyword("path"))) {

  subcomponentOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(subcomponentOperands))
    return ::mlir::failure();
  }
  if (succeeded(parser.parseOptionalKeyword("substr"))) {

  substrOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(substrOperands))
    return ::mlir::failure();
  }
  if (parser.parseOptionalAttrDict(result.attributes))
    return ::mlir::failure();
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType allOperand__allResult_functionType;
  if (parser.parseType(allOperand__allResult_functionType))
    return ::mlir::failure();
  allOperandTypes = allOperand__allResult_functionType.getInputs();
  allResultTypes = allOperand__allResult_functionType.getResults();
  result.addAttribute("operand_segment_sizes", parser.getBuilder().getI32VectorAttr({1, static_cast<int32_t>(shapeOperands.size()), static_cast<int32_t>(shiftOperands.size()), static_cast<int32_t>(sliceOperands.size()), static_cast<int32_t>(subcomponentOperands.size()), static_cast<int32_t>(substrOperands.size())}));
  result.addTypes(allResultTypes);
  if (parser.resolveOperands(::llvm::concat<const ::mlir::OpAsmParser::OperandType>(boxOperands, shapeOperands, shiftOperands, sliceOperands, subcomponentOperands, substrOperands), allOperandTypes, parser.getNameLoc(), result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void XReboxOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << box();
  if (!shape().empty()) {
  _odsPrinter << "(";
  _odsPrinter << shape();
  _odsPrinter << ")";
  }
  if (!shift().empty()) {
  _odsPrinter << ' ' << "origin";
  _odsPrinter << ' ';
  _odsPrinter << shift();
  }
  if (!slice().empty()) {
  _odsPrinter << "[";
  _odsPrinter << slice();
  _odsPrinter << "]";
  }
  if (!subcomponent().empty()) {
  _odsPrinter << ' ' << "path";
  _odsPrinter << ' ';
  _odsPrinter << subcomponent();
  }
  if (!substr().empty()) {
  _odsPrinter << ' ' << "substr";
  _odsPrinter << ' ';
  _odsPrinter << substr();
  }
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), /*elidedAttrs=*/{"operand_segment_sizes", });
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(getOperation()->getOperandTypes(), getOperation()->getResultTypes());
}

} // namespace cg
} // namespace fir
DEFINE_EXPLICIT_TYPE_ID(::fir::cg::XReboxOp)


#endif  // GET_OP_CLASSES

