# This file allows users to call find_package(MLIR) and pick up our targets.


# Compute the installation prefix from this MLIRConfig.cmake file location.
get_filename_component(MLIR_INSTALL_PREFIX "${CMAKE_CURRENT_LIST_FILE}" PATH)
get_filename_component(MLIR_INSTALL_PREFIX "${MLIR_INSTALL_PREFIX}" PATH)
get_filename_component(MLIR_INSTALL_PREFIX "${MLIR_INSTALL_PREFIX}" PATH)
get_filename_component(MLIR_INSTALL_PREFIX "${MLIR_INSTALL_PREFIX}" PATH)

find_package(LLVM REQUIRED CONFIG
             HINTS "${MLIR_INSTALL_PREFIX}/lib/cmake/llvm")

set(MLIR_EXPORTED_TARGETS "MLIRAnalysis;MLIRLoopAnalysis;MLIRPresburger;MLIRAffineToStandard;MLIRAVX512ToLLVM;MLIRGPUToGPURuntimeTransforms;MLIRGPUToNVVMTransforms;MLIRGPUToROCDLTransforms;MLIRGPUToSPIRVTransforms;MLIRGPUToVulkanTransforms;MLIRLinalgToLLVM;MLIRLinalgToSPIRVTransforms;MLIRLinalgToStandard;MLIRSCFToGPU;MLIRSCFToSPIRV;MLIRSCFToStandard;MLIRShapeToSCF;MLIRShapeToStandard;MLIRSPIRVToLLVM;MLIRStandardToLLVM;MLIRStandardToSPIRVTransforms;MLIRVectorToROCDL;MLIRVectorToLLVM;MLIRVectorToSCF;MLIRAffineOps;MLIRAffineEDSC;MLIRAffineTransforms;MLIRAffineUtils;MLIRAVX512;MLIRGPU;MLIRLinalgAnalysis;MLIRLinalgEDSC;MLIRLinalgOps;MLIRLinalgTransforms;MLIRLinalgUtils;MLIRLLVMIRTransforms;MLIRLLVMIR;MLIRLLVMAVX512;MLIRNVVMIR;MLIRROCDLIR;MLIROpenMP;MLIRQuant;MLIRSCF;MLIRSCFTransforms;MLIRSDBM;MLIRShape;MLIRShapeOpsTransforms;MLIRSPIRV;MLIRSPIRVSerialization;MLIRSPIRVTransforms;MLIRStandardOps;MLIRStandardOpsTransforms;MLIRVector;MLIRDialect;MLIREDSC;MLIREDSCInterface;MLIRExecutionEngine;MLIRJitRunner;mlir_c_runner_utils;mlir_c_runner_utils_static;mlir_runner_utils;MLIRIR;MLIRCallInterfaces;MLIRControlFlowInterfaces;MLIRCopyOpInterface;MLIRDerivedAttributeOpInterface;MLIRInferTypeOpInterface;MLIRLoopLikeInterface;MLIRSideEffectInterfaces;MLIRVectorUnrollInterface;MLIRViewLikeInterface;MLIRParser;MLIRPass;MLIRReduce;MLIRSupport;MLIROptLib;MLIRTableGen;MLIRTargetLLVMIRModuleTranslation;MLIRTargetAVX512;MLIRTargetLLVMIR;MLIRTargetNVVMIR;MLIRTargetROCDLIR;MLIRTransformUtils;MLIRTransforms;MLIRTranslation;MLIRMlirOptMain;MLIR")
set(MLIR_CMAKE_DIR "${MLIR_INSTALL_PREFIX}/lib/cmake/mlir")
set(MLIR_INCLUDE_DIRS "${MLIR_INSTALL_PREFIX}/include")
set(MLIR_TABLEGEN_EXE "mlir-tblgen")

# For mlir_tablegen()
set(MLIR_INCLUDE_DIR "/opt/local/var/macports/build/_opt_bblocal_var_buildworker_ports_build_ports_lang_llvm-11/flang-11/work/build/tools/mlir/include")
set(MLIR_MAIN_SRC_DIR "/opt/local/var/macports/build/_opt_bblocal_var_buildworker_ports_build_ports_lang_llvm-11/flang-11/work/llvm-project/llvm/tools/mlir")

set_property(GLOBAL PROPERTY MLIR_ALL_LIBS "MLIRAnalysis;MLIRLoopAnalysis;MLIRPresburger;MLIRAffineToStandard;MLIRAVX512ToLLVM;MLIRGPUToGPURuntimeTransforms;MLIRGPUToNVVMTransforms;MLIRGPUToROCDLTransforms;MLIRGPUToSPIRVTransforms;MLIRGPUToVulkanTransforms;MLIRLinalgToLLVM;MLIRLinalgToSPIRVTransforms;MLIRLinalgToStandard;MLIRSCFToGPU;MLIRSCFToSPIRV;MLIRSCFToStandard;MLIRShapeToSCF;MLIRShapeToStandard;MLIRSPIRVToLLVM;MLIRStandardToLLVM;MLIRStandardToSPIRVTransforms;MLIRVectorToROCDL;MLIRVectorToLLVM;MLIRVectorToSCF;MLIRAffineOps;MLIRAffineEDSC;MLIRAffineTransforms;MLIRAffineUtils;MLIRAVX512;MLIRGPU;MLIRLinalgAnalysis;MLIRLinalgEDSC;MLIRLinalgOps;MLIRLinalgTransforms;MLIRLinalgUtils;MLIRLLVMIRTransforms;MLIRLLVMIR;MLIRLLVMAVX512;MLIRNVVMIR;MLIRROCDLIR;MLIROpenMP;MLIRQuant;MLIRSCF;MLIRSCFTransforms;MLIRSDBM;MLIRShape;MLIRShapeOpsTransforms;MLIRSPIRV;MLIRSPIRVSerialization;MLIRSPIRVTransforms;MLIRStandardOps;MLIRStandardOpsTransforms;MLIRVector;MLIRDialect;MLIREDSC;MLIREDSCInterface;MLIRExecutionEngine;MLIRJitRunner;mlir_c_runner_utils;mlir_c_runner_utils_static;mlir_runner_utils;MLIRIR;MLIRCallInterfaces;MLIRControlFlowInterfaces;MLIRCopyOpInterface;MLIRDerivedAttributeOpInterface;MLIRInferTypeOpInterface;MLIRLoopLikeInterface;MLIRSideEffectInterfaces;MLIRVectorUnrollInterface;MLIRViewLikeInterface;MLIRParser;MLIRPass;MLIRReduce;MLIRSupport;MLIROptLib;MLIRTableGen;MLIRTargetLLVMIRModuleTranslation;MLIRTargetAVX512;MLIRTargetLLVMIR;MLIRTargetNVVMIR;MLIRTargetROCDLIR;MLIRTransformUtils;MLIRTransforms;MLIRTranslation;MLIRMlirOptMain;MLIR")
set_property(GLOBAL PROPERTY MLIR_DIALECT_LIBS "MLIRAffineOps;MLIRAffineEDSC;MLIRAffineTransforms;MLIRAffineUtils;MLIRAVX512;MLIRGPU;MLIRLinalgAnalysis;MLIRLinalgEDSC;MLIRLinalgOps;MLIRLinalgTransforms;MLIRLinalgUtils;MLIRLLVMIRTransforms;MLIRLLVMIR;MLIRLLVMAVX512;MLIRNVVMIR;MLIRROCDLIR;MLIROpenMP;MLIRQuant;MLIRSCF;MLIRSCFTransforms;MLIRSDBM;MLIRShape;MLIRShapeOpsTransforms;MLIRSPIRV;MLIRSPIRVSerialization;MLIRSPIRVTransforms;MLIRStandardOps;MLIRStandardOpsTransforms;MLIRVector")
set_property(GLOBAL PROPERTY MLIR_CONVERSION_LIBS "MLIRAffineToStandard;MLIRAVX512ToLLVM;MLIRGPUToGPURuntimeTransforms;MLIRGPUToNVVMTransforms;MLIRGPUToROCDLTransforms;MLIRGPUToSPIRVTransforms;MLIRGPUToVulkanTransforms;MLIRLinalgToLLVM;MLIRLinalgToSPIRVTransforms;MLIRLinalgToStandard;MLIRSCFToGPU;MLIRSCFToSPIRV;MLIRSCFToStandard;MLIRShapeToSCF;MLIRShapeToStandard;MLIRSPIRVToLLVM;MLIRStandardToLLVM;MLIRStandardToSPIRVTransforms;MLIRVectorToROCDL;MLIRVectorToLLVM;MLIRVectorToSCF")
set_property(GLOBAL PROPERTY MLIR_TRANSLATION_LIBS "MLIRTargetLLVMIRModuleTranslation;MLIRTargetAVX512;MLIRTargetLLVMIR;MLIRTargetNVVMIR;MLIRTargetROCDLIR")

# Provide all our library targets to users.
include("${MLIR_CMAKE_DIR}/MLIRTargets.cmake")

# By creating these targets here, subprojects that depend on MLIR's
# tablegen-generated headers can always depend on these targets whether building
# in-tree with MLIR or not.
if(NOT TARGET mlir-tablegen-targets)
  add_custom_target(mlir-tablegen-targets)
endif()
if(NOT TARGET mlir-headers)
  add_custom_target(mlir-headers)
endif()
if(NOT TARGET mlir-generic-headers)
  add_custom_target(mlir-generic-headers)
endif()
if(NOT TARGET mlir-doc)
  add_custom_target(mlir-doc)
endif()
